/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.links;

import java.net.URI;
import java.util.Optional;
import org.scijava.links.LinkHandler;
import org.scijava.log.LogService;
import org.scijava.plugin.HandlerService;
import org.scijava.service.SciJavaService;

public interface LinkService
extends HandlerService<URI, LinkHandler>,
SciJavaService {
    default public void handle(URI uri) {
        Optional<LinkHandler> match = this.getInstances().stream().filter(handler -> handler.supports(uri)).findFirst();
        if (!match.isPresent()) {
            LogService log = this.log();
            if (log != null) {
                log.debug((Object)("No handler for URI: " + uri));
            }
            return;
        }
        match.get().handle(uri);
    }

    default public Class<LinkHandler> getPluginType() {
        return LinkHandler.class;
    }

    default public Class<URI> getType() {
        return URI.class;
    }
}

