/*
 * Decompiled with CFR 0.152.
 */
package Utilities;

import Utilities.Object3D;
import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.NewImage;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.process.ImageProcessor;
import java.awt.Font;
import java.util.Arrays;
import java.util.Vector;

public class Counter3D {
    int thr = 0;
    boolean[] isSurf;
    int width = 1;
    int height = 1;
    int nbSlices = 1;
    int length = 1;
    int depth = 8;
    Calibration cal;
    String title = "img";
    int minSize;
    int maxSize;
    int nbObj = 0;
    int nbSurfPix = 0;
    int[] imgArray;
    int[] objID;
    int[] IDcount;
    int[] surfList;
    boolean[] IDisAtEdge;
    int[][] surfCoord;
    float[][] centreOfMass;
    float[][] centroid;
    boolean sizeFilter = true;
    boolean exclude = false;
    boolean redirect = false;
    boolean closeImg = Prefs.get((String)"3D-OC-Options_closeImg.boolean", (boolean)false);
    boolean showMaskedImg = Prefs.get((String)"3D-OC-Options_showMaskedImg.boolean", (boolean)true);
    Vector<Object3D> obj;
    boolean foundObjects = false;
    boolean getObjects = false;
    boolean getCentreOfMass = false;
    boolean getCentroid = false;
    boolean getSurfList = false;
    boolean getSurfCoord = false;

    public Counter3D(ImagePlus img, int thr, int min, int max, boolean exclude, boolean redirect) {
        this.width = img.getWidth();
        this.height = img.getHeight();
        this.nbSlices = img.getNSlices();
        this.length = this.width * this.height * this.nbSlices;
        this.depth = img.getBitDepth();
        this.title = img.getTitle();
        this.cal = img.getCalibration();
        this.thr = thr;
        this.minSize = min;
        this.maxSize = max;
        this.sizeFilter = true;
        this.exclude = exclude;
        this.redirect = redirect;
        if (this.depth != 8 && this.depth != 16) {
            throw new IllegalArgumentException("Counter3D class expects 8- or 16-bits images only");
        }
        this.nbObj = this.length;
        this.imgArray = new int[this.length];
        this.imgArrayModifier(img);
    }

    public Counter3D(ImagePlus img, int thr) {
        this(img, thr, 1, img.getWidth() * img.getHeight() * img.getNSlices(), false, false);
        this.sizeFilter = false;
    }

    public Counter3D(ImagePlus img) {
        this(img, 0, 1, img.getWidth() * img.getHeight() * img.getNSlices(), false, false);
        this.sizeFilter = false;
    }

    public Counter3D(int[] img, String title, int width, int height, int nbSlices, int thr, int min, int max, boolean exclude, boolean redirect, Calibration cal) {
        this.title = title;
        this.width = width;
        this.height = height;
        this.nbSlices = nbSlices;
        this.length = width * height * nbSlices;
        if (this.length != img.length) {
            throw new IllegalArgumentException("The image array length differs from the given image dimensions");
        }
        this.title = title;
        this.cal = cal;
        this.thr = thr;
        this.minSize = min;
        this.maxSize = max;
        this.sizeFilter = true;
        this.exclude = exclude;
        this.redirect = redirect;
        this.nbObj = this.length;
        this.imgArray = img;
        this.imgArrayModifier();
    }

    public Counter3D(int[] img, String title, int width, int height, int nbSlices, int thr, Calibration cal) {
        this(img, title, width, height, nbSlices, thr, 1, width * height * nbSlices, false, false, cal);
        this.sizeFilter = false;
    }

    public Counter3D(int[] img, String title, int width, int height, int nbSlices, int thr) {
        this(img, title, width, height, nbSlices, thr, 1, width * height * nbSlices, false, false, new Calibration());
        this.sizeFilter = false;
    }

    public Counter3D(int[] img, String title, int width, int height, int nbSlices, Calibration cal) {
        this(img, title, width, height, nbSlices, 0, 1, width * height * nbSlices, false, false, cal);
        this.sizeFilter = false;
    }

    public Counter3D(int[] img, String title, int width, int height, int nbSlices) {
        this(img, title, width, height, nbSlices, 0, 1, width * height * nbSlices, false, false, new Calibration());
        this.sizeFilter = false;
    }

    private void findObjects() {
        int x;
        int y;
        int z;
        int currID = 0;
        int currPos = 0;
        int minID = 0;
        int surfPix = 0;
        int neigbNb = 0;
        long start = System.currentTimeMillis();
        this.objID = new int[this.length];
        for (z = 1; z <= this.nbSlices; ++z) {
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    if (minID == currID) {
                        ++currID;
                    }
                    if (this.imgArray[currPos] != 0) {
                        minID = currID;
                        this.objID[currPos] = minID = this.minAntTag(minID, x, y, z);
                    }
                    ++currPos;
                }
            }
            IJ.showStatus((String)"Step 1/3: Finding structures");
            IJ.showProgress((int)z, (int)this.nbSlices);
        }
        IJ.showStatus((String)"");
        this.IDcount = new int[currID];
        for (int i = 0; i < this.length; ++i) {
            int n = this.objID[i];
            this.IDcount[n] = this.IDcount[n] + 1;
        }
        this.IDisAtEdge = new boolean[currID];
        Arrays.fill(this.IDisAtEdge, false);
        this.isSurf = new boolean[this.length];
        currPos = 0;
        minID = 1;
        for (z = 1; z <= this.nbSlices; ++z) {
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    if (this.imgArray[currPos] != 0) {
                        int pos;
                        int neigbX;
                        int neigbY;
                        int neigbZ;
                        minID = this.objID[currPos];
                        surfPix = 0;
                        neigbNb = 0;
                        for (neigbZ = z - 1; neigbZ <= z + 1; ++neigbZ) {
                            for (neigbY = y - 1; neigbY <= y + 1; ++neigbY) {
                                for (neigbX = x - 1; neigbX <= x + 1; ++neigbX) {
                                    if (neigbX < 0 || neigbX >= this.width || neigbY < 0 || neigbY >= this.height || neigbZ < 1 || neigbZ > this.nbSlices) continue;
                                    pos = this.offset(neigbX, neigbY, neigbZ);
                                    if (this.imgArray[pos] != 0) {
                                        if (this.nbSlices > 1 && (neigbX == x && neigbY == y && neigbZ == z - 1 || neigbX == x && neigbY == y && neigbZ == z + 1) || neigbX == x && neigbY == y - 1 && neigbZ == z || neigbX == x && neigbY == y + 1 && neigbZ == z || neigbX == x - 1 && neigbY == y && neigbZ == z || neigbX == x + 1 && neigbY == y && neigbZ == z) {
                                            ++surfPix;
                                        }
                                        minID = Math.min(minID, this.objID[pos]);
                                    }
                                    ++neigbNb;
                                }
                            }
                        }
                        if (surfPix != 6 && this.nbSlices > 1 || surfPix != 4 && this.nbSlices == 1) {
                            this.isSurf[currPos] = true;
                            ++this.nbSurfPix;
                        } else {
                            this.isSurf[currPos] = false;
                        }
                        for (neigbZ = z - 1; neigbZ <= z + 1; ++neigbZ) {
                            for (neigbY = y - 1; neigbY <= y + 1; ++neigbY) {
                                for (neigbX = x - 1; neigbX <= x + 1; ++neigbX) {
                                    int currPixID;
                                    if (neigbX < 0 || neigbX >= this.width || neigbY < 0 || neigbY >= this.height || neigbZ < 1 || neigbZ > this.nbSlices || this.imgArray[pos = this.offset(neigbX, neigbY, neigbZ)] == 0 || (currPixID = this.objID[pos]) <= minID) continue;
                                    this.replaceID(currPixID, minID);
                                }
                            }
                        }
                        if (x == 0 || y == 0 || x == this.width - 1 || y == this.height - 1 || this.nbSlices != 1 && (z == 1 || z == this.nbSlices)) {
                            this.IDisAtEdge[minID] = true;
                        }
                    }
                    ++currPos;
                }
            }
            IJ.showStatus((String)"Step 2/3: Connecting structures");
            IJ.showProgress((int)z, (int)this.nbSlices);
        }
        IJ.showStatus((String)"");
        int newCurrID = 0;
        for (int i = 1; i < this.IDcount.length; ++i) {
            if (!(this.IDcount[i] == 0 || this.IDcount[i] < this.minSize || this.IDcount[i] > this.maxSize || this.exclude && this.exclude && this.IDisAtEdge[i])) {
                int nbPix = this.IDcount[i];
                this.replaceID(i, ++newCurrID);
                this.IDcount[newCurrID] = nbPix;
            } else {
                this.replaceID(i, 0);
            }
            IJ.showStatus((String)"Step 3/3: Renumbering structures");
            IJ.showProgress((int)i, (int)currID);
        }
        IJ.showStatus((String)"");
        if (this.redirect) {
            this.prepareImgArrayForRedirect();
        }
        if (this.showMaskedImg) {
            this.buildImg(this.imgArray, null, "Masked image for " + this.title, false, false, false, 0, 0).show();
        }
        this.nbObj = newCurrID;
        this.foundObjects = true;
    }

    public void getObjects() {
        if (!this.foundObjects) {
            this.findObjects();
        }
        if (!this.getObjects) {
            this.obj = new Vector();
            for (int i = 0; i < this.nbObj; ++i) {
                this.obj.add(new Object3D(this.IDcount[i + 1], this.cal));
            }
            this.IDcount = null;
            int currPos = 0;
            for (int z = 1; z <= this.nbSlices; ++z) {
                for (int y = 0; y < this.height; ++y) {
                    for (int x = 0; x < this.width; ++x) {
                        int currID = this.objID[currPos];
                        if (currID != 0) {
                            float surf = 0.0f;
                            if (this.nbSlices == 1) {
                                surf = (float)(this.cal.pixelWidth * this.cal.pixelHeight);
                            }
                            if (this.isSurf[currPos] && this.nbSlices > 1) {
                                surf = (float)(2.0 * (this.cal.pixelHeight * this.cal.pixelDepth + this.cal.pixelWidth * this.cal.pixelDepth + this.cal.pixelWidth * this.cal.pixelHeight));
                                if (x > 0 && this.objID[this.offset(x - 1, y, z)] == currID) {
                                    surf = (float)((double)surf - this.cal.pixelHeight * this.cal.pixelDepth);
                                }
                                if (x < this.width - 1 && this.objID[this.offset(x + 1, y, z)] == currID) {
                                    surf = (float)((double)surf - this.cal.pixelHeight * this.cal.pixelDepth);
                                }
                                if (y > 0 && this.objID[this.offset(x, y - 1, z)] == currID) {
                                    surf = (float)((double)surf - this.cal.pixelWidth * this.cal.pixelDepth);
                                }
                                if (y < this.height - 1 && this.objID[this.offset(x, y + 1, z)] == currID) {
                                    surf = (float)((double)surf - this.cal.pixelWidth * this.cal.pixelDepth);
                                }
                                if (z > 1 && this.objID[this.offset(x, y, z - 1)] == currID) {
                                    surf = (float)((double)surf - this.cal.pixelWidth * this.cal.pixelHeight);
                                }
                                if (z <= this.nbSlices - 1 && this.objID[this.offset(x, y, z + 1)] == currID) {
                                    surf = (float)((double)surf - this.cal.pixelWidth * this.cal.pixelHeight);
                                }
                            }
                            this.obj.get(currID - 1).addVoxel(x, y, z, this.imgArray[currPos], this.isSurf[currPos], surf);
                        }
                        ++currPos;
                    }
                }
            }
            this.imgArray = null;
            System.gc();
        }
        this.getObjects = true;
    }

    public Object3D getObject(int index) {
        if (!this.getObjects) {
            this.getObjects();
        }
        if (index < 0 || index >= this.nbObj) {
            return null;
        }
        return this.obj.get(index);
    }

    public void addObject(Object3D object) {
        if (!this.getObjects) {
            this.getObjects();
        }
        this.obj.add(object);
        ++this.nbObj;
    }

    public void removeObject(int index) {
        if (!this.getObjects) {
            this.getObjects();
        }
        if (index >= 0 && index < this.nbObj) {
            this.obj.remove(index);
            --this.nbObj;
        }
    }

    public Vector getObjectsList() {
        if (!this.getObjects) {
            this.getObjects();
        }
        return this.obj;
    }

    public ImagePlus getObjMap(boolean drawNb, int fontSize) {
        if (!this.getObjects) {
            this.getObjects();
        }
        if (!this.getCentroid) {
            this.populateCentroid();
        }
        return this.buildImg(this.objID, this.coord2imgArray(this.centroid), "Objects map of " + this.title, false, drawNb, true, 0, fontSize);
    }

    public ImagePlus getObjMap() {
        if (!this.getObjects) {
            this.getObjects();
        }
        return this.buildImg(this.objID, null, "Objects map of " + this.title, false, false, true, 0, 0);
    }

    public int[] getObjMapAsArray() {
        if (!this.getObjects) {
            this.getObjects();
        }
        return this.objID;
    }

    private void populateCentreOfMass() {
        if (!this.getObjects) {
            this.getObjects();
        }
        this.centreOfMass = new float[this.obj.size()][3];
        for (int i = 0; i < this.obj.size(); ++i) {
            Object3D currObj = this.obj.get(i);
            float[] tmp = currObj.c_mass;
            for (int j = 0; j < 3; ++j) {
                this.centreOfMass[i][j] = tmp[j];
            }
        }
        this.getCentreOfMass = true;
    }

    public float[][] getCentreOfMassList() {
        if (!this.getCentreOfMass) {
            this.populateCentreOfMass();
        }
        return this.centreOfMass;
    }

    public ImagePlus getCentreOfMassMap(boolean drawNb, boolean whiteNb, int dotSize, int fontSize) {
        if (!this.getCentreOfMass) {
            this.populateCentreOfMass();
        }
        int[] array = this.coord2imgArray(this.centreOfMass);
        return this.buildImg(array, array, "Centres of mass map of " + this.title, true, drawNb, whiteNb, dotSize, fontSize);
    }

    public ImagePlus getCentreOfMassMap() {
        if (!this.getCentreOfMass) {
            this.populateCentreOfMass();
        }
        int[] array = this.coord2imgArray(this.centreOfMass);
        return this.buildImg(array, null, "Centres of mass map of " + this.title, true, false, false, 5, 0);
    }

    private void populateCentroid() {
        if (!this.getObjects) {
            this.getObjects();
        }
        this.centroid = new float[this.obj.size()][3];
        for (int i = 0; i < this.obj.size(); ++i) {
            Object3D currObj = this.obj.get(i);
            float[] tmp = currObj.centroid;
            for (int j = 0; j < 3; ++j) {
                this.centroid[i][j] = tmp[j];
            }
        }
        this.getCentroid = true;
    }

    public float[][] getCentroidList() {
        if (!this.getCentroid) {
            this.populateCentroid();
        }
        return this.centroid;
    }

    public ImagePlus getCentroidMap(boolean drawNb, boolean whiteNb, int dotSize, int fontSize) {
        if (!this.getCentroid) {
            this.populateCentroid();
        }
        int[] array = this.coord2imgArray(this.centroid);
        return this.buildImg(array, array, "Centroids map of " + this.title, true, drawNb, whiteNb, dotSize, fontSize);
    }

    public ImagePlus getCentroidMap() {
        if (!this.getCentroid) {
            this.populateCentroid();
        }
        int[] array = this.coord2imgArray(this.centroid);
        return this.buildImg(array, null, "Centroids map of " + this.title, true, false, false, 5, 0);
    }

    private void populateSurfList() {
        if (!this.getObjects) {
            this.getObjects();
        }
        this.surfList = new int[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.surfList[i] = this.isSurf[i] ? this.objID[i] : 0;
        }
        this.getSurfList = true;
    }

    public int[] getSurfPixList() {
        if (!this.getSurfList) {
            this.populateSurfList();
        }
        return this.surfList;
    }

    private void populateSurfPixCoord() {
        int index = 0;
        this.surfCoord = new int[this.nbSurfPix][4];
        for (int i = 0; i < this.nbObj; ++i) {
            Object3D currObj = this.obj.get(i);
            for (int j = 0; j < currObj.surf_size; ++j) {
                this.surfCoord[index][0] = i + 1;
                for (int k = 1; k < 4; ++k) {
                    this.surfCoord[index][k] = currObj.obj_voxels[j][k - 1];
                }
                ++index;
            }
        }
    }

    public int[][] getSurfPixCoord() {
        if (!this.getSurfCoord) {
            this.populateSurfPixCoord();
        }
        return this.surfCoord;
    }

    public ImagePlus getSurfPixMap(boolean drawNb, boolean whiteNb, int fontSize) {
        if (!this.getSurfList) {
            this.populateSurfList();
        }
        if (!this.getCentroid) {
            this.populateCentroid();
        }
        return this.buildImg(this.surfList, this.coord2imgArray(this.centroid), "Surface map of " + this.title, false, drawNb, whiteNb, 0, fontSize);
    }

    public ImagePlus getSurfPixMap() {
        if (!this.getSurfList) {
            this.populateSurfList();
        }
        return this.buildImg(this.surfList, null, "Surface map of " + this.title, false, false, false, 0, 0);
    }

    private int[] coord2imgArray(float[][] coord) {
        int[] array = new int[this.length];
        for (int i = 0; i < coord.length; ++i) {
            array[this.offset((int)((int)coord[i][0]), (int)((int)coord[i][1]), (int)((int)coord[i][2]))] = i + 1;
        }
        return array;
    }

    private void imgArrayModifier(ImagePlus img) {
        int index = 0;
        for (int i = 1; i <= this.nbSlices; ++i) {
            img.setSlice(i);
            for (int j = 0; j < this.height; ++j) {
                for (int k = 0; k < this.width; ++k) {
                    this.imgArray[index] = img.getProcessor().getPixel(k, j);
                    if (this.imgArray[index] < this.thr) {
                        this.imgArray[index] = 0;
                        --this.nbObj;
                    }
                    ++index;
                }
            }
        }
        if (this.closeImg) {
            img.close();
        }
        if (this.nbObj <= 0) {
            IJ.error((String)"No object found");
            return;
        }
    }

    private void imgArrayModifier() {
        int index = 0;
        for (int i = 1; i <= this.nbSlices; ++i) {
            for (int j = 0; j < this.height; ++j) {
                for (int k = 0; k < this.width; ++k) {
                    if (this.imgArray[index] < this.thr) {
                        this.imgArray[index] = 0;
                        --this.nbObj;
                    }
                    ++index;
                }
            }
        }
        if (this.nbObj <= 0) {
            IJ.error((String)"No object found");
            return;
        }
    }

    private void prepareImgArrayForRedirect() {
        int index = 0;
        ImagePlus imgRedir = WindowManager.getImage((String)Prefs.get((String)"3D-OC-Options_redirectTo.string", (String)"none"));
        this.title = this.title + " redirect to " + imgRedir.getTitle();
        for (int i = 1; i <= this.nbSlices; ++i) {
            imgRedir.setSlice(i);
            for (int j = 0; j < this.height; ++j) {
                for (int k = 0; k < this.width; ++k) {
                    this.imgArray[index] = this.objID[index] != 0 ? imgRedir.getProcessor().getPixel(k, j) : 0;
                    ++index;
                }
            }
        }
        if (this.closeImg) {
            imgRedir.close();
        }
    }

    public void showStatistics(boolean newRT) {
        int i;
        ResultsTable rt;
        if (!this.getObjects) {
            this.getObjects();
        }
        float calXYZ = (float)(this.cal.pixelWidth * this.cal.pixelHeight * this.cal.pixelDepth);
        String unit = this.cal.getUnit();
        String[] header = new String[]{"Volume (" + unit + "^3)", "Surface (" + unit + "^2)", "Nb of obj. voxels", "Nb of surf. voxels", "IntDen", "Mean", "StdDev", "Median", "Min", "Max", "X", "Y", "Z", "Mean dist. to surf. (" + unit + ")", "SD dist. to surf. (" + unit + ")", "Median dist. to surf. (" + unit + ")", "XM", "YM", "ZM", "BX", "BY", "BZ", "B-width", "B-height", "B-depth"};
        if (newRT) {
            rt = new ResultsTable();
        } else {
            rt = ResultsTable.getResultsTable();
            rt.reset();
        }
        for (i = 0; i < header.length; ++i) {
            rt.setHeading(i, header[i]);
        }
        for (i = 0; i < this.nbObj; ++i) {
            float[] tmpArray;
            rt.incrementCounter();
            Object3D currObj = this.obj.get(i);
            if (Prefs.get((String)"3D-OC-Options_volume.boolean", (boolean)true)) {
                rt.setValue("Volume (" + unit + "^3)", i, (double)((float)currObj.size * calXYZ));
            }
            if (Prefs.get((String)"3D-OC-Options_surface.boolean", (boolean)true)) {
                rt.setValue("Surface (" + unit + "^2)", i, (double)currObj.surf_cal);
            }
            if (Prefs.get((String)"3D-OC-Options_objVox.boolean", (boolean)true)) {
                rt.setValue("Nb of obj. voxels", i, (double)currObj.size);
            }
            if (Prefs.get((String)"3D-OC-Options_surfVox.boolean", (boolean)true)) {
                rt.setValue("Nb of surf. voxels", i, (double)currObj.surf_size);
            }
            if (Prefs.get((String)"3D-OC-Options_IntDens.boolean", (boolean)true)) {
                rt.setValue("IntDen", i, (double)currObj.int_dens);
            }
            if (Prefs.get((String)"3D-OC-Options_mean.boolean", (boolean)true)) {
                rt.setValue("Mean", i, (double)currObj.mean_gray);
            }
            if (Prefs.get((String)"3D-OC-Options_stdDev.boolean", (boolean)true)) {
                rt.setValue("StdDev", i, (double)currObj.SD);
            }
            if (Prefs.get((String)"3D-OC-Options_median.boolean", (boolean)true)) {
                rt.setValue("Median", i, (double)currObj.median);
            }
            if (Prefs.get((String)"3D-OC-Options_min.boolean", (boolean)true)) {
                rt.setValue("Min", i, (double)currObj.min);
            }
            if (Prefs.get((String)"3D-OC-Options_max.boolean", (boolean)true)) {
                rt.setValue("Max", i, (double)currObj.max);
            }
            if (Prefs.get((String)"3D-OC-Options_centroid.boolean", (boolean)true)) {
                tmpArray = currObj.centroid;
                rt.setValue("X", i, (double)tmpArray[0]);
                rt.setValue("Y", i, (double)tmpArray[1]);
                if (this.nbSlices != 1) {
                    rt.setValue("Z", i, (double)tmpArray[2]);
                }
            }
            if (Prefs.get((String)"3D-OC-Options_meanDist2Surf.boolean", (boolean)true)) {
                rt.setValue("Mean dist. to surf. (" + unit + ")", i, (double)currObj.mean_dist2surf);
            }
            if (Prefs.get((String)"3D-OC-Options_SDDist2Surf.boolean", (boolean)true)) {
                rt.setValue("SD dist. to surf. (" + unit + ")", i, (double)currObj.SD_dist2surf);
            }
            if (Prefs.get((String)"3D-OC-Options_medDist2Surf.boolean", (boolean)true)) {
                rt.setValue("Median dist. to surf. (" + unit + ")", i, (double)currObj.median_dist2surf);
            }
            if (Prefs.get((String)"3D-OC-Options_COM.boolean", (boolean)true)) {
                tmpArray = currObj.c_mass;
                rt.setValue("XM", i, (double)tmpArray[0]);
                rt.setValue("YM", i, (double)tmpArray[1]);
                if (this.nbSlices != 1) {
                    rt.setValue("ZM", i, (double)tmpArray[2]);
                }
            }
            if (!Prefs.get((String)"3D-OC-Options_BB.boolean", (boolean)true)) continue;
            int[] tmpArrayInt = currObj.bound_cube_TL;
            rt.setValue("BX", i, (double)tmpArrayInt[0]);
            rt.setValue("BY", i, (double)tmpArrayInt[1]);
            if (this.nbSlices != 1) {
                rt.setValue("BZ", i, (double)tmpArrayInt[2]);
            }
            rt.setValue("B-width", i, (double)currObj.bound_cube_width);
            rt.setValue("B-height", i, (double)currObj.bound_cube_height);
            if (this.nbSlices == 1) continue;
            rt.setValue("B-depth", i, (double)currObj.bound_cube_depth);
        }
        if (newRT) {
            rt.show("Statistics for " + this.title);
        } else {
            rt.show("Results");
        }
    }

    public void showSummary() {
        IJ.log((String)(this.title + ": " + this.nbObj + " objects detected (Size filter set to " + this.minSize + "-" + this.maxSize + " voxels, threshold set to: " + this.thr + ")."));
    }

    public void showSurfPix() {
        int i;
        if (!this.getSurfCoord) {
            this.populateSurfPixCoord();
        }
        String[] header = new String[]{"Object ID", "X", "Y", "Z"};
        ResultsTable rt = new ResultsTable();
        for (i = 0; i < header.length; ++i) {
            rt.setHeading(i, header[i]);
        }
        for (i = 0; i < this.surfCoord.length; ++i) {
            rt.incrementCounter();
            for (int j = 0; j < 4; ++j) {
                rt.setValue(j, i, (double)this.surfCoord[i][j]);
            }
        }
        rt.show("Surface pixel coordinates for " + this.title);
    }

    private int offset(int m, int n, int o) {
        if (m + n * this.width + (o - 1) * this.width * this.height >= this.width * this.height * this.nbSlices) {
            return this.width * this.height * this.nbSlices - 1;
        }
        if (m + n * this.width + (o - 1) * this.width * this.height < 0) {
            return 0;
        }
        return m + n * this.width + (o - 1) * this.width * this.height;
    }

    private int minAntTag(int initialValue, int x, int y, int z) {
        int currPos;
        int min = initialValue;
        for (int neigbY = y - 1; neigbY <= y + 1; ++neigbY) {
            for (int neigbX = x - 1; neigbX <= x + 1; ++neigbX) {
                if (neigbX < 0 || neigbX >= this.width || neigbY < 0 || neigbY >= this.height || z - 1 < 1 || z - 1 > this.nbSlices || this.imgArray[currPos = this.offset(neigbX, neigbY, z - 1)] == 0) continue;
                min = Math.min(min, this.objID[currPos]);
            }
        }
        for (int neigbX = x - 1; neigbX <= x + 1; ++neigbX) {
            if (neigbX < 0 || neigbX >= this.width || y - 1 < 0 || y - 1 >= this.height || z < 1 || z > this.nbSlices || this.imgArray[currPos = this.offset(neigbX, y - 1, z)] == 0) continue;
            min = Math.min(min, this.objID[currPos]);
        }
        if (x - 1 >= 0 && x - 1 < this.width && y >= 0 && y < this.height && z >= 1 && z <= this.nbSlices && this.imgArray[currPos = this.offset(x - 1, y, z)] != 0 && x >= 1 && y >= 0 && z >= 1) {
            min = Math.min(min, this.objID[currPos]);
        }
        return min;
    }

    private void replaceID(int oldVal, int newVal) {
        if (oldVal != newVal) {
            int nbFoundPix = 0;
            for (int i = 0; i < this.objID.length; ++i) {
                if (this.objID[i] == oldVal) {
                    this.objID[i] = newVal;
                    ++nbFoundPix;
                }
                if (nbFoundPix != this.IDcount[oldVal]) continue;
                i = this.objID.length;
            }
            this.IDcount[oldVal] = 0;
            int n = newVal;
            this.IDcount[n] = this.IDcount[n] + nbFoundPix;
        }
    }

    private ImagePlus buildImg(int[] imgArray, int[] cenArray, String title, boolean drawDots, boolean drawNb, boolean whiteNb, int dotSize, int fontSize) {
        int currVal;
        int x;
        int y;
        ImageProcessor ip;
        int z;
        int index = 0;
        int imgDepth = 16;
        float min = imgArray[0];
        float max = imgArray[0];
        for (int i = 0; i < imgArray.length; ++i) {
            int currVal2 = imgArray[i];
            min = Math.min(min, (float)currVal2);
            max = Math.max(max, (float)currVal2);
        }
        if (max < 256.0f) {
            imgDepth = 8;
        }
        ImagePlus img = NewImage.createImage((String)title, (int)this.width, (int)this.height, (int)this.nbSlices, (int)imgDepth, (int)1);
        for (z = 1; z <= this.nbSlices; ++z) {
            IJ.showStatus((String)"Creating the image...");
            img.setSlice(z);
            ip = img.getProcessor();
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    currVal = imgArray[index];
                    if (currVal != 0) {
                        ip.setValue((double)currVal);
                        if (drawDots) {
                            ip.setLineWidth(dotSize);
                            ip.drawDot(x, y);
                        } else {
                            ip.putPixel(x, y, currVal);
                        }
                    }
                    ++index;
                }
            }
        }
        IJ.showStatus((String)"");
        index = 0;
        if (drawNb && cenArray != null) {
            for (z = 1; z <= this.nbSlices; ++z) {
                IJ.showStatus((String)"Numbering objects...");
                img.setSlice(z);
                ip = img.getProcessor();
                ip.setValue(Math.pow(2.0, imgDepth));
                ip.setFont(new Font("Arial", 0, fontSize));
                for (y = 0; y < this.height; ++y) {
                    for (x = 0; x < this.width; ++x) {
                        currVal = cenArray[index];
                        if (currVal != 0) {
                            if (!whiteNb) {
                                ip.setValue((double)currVal);
                            }
                            ip.drawString("" + currVal, x, y);
                        }
                        ++index;
                    }
                }
            }
        }
        IJ.showStatus((String)"");
        img.setCalibration(this.cal);
        img.setDisplayRange((double)min, (double)max);
        return img;
    }
}

