/*
 * Decompiled with CFR 0.152.
 */
package volume;

import ij.IJ;
import ij.ImageStack;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import volume.Kernel;
import volume.Kernel1D;
import volume.Kernel2D;
import volume.Kernel3D;
import volume.Volume;

public class VolumeFloat
extends Volume {
    public float[][][] v;

    public VolumeFloat() {
    }

    public VolumeFloat(int width, int height, int depth, double aspectx, double aspecty, double aspectz) {
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.v = new float[depth][height][width];
        this.setAspects(aspectx, aspecty, aspectz);
    }

    public VolumeFloat(int width, int height, int depth) {
        this(width, height, depth, 1.0, 1.0, 1.0);
    }

    public VolumeFloat(VolumeFloat v1) {
        this(v1.getWidth(), v1.getHeight(), v1.getDepth(), v1.getAspectx(), v1.getAspecty(), v1.getAspectz());
        this.copy(v1.v);
    }

    public VolumeFloat(ImageStack s) {
        this(s.getWidth(), s.getHeight(), s.getSize(), 1.0, 1.0, 1.0);
        this.load(s, 0);
    }

    public VolumeFloat(ImageStack s, double aspectx, double aspecty, double aspectz) {
        this(s, s.getSize(), 0, aspectx, aspecty, aspectz);
        this.load(s, 0);
    }

    public VolumeFloat(ImageStack s, int depth, int n) {
        this(s, depth, n, 1.0, 1.0, 1.0);
    }

    public VolumeFloat(float[][][] fv) {
        this(fv[0][0].length, fv[0].length, fv.length, 1.0, 1.0, 1.0);
        this.copy(fv);
    }

    public VolumeFloat(ImageStack s, int depth, int n, double aspectx, double aspecty, double aspectz) {
        this(s.getWidth(), s.getHeight(), depth, aspectx, aspecty, aspecty);
        this.load(s, n * depth);
    }

    public VolumeFloat(ImageProcessor ip) {
        this(ip.getWidth(), ip.getHeight(), 1);
        if (ip instanceof ColorProcessor) {
            this.loadPixels(this.v[0], (ColorProcessor)ip, this.width, this.height);
        } else if (ip instanceof ByteProcessor) {
            this.loadPixels(this.v[0], (ByteProcessor)ip, this.width, this.height);
        } else if (ip instanceof ShortProcessor) {
            this.loadPixels(this.v[0], (ShortProcessor)ip, this.width, this.height);
        } else if (ip instanceof FloatProcessor) {
            this.loadPixels(this.v[0], (FloatProcessor)ip, this.width, this.height);
        }
    }

    public float[][][] getVolume() {
        return this.v;
    }

    @Override
    public Object get(int x, int y, int z) {
        return new Float(this.v[z][y][x]);
    }

    @Override
    public void set(Object value, int x, int y, int z) {
        this.v[z][y][x] = ((Number)value).floatValue();
    }

    public void convolvet(ImageStack s, int center, Kernel1D kernel) {
        for (int t = -this.depth / 2; t <= this.depth / 2; ++t) {
            int x;
            int y;
            float[][] t1 = new float[this.height][this.width];
            if (kernel instanceof Kernel) {
                for (y = 0; y < this.height; ++y) {
                    for (x = 0; x < this.width; ++x) {
                        this.v[t + this.depth / 2][y][x] = 0.0f;
                    }
                }
                for (int k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                    this.loadSlice(t1, s, center + t + k + 1);
                    for (int y2 = 0; y2 < this.height; ++y2) {
                        for (int x2 = 0; x2 < this.width; ++x2) {
                            float[] fArray = this.v[t + this.depth / 2][y2];
                            int n = x2;
                            fArray[n] = (float)((double)fArray[n] + (double)t1[y2][x2] * kernel.k[k + kernel.halfwidth]);
                        }
                    }
                }
                continue;
            }
            this.loadSlice(t1, s, center + t);
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    this.v[t + this.depth / 2][y][x] = t1[y][x];
                }
            }
        }
    }

    public void load(ImageStack s, int start) {
        for (int t = start; t < Math.min(start + this.depth, this.depth); ++t) {
            float[][] t1 = new float[this.height][this.width];
            this.loadSlice(t1, s, t + 1);
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.v[t - start][y][x] = t1[y][x];
                }
            }
        }
    }

    public void loadInverse(ImageStack s, int center) {
        for (int t = -this.depth / 2; t <= this.depth / 2; ++t) {
            float[][] t1 = new float[this.height][this.width];
            this.loadSlice(t1, s, center + this.depth / 2 - t);
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.v[t + this.depth / 2][y][x] = t1[y][x];
                }
            }
        }
    }

    public void convolvexy(Kernel1D kernel) {
        if (kernel.halfwidth > this.edge) {
            this.edge = kernel.halfwidth;
        }
        for (int t = 0; t < this.depth; ++t) {
            int k;
            int x;
            int y;
            float[][] t1 = new float[this.height][this.width];
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    t1[y][x] = 0.0f;
                    if (!this.valid(x, y)) continue;
                    for (k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                        float[] fArray = t1[y];
                        int n = x;
                        fArray[n] = (float)((double)fArray[n] + (double)this.v[t][y][x + k] * kernel.k[k + kernel.halfwidth]);
                    }
                }
            }
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    this.v[t][y][x] = 0.0f;
                    if (!this.valid(x, y)) continue;
                    for (k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                        float[] fArray = this.v[t][y];
                        int n = x;
                        fArray[n] = (float)((double)fArray[n] + (double)t1[y + k][x] * kernel.k[k + kernel.halfwidth]);
                    }
                }
            }
        }
    }

    public void convolvexy(Kernel2D kernel) {
        if (kernel.halfwidth > this.edge) {
            this.edge = kernel.halfwidth;
        }
        VolumeFloat t = new VolumeFloat(this.v);
        for (int z = 0; z < this.depth; ++z) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.v[z][y][x] = 0.0f;
                    if (!this.valid(x, y)) continue;
                    for (int m = -kernel.halfwidth; m <= kernel.halfwidth; ++m) {
                        for (int l = -kernel.halfwidth; l <= kernel.halfwidth; ++l) {
                            float[] fArray = this.v[z][y];
                            int n = x;
                            fArray[n] = (float)((double)fArray[n] + (double)t.v[z][y + m][x + l] * kernel.k[m + kernel.halfwidth][l + kernel.halfwidth]);
                        }
                    }
                }
            }
        }
    }

    public void convolvexyz(Kernel3D kernel) {
        if (kernel.halfwidth > this.edge) {
            this.edge = kernel.halfwidth;
        }
        VolumeFloat t = new VolumeFloat(this.v);
        for (int z = 0; z < this.depth; ++z) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.v[z][y][x] = 0.0f;
                    if (!this.valid(x, y, z)) continue;
                    for (int n = -kernel.halfwidth; n <= kernel.halfwidth; ++n) {
                        for (int m = -kernel.halfwidth; m <= kernel.halfwidth; ++m) {
                            for (int l = -kernel.halfwidth; l <= kernel.halfwidth; ++l) {
                                float[] fArray = this.v[z][y];
                                int n2 = x;
                                fArray[n2] = (float)((double)fArray[n2] + (double)t.v[z + n][y + m][x + l] * kernel.k[n + kernel.halfwidth][m + kernel.halfwidth][l + kernel.halfwidth]);
                            }
                        }
                    }
                }
            }
        }
    }

    public void convolvexyz(Kernel1D kernel) {
        int k;
        double s;
        int x;
        int y;
        int z;
        if (kernel.halfwidth > this.edge) {
            this.edge = kernel.halfwidth;
        }
        VolumeFloat t1 = new VolumeFloat(this.v);
        for (z = 0; z < this.depth; ++z) {
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    s = 0.0;
                    if (this.valid(x, y, z)) {
                        for (k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                            s += (double)t1.v[z][y][x + k] * kernel.k[k + kernel.halfwidth];
                        }
                    }
                    this.v[z][y][x] = (float)s;
                }
            }
        }
        for (z = 0; z < this.depth; ++z) {
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    s = 0.0;
                    if (this.valid(x, y, z)) {
                        for (k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                            s += (double)this.v[z][y + k][x] * kernel.k[k + kernel.halfwidth];
                        }
                    }
                    t1.v[z][y][x] = (float)s;
                }
            }
        }
        for (z = 0; z < this.depth; ++z) {
            for (y = 0; y < this.height; ++y) {
                for (x = 0; x < this.width; ++x) {
                    s = 0.0;
                    if (this.valid(x, y, z)) {
                        for (k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                            s += (double)t1.v[z + k][y][x] * kernel.k[k + kernel.halfwidth];
                        }
                    }
                    this.v[z][y][x] = (float)s;
                }
            }
        }
    }

    public void convolvex(VolumeFloat v1, Kernel1D kernel) {
        if (this.width < v1.getWidth() || this.height < v1.getHeight() || this.depth > v1.getDepth()) {
            IJ.error((String)"convolve: destination volume wrong size.");
        }
        int depthoffset = 0;
        if (this.depth < v1.getDepth()) {
            depthoffset = (v1.getDepth() - this.depth) / 2;
        }
        if (v1.edge > this.edge) {
            this.edge = v1.edge;
        }
        if (kernel.halfwidth > this.edge) {
            this.edge = kernel.halfwidth;
        }
        for (int z = 0; z < this.depth; ++z) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.v[z][y][x] = 0.0f;
                    if (!this.valid(x, y)) continue;
                    for (int k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                        float[] fArray = this.v[z][y];
                        int n = x;
                        fArray[n] = (float)((double)fArray[n] + (double)v1.v[z + depthoffset][y][x + k] * kernel.k[k + kernel.halfwidth]);
                    }
                }
            }
        }
    }

    public void convolvey(VolumeFloat v1, Kernel1D kernel) {
        if (this.width < v1.getWidth() || this.height < v1.getHeight() || this.depth > v1.getDepth()) {
            IJ.error((String)"convolve: destination volume wrong size.");
        }
        int depthoffset = 0;
        if (this.depth < v1.getDepth()) {
            depthoffset = (v1.getDepth() - this.depth) / 2;
        }
        if (v1.edge > this.edge) {
            this.edge = v1.edge;
        }
        if (kernel.halfwidth > this.edge) {
            this.edge = kernel.halfwidth;
        }
        for (int t = 0; t < this.depth; ++t) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.v[t][y][x] = 0.0f;
                    if (!this.valid(x, y)) continue;
                    for (int k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                        float[] fArray = this.v[t][y];
                        int n = x;
                        fArray[n] = (float)((double)fArray[n] + (double)v1.v[t + depthoffset][y + k][x] * kernel.k[k + kernel.halfwidth]);
                    }
                }
            }
        }
    }

    public void convolvex(VolumeFloat v1, Kernel2D kernel) {
        int depthoffset = this.InitParams(v1, kernel);
        if (depthoffset < 0) {
            return;
        }
        for (int t = 0; t < this.depth; ++t) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.v[t][y][x] = 0.0f;
                    if (!this.valid(x, y)) continue;
                    for (int l = -kernel.halfwidth; l <= kernel.halfwidth; ++l) {
                        for (int k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                            float[] fArray = this.v[t][y];
                            int n = x;
                            fArray[n] = (float)((double)fArray[n] + (double)v1.v[t + depthoffset][y + l][x + k] * kernel.k[l + kernel.halfwidth][k + kernel.halfwidth]);
                        }
                    }
                }
            }
        }
    }

    public void convolvey(VolumeFloat v1, Kernel2D kernel) {
        int depthoffset = this.InitParams(v1, kernel);
        if (depthoffset < 0) {
            return;
        }
        for (int t = 0; t < this.depth; ++t) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.v[t][y][x] = 0.0f;
                    if (!this.valid(x, y)) continue;
                    for (int l = -kernel.halfwidth; l <= kernel.halfwidth; ++l) {
                        for (int k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                            float[] fArray = this.v[t][y];
                            int n = x;
                            fArray[n] = (float)((double)fArray[n] + (double)v1.v[t + depthoffset][y + l][x + k] * kernel.k[k + kernel.halfwidth][l + kernel.halfwidth]);
                        }
                    }
                }
            }
        }
    }

    public void convolvez(VolumeFloat v1, Kernel1D kernel) {
        if (this.width < v1.getWidth() || this.height < v1.getHeight() || this.depth > v1.getDepth()) {
            IJ.error((String)"convolve: destination volume wrong size.");
        }
        if (v1.getDepth() < kernel.halfwidth * 2) {
            IJ.error((String)"volume depth doesn't fit kernel");
        }
        if (v1.edge > this.edge) {
            this.edge = v1.edge;
        }
        int x = 0;
        int y = 0;
        int z = 0;
        try {
            for (z = -this.depth / 2; z < (this.depth + 1) / 2; ++z) {
                for (y = 0; y < this.height; ++y) {
                    for (x = 0; x < this.width; ++x) {
                        this.v[z + this.depth / 2][y][x] = 0.0f;
                        if (z < -v1.getDepth() / 2 + kernel.halfwidth || z >= (v1.getDepth() + 1) / 2 - kernel.halfwidth) continue;
                        for (int k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                            float[] fArray = this.v[z + this.depth / 2][y];
                            int n = x;
                            fArray[n] = (float)((double)fArray[n] + (double)v1.v[z + v1.getDepth() / 2 + k][y][x] * kernel.k[k + kernel.halfwidth]);
                        }
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            IJ.log((String)("array " + e + " x,y,z " + x + "," + y + "," + z + "( k " + kernel.halfwidth + ": " + this.width + "x" + this.height + "x" + this.depth + "?= " + v1.getDepth() + "x" + v1.getHeight() + "x" + v1.getDepth()));
        }
    }

    public void convolvez(VolumeFloat v1) {
        if (this.width < v1.getWidth() || this.height < v1.getHeight() || this.depth > v1.getDepth()) {
            IJ.error((String)"convolvez: destination volume wrong size.");
        }
        if (v1.getDepth() < 2) {
            IJ.error((String)"convolvez: volume depth doesn't fit kernel");
        }
        if (v1.edge > this.edge) {
            this.edge = v1.edge;
        }
        IJ.log((String)("z: " + -this.depth / 2 + "index " + (-this.depth / 2 + this.depth / 2)));
        for (int z = -this.depth / 2; z < (this.depth + 1) / 2; ++z) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int index = z + this.depth / 2;
                    this.v[index][y][x] = v1.v[index + 1][y][x] - v1.v[index][y][x];
                }
            }
        }
    }

    public void convolvez(VolumeFloat v1, Kernel2D kernel) {
        int depthoffset = this.InitParams(v1, kernel);
        if (depthoffset < 0) {
            return;
        }
        for (int z = 0; z < this.depth; ++z) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.v[z][y][x] = 0.0f;
                    if (!this.valid(x, y)) continue;
                    for (int l = -kernel.halfwidth; l <= kernel.halfwidth; ++l) {
                        for (int k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                            float[] fArray = this.v[z][y];
                            int n = x;
                            fArray[n] = (float)((double)fArray[n] + (double)v1.v[z + depthoffset + l][y + k][x] * kernel.k[k + kernel.halfwidth][l + kernel.halfwidth]);
                        }
                    }
                }
            }
        }
    }

    public void convolvex(VolumeFloat v1, Kernel3D kernel) {
        int depthoffset = this.InitParams(v1, kernel);
        if (depthoffset < 0) {
            return;
        }
        for (int t = 0; t < this.depth; ++t) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.v[t][y][x] = 0.0f;
                    if (!this.valid(x, y)) continue;
                    for (int m = -kernel.halfwidth; m <= kernel.halfwidth; ++m) {
                        for (int l = -kernel.halfwidth; l <= kernel.halfwidth; ++l) {
                            for (int k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                                float[] fArray = this.v[t][y];
                                int n = x;
                                fArray[n] = (float)((double)fArray[n] + (double)v1.v[t + depthoffset + m][y + l][x + k] * kernel.k[m + kernel.halfwidth][l + kernel.halfwidth][k + kernel.halfwidth]);
                            }
                        }
                    }
                }
            }
        }
    }

    public void convolvey(VolumeFloat v1, Kernel3D kernel) {
        int depthoffset = this.InitParams(v1, kernel);
        if (depthoffset < 0) {
            return;
        }
        for (int t = 0; t < this.depth; ++t) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.v[t][y][x] = 0.0f;
                    if (!this.valid(x, y)) continue;
                    for (int m = -kernel.halfwidth; m <= kernel.halfwidth; ++m) {
                        for (int l = -kernel.halfwidth; l <= kernel.halfwidth; ++l) {
                            for (int k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                                float[] fArray = this.v[t][y];
                                int n = x;
                                fArray[n] = (float)((double)fArray[n] + (double)v1.v[t + depthoffset + m][y + l][x + k] * kernel.k[m + kernel.halfwidth][k + kernel.halfwidth][l + kernel.halfwidth]);
                            }
                        }
                    }
                }
            }
        }
    }

    public void convolvez(VolumeFloat v1, Kernel3D kernel) {
        int depthoffset = this.InitParams(v1, kernel);
        if (depthoffset < 0) {
            return;
        }
        for (int t = 0; t < this.depth; ++t) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.v[t][y][x] = 0.0f;
                    if (!this.valid(x, y)) continue;
                    for (int m = -kernel.halfwidth; m <= kernel.halfwidth; ++m) {
                        for (int l = -kernel.halfwidth; l <= kernel.halfwidth; ++l) {
                            for (int k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                                float[] fArray = this.v[t][y];
                                int n = x;
                                fArray[n] = (float)((double)fArray[n] + (double)v1.v[t + depthoffset + m][y + l][x + k] * kernel.k[k + kernel.halfwidth][l + kernel.halfwidth][m + kernel.halfwidth]);
                            }
                        }
                    }
                }
            }
        }
    }

    private void copy(float[][][] fv) {
        for (int t = 0; t < this.depth; ++t) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.v[t][y][x] = fv[t][y][x];
                }
            }
        }
    }

    public void copy(VolumeFloat v1) {
        this.copy(v1.v);
    }

    public void add(VolumeFloat v1) {
        for (int t = 0; t < this.depth; ++t) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.v[t][y][x] = this.v[t][y][x] + v1.v[t][y][x];
                }
            }
        }
    }

    public void sub(VolumeFloat v1) {
        for (int t = 0; t < this.depth; ++t) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    float[] fArray = this.v[t][y];
                    int n = x;
                    fArray[n] = fArray[n] - v1.v[t][y][x];
                }
            }
        }
    }

    public void mul(double constant) {
        for (int t = 0; t < this.depth; ++t) {
            for (int y = 0; y < this.height; ++y) {
                int x = 0;
                while (x < this.width) {
                    float[] fArray = this.v[t][y];
                    int n = x++;
                    fArray[n] = (float)((double)fArray[n] * constant);
                }
            }
        }
    }

    public void mul(VolumeFloat a, VolumeFloat b) {
        if (this.width != a.getWidth() || this.height != a.getHeight() || this.depth != a.getDepth() || this.width != b.getWidth() || this.height != b.getHeight() || this.depth != b.getDepth()) {
            IJ.error((String)"mul undefined.");
        }
        for (int t = 0; t < this.depth; ++t) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.v[t][y][x] = (float)((double)a.v[t][y][x] * (double)b.v[t][y][x]);
                }
            }
        }
    }

    public void mul(VolumeFloat a) {
        if (this.width != a.getWidth() || this.height != a.getHeight() || this.depth != a.getDepth()) {
            IJ.error((String)"mul undefined.");
        }
        for (int z = 0; z < this.depth; ++z) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.v[z][y][x] = (float)((double)this.v[z][y][x] * (double)a.v[z][y][x]);
                }
            }
        }
    }

    public void sqrt() {
        for (int t = 0; t < this.depth; ++t) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    this.v[t][y][x] = (float)Math.sqrt(this.v[t][y][x]);
                }
            }
        }
    }

    private int InitParams(VolumeFloat v1, Kernel kernel) {
        if (this.width < v1.getWidth() || this.height < v1.getHeight() || this.depth > v1.getDepth()) {
            IJ.error((String)"volume: convolution volume wrong size.");
            return -1;
        }
        int depthoffset = 0;
        if (this.depth < v1.getDepth()) {
            depthoffset = (v1.getDepth() - this.depth) / 2;
        }
        if (v1.edge > this.edge) {
            this.edge = v1.edge;
        }
        if (kernel.halfwidth > this.edge) {
            this.edge = kernel.halfwidth;
        }
        return depthoffset;
    }

    public float dx(int x, int y, int z, Kernel1D kernel) {
        float d = 0.0f;
        if (this.edge < kernel.halfwidth) {
            this.edge = kernel.halfwidth;
        }
        if (this.valid(x, y, z)) {
            for (int k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                d = (float)((double)d + (double)this.v[z][y][x + k] * kernel.k[k + kernel.halfwidth]);
            }
        }
        return d;
    }

    public float dy(int x, int y, int z, Kernel1D kernel) {
        float d = 0.0f;
        if (this.edge < kernel.halfwidth) {
            this.edge = kernel.halfwidth;
        }
        for (int k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
            if (!this.valid(x, y, z)) continue;
            d = (float)((double)d + (double)this.v[z][y + k][x] * kernel.k[k + kernel.halfwidth]);
        }
        return d;
    }

    public float dz(int x, int y, int z, Kernel1D kernel) {
        float d = 0.0f;
        if (this.edge < kernel.halfwidth) {
            this.edge = kernel.halfwidth;
        }
        for (int k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
            if (!this.valid(x, y, z)) continue;
            d = (float)((double)d + (double)this.v[z + k][y][x] * kernel.k[k + kernel.halfwidth]);
        }
        return d;
    }

    public float ux(int j, int i, Kernel2D kernel) {
        float d = 0.0f;
        for (int l = -kernel.halfwidth; l <= kernel.halfwidth; ++l) {
            for (int k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                if (!this.valid(i, j, kernel.halfwidth)) continue;
                d = (float)((double)d + (double)this.v[this.depth / 2][j + l][i + k] * kernel.k[l + kernel.halfwidth][k + kernel.halfwidth]);
            }
        }
        return d;
    }

    public float uy(int j, int i, Kernel2D kernel) {
        float d = 0.0f;
        for (int l = -kernel.halfwidth; l <= kernel.halfwidth; ++l) {
            for (int k = -kernel.halfwidth; k <= kernel.halfwidth; ++k) {
                if (!this.valid(i, j, kernel.halfwidth)) continue;
                d = (float)((double)d + (double)this.v[this.depth / 2][j + l][i + k] * kernel.k[k + kernel.halfwidth][l + kernel.halfwidth]);
            }
        }
        return d;
    }

    public float[] map() {
        float[] pixels = new float[25 * this.width * this.height];
        for (int z = 0; z < 25 && z < this.depth; ++z) {
            int col = z % 5;
            int row = z / 5;
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    int i = col * this.width + row * this.width * this.height * 5 + x + y * 5 * this.width;
                    double value = this.v[z][y][x];
                    pixels[i++] = (float)value;
                }
            }
        }
        return pixels;
    }

    private void loadSlice(float[][] i, ImageStack s, int io) {
        if (io < 1 || io > s.getSize()) {
            IJ.error((String)("loadSlice: slice index out of bounds (" + io + "><1-" + s.getSize() + ")"));
            return;
        }
        ImageProcessor ip = s.getProcessor(io);
        if (ip instanceof ColorProcessor) {
            this.loadPixels(i, (ColorProcessor)ip, s.getWidth(), s.getHeight());
        } else if (ip instanceof ByteProcessor) {
            this.loadPixels(i, (ByteProcessor)ip, s.getWidth(), s.getHeight());
        } else if (ip instanceof ShortProcessor) {
            this.loadPixels(i, (ShortProcessor)ip, s.getWidth(), s.getHeight());
        } else if (ip instanceof FloatProcessor) {
            this.loadPixels(i, (FloatProcessor)ip, s.getWidth(), s.getHeight());
        }
    }

    private void loadPixels(float[][] i, ColorProcessor cp, int width, int height) {
        int[] ii = (int[])cp.getPixels();
        for (int y = 0; y < height; ++y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                int c = ii[offset + x];
                int r = (c & 0xFF0000) >> 16;
                int g = (c & 0xFF00) >> 8;
                int b = c & 0xFF;
                i[y][x] = (float)((double)r * 0.3 + (double)g * 0.59 + (double)b * 0.11);
            }
        }
    }

    private void loadPixels(float[][] i, ByteProcessor bp, int width, int height) {
        byte[] b = (byte[])bp.getPixels();
        for (int y = 0; y < height; ++y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                i[y][x] = b[offset + x] & 0xFF;
            }
        }
    }

    private void loadPixels(float[][] i, ShortProcessor sp, int width, int height) {
        short[] u = (short[])sp.getPixels();
        for (int y = 0; y < height; ++y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                i[y][x] = u[offset + x];
            }
        }
    }

    private void loadPixels(float[][] i, FloatProcessor fp, int width, int height) {
        float[] f = (float[])fp.getPixels();
        for (int y = 0; y < height; ++y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                i[y][x] = f[offset + x];
            }
        }
    }

    public void intoStack(ImageStack is) {
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        for (int z = 0; z < this.depth; ++z) {
            for (int y = 0; y < this.height; ++y) {
                for (int x = 0; x < this.width; ++x) {
                    if (min > this.v[z][y][x]) {
                        min = this.v[z][y][x];
                    }
                    if (!(max < this.v[z][y][x])) continue;
                    max = this.v[z][y][x];
                }
            }
        }
        float scale = 1.0f / (max - min);
        Object[] stack = is.getImageArray();
        for (int z = 0; z < this.depth; ++z) {
            int x;
            int offset;
            int y;
            if (stack[0] instanceof byte[]) {
                byte[] b = (byte[])is.getPixels(z + 1);
                for (y = 0; y < this.height; ++y) {
                    offset = y * this.width;
                    for (x = 0; x < this.width; ++x) {
                        b[offset + x] = (byte)((this.v[z][y][x] - min) * scale * 255.0f);
                    }
                }
                continue;
            }
            if (stack[0] instanceof short[]) {
                short[] u = (short[])is.getPixels(z + 1);
                for (y = 0; y < this.height; ++y) {
                    offset = y * this.width;
                    for (x = 0; x < this.width; ++x) {
                        u[offset + x] = (short)((this.v[z][y][x] - min) * scale * 32767.0f);
                    }
                }
                continue;
            }
            if (stack[0] instanceof float[]) {
                float[] f = (float[])is.getPixels(z + 1);
                for (y = 0; y < this.height; ++y) {
                    offset = y * this.width;
                    for (x = 0; x < this.width; ++x) {
                        f[offset + x] = this.v[z][y][x];
                    }
                }
                continue;
            }
            if (!(stack[0] instanceof int[])) continue;
            int[] ii = (int[])is.getPixels(z + 1);
            for (y = 0; y < this.height; ++y) {
                offset = y * this.width;
                for (x = 0; x < this.width; ++x) {
                    int b = (int)((this.v[z][y][x] - min) * scale * 255.0f);
                    ii[offset + x] = b << 16 | b << 8 | b;
                }
            }
        }
    }

    public ImageStack getImageStack() {
        ImageStack is = new ImageStack(this.width, this.height);
        for (int z = 0; z < this.depth; ++z) {
            FloatProcessor fp = new FloatProcessor(this.width, this.height);
            float[] im = (float[])fp.getPixels();
            for (int y = 0; y < this.height; ++y) {
                int offset = y * this.width;
                for (int x = 0; x < this.width; ++x) {
                    im[offset + x] = this.v[z][y][x];
                }
            }
            is.addSlice("slice" + z, (ImageProcessor)fp);
        }
        return is;
    }
}

