/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function.aggregator;

import java.math.BigDecimal;
import org.ojalgo.ProgrammingError;
import org.ojalgo.constant.BigMath;
import org.ojalgo.function.BigFunction;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.scalar.BigScalar;
import org.ojalgo.scalar.Scalar;

public final class BigAggregator
extends AggregatorSet<BigDecimal> {
    public static final ThreadLocal<AggregatorFunction<BigDecimal>> AVERAGE = new ThreadLocal<AggregatorFunction<BigDecimal>>(){

        @Override
        protected AggregatorFunction<BigDecimal> initialValue() {
            return new BigAggregatorFunction(){
                private int myCount = 0;
                private BigDecimal myNumber = BigMath.ZERO;

                @Override
                public BigDecimal get() {
                    return BigFunction.DIVIDE.invoke(this.myNumber, BigDecimal.valueOf(this.myCount));
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(BigDecimal anArg) {
                    ++this.myCount;
                    this.myNumber = BigFunction.ADD.invoke(this.myNumber, anArg);
                }

                @Override
                public boolean isMergeable() {
                    return false;
                }

                @Override
                public void merge(BigDecimal result) {
                    ProgrammingError.throwForIllegalInvocation();
                }

                @Override
                public BigDecimal merge(BigDecimal result1, BigDecimal result2) {
                    ProgrammingError.throwForIllegalInvocation();
                    return null;
                }

                @Override
                public AggregatorFunction<BigDecimal> reset() {
                    this.myCount = 0;
                    this.myNumber = BigMath.ZERO;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<BigDecimal>> CARDINALITY = new ThreadLocal<AggregatorFunction<BigDecimal>>(){

        @Override
        protected AggregatorFunction<BigDecimal> initialValue() {
            return new BigAggregatorFunction(){
                private int myCount = 0;

                @Override
                public BigDecimal get() {
                    return new BigDecimal(this.myCount);
                }

                @Override
                public int intValue() {
                    return this.myCount;
                }

                @Override
                public void invoke(BigDecimal anArg) {
                    if (anArg.signum() != 0) {
                        ++this.myCount;
                    }
                }

                @Override
                public void merge(BigDecimal result) {
                    this.myCount += result.intValue();
                }

                @Override
                public BigDecimal merge(BigDecimal result1, BigDecimal result2) {
                    return BigFunction.ADD.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<BigDecimal> reset() {
                    this.myCount = 0;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<BigDecimal>> LARGEST = new ThreadLocal<AggregatorFunction<BigDecimal>>(){

        @Override
        protected AggregatorFunction<BigDecimal> initialValue() {
            return new BigAggregatorFunction(){
                private BigDecimal myNumber = BigMath.ZERO;

                @Override
                public BigDecimal get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(BigDecimal anArg) {
                    this.myNumber = BigFunction.MAX.invoke(this.myNumber, BigFunction.ABS.invoke(anArg));
                }

                @Override
                public void merge(BigDecimal result) {
                    this.invoke(result);
                }

                @Override
                public BigDecimal merge(BigDecimal result1, BigDecimal result2) {
                    return result1.max(result2);
                }

                @Override
                public AggregatorFunction<BigDecimal> reset() {
                    this.myNumber = BigMath.ZERO;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<BigDecimal>> MAX = new ThreadLocal<AggregatorFunction<BigDecimal>>(){

        @Override
        protected AggregatorFunction<BigDecimal> initialValue() {
            return new BigAggregatorFunction(){
                private BigDecimal myNumber = BigMath.ZERO;

                @Override
                public BigDecimal get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(BigDecimal anArg) {
                    this.myNumber = BigFunction.MAX.invoke(this.myNumber, anArg);
                }

                @Override
                public void merge(BigDecimal result) {
                    this.invoke(result);
                }

                @Override
                public BigDecimal merge(BigDecimal result1, BigDecimal result2) {
                    return result1.max(result2);
                }

                @Override
                public AggregatorFunction<BigDecimal> reset() {
                    this.myNumber = BigMath.ZERO;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<BigDecimal>> MIN = new ThreadLocal<AggregatorFunction<BigDecimal>>(){

        @Override
        protected AggregatorFunction<BigDecimal> initialValue() {
            return new BigAggregatorFunction(){
                private BigDecimal myNumber = BigMath.VERY_POSITIVE;

                @Override
                public BigDecimal get() {
                    if (this.myNumber.compareTo(BigMath.VERY_POSITIVE) == 0) {
                        return BigMath.ZERO;
                    }
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(BigDecimal anArg) {
                    this.myNumber = BigFunction.MIN.invoke(this.myNumber, anArg);
                }

                @Override
                public void merge(BigDecimal result) {
                    this.invoke(result);
                }

                @Override
                public BigDecimal merge(BigDecimal result1, BigDecimal result2) {
                    return BigFunction.MIN.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<BigDecimal> reset() {
                    this.myNumber = BigMath.VERY_POSITIVE;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<BigDecimal>> NORM1 = new ThreadLocal<AggregatorFunction<BigDecimal>>(){

        @Override
        protected AggregatorFunction<BigDecimal> initialValue() {
            return new BigAggregatorFunction(){
                private BigDecimal myNumber = BigMath.ZERO;

                @Override
                public BigDecimal get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(BigDecimal anArg) {
                    this.myNumber = BigFunction.ADD.invoke(this.myNumber, anArg.abs());
                }

                @Override
                public void merge(BigDecimal result) {
                    this.invoke(result);
                }

                @Override
                public BigDecimal merge(BigDecimal result1, BigDecimal result2) {
                    return BigFunction.ADD.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<BigDecimal> reset() {
                    this.myNumber = BigMath.ZERO;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<BigDecimal>> NORM2 = new ThreadLocal<AggregatorFunction<BigDecimal>>(){

        @Override
        protected AggregatorFunction<BigDecimal> initialValue() {
            return new BigAggregatorFunction(){
                private BigDecimal myNumber = BigMath.ZERO;

                @Override
                public BigDecimal get() {
                    return BigFunction.SQRT.invoke(this.myNumber);
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(BigDecimal anArg) {
                    this.myNumber = BigFunction.ADD.invoke(this.myNumber, BigFunction.MULTIPLY.invoke(anArg, anArg));
                }

                @Override
                public void merge(BigDecimal result) {
                    this.invoke(result);
                }

                @Override
                public BigDecimal merge(BigDecimal result1, BigDecimal result2) {
                    return BigFunction.HYPOT.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<BigDecimal> reset() {
                    this.myNumber = BigMath.ZERO;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<BigDecimal>> PRODUCT = new ThreadLocal<AggregatorFunction<BigDecimal>>(){

        @Override
        protected AggregatorFunction<BigDecimal> initialValue() {
            return new BigAggregatorFunction(){
                private BigDecimal myNumber = BigMath.ONE;

                @Override
                public BigDecimal get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(BigDecimal anArg) {
                    this.myNumber = BigFunction.MULTIPLY.invoke(this.myNumber, anArg);
                }

                @Override
                public void merge(BigDecimal result) {
                    this.invoke(result);
                }

                @Override
                public BigDecimal merge(BigDecimal result1, BigDecimal result2) {
                    return BigFunction.MULTIPLY.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<BigDecimal> reset() {
                    this.myNumber = BigMath.ONE;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<BigDecimal>> PRODUCT2 = new ThreadLocal<AggregatorFunction<BigDecimal>>(){

        @Override
        protected AggregatorFunction<BigDecimal> initialValue() {
            return new BigAggregatorFunction(){
                private BigDecimal myNumber = BigMath.ONE;

                @Override
                public BigDecimal get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(BigDecimal anArg) {
                    this.myNumber = BigFunction.MULTIPLY.invoke(this.myNumber, BigFunction.MULTIPLY.invoke(anArg, anArg));
                }

                @Override
                public void merge(BigDecimal result) {
                    this.myNumber = BigFunction.MULTIPLY.invoke(this.myNumber, result);
                }

                @Override
                public BigDecimal merge(BigDecimal result1, BigDecimal result2) {
                    return BigFunction.MULTIPLY.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<BigDecimal> reset() {
                    this.myNumber = BigMath.ONE;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<BigDecimal>> SMALLEST = new ThreadLocal<AggregatorFunction<BigDecimal>>(){

        @Override
        protected AggregatorFunction<BigDecimal> initialValue() {
            return new BigAggregatorFunction(){
                private BigDecimal myNumber = BigMath.VERY_POSITIVE;

                @Override
                public BigDecimal get() {
                    if (this.myNumber.compareTo(BigMath.VERY_POSITIVE) == 0) {
                        return BigMath.ZERO;
                    }
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(BigDecimal anArg) {
                    if (anArg.signum() != 0) {
                        this.myNumber = BigFunction.MIN.invoke(this.myNumber, BigFunction.ABS.invoke(anArg));
                    }
                }

                @Override
                public void merge(BigDecimal result) {
                    this.invoke(result);
                }

                @Override
                public BigDecimal merge(BigDecimal result1, BigDecimal result2) {
                    return BigFunction.MIN.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<BigDecimal> reset() {
                    this.myNumber = BigMath.VERY_POSITIVE;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<BigDecimal>> SUM = new ThreadLocal<AggregatorFunction<BigDecimal>>(){

        @Override
        protected AggregatorFunction<BigDecimal> initialValue() {
            return new BigAggregatorFunction(){
                private BigDecimal myNumber = BigMath.ZERO;

                @Override
                public BigDecimal get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(BigDecimal anArg) {
                    this.myNumber = BigFunction.ADD.invoke(this.myNumber, anArg);
                }

                @Override
                public void merge(BigDecimal result) {
                    this.invoke(result);
                }

                @Override
                public BigDecimal merge(BigDecimal result1, BigDecimal result2) {
                    return BigFunction.ADD.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<BigDecimal> reset() {
                    this.myNumber = BigMath.ZERO;
                    return this;
                }
            };
        }
    };
    public static final ThreadLocal<AggregatorFunction<BigDecimal>> SUM2 = new ThreadLocal<AggregatorFunction<BigDecimal>>(){

        @Override
        protected AggregatorFunction<BigDecimal> initialValue() {
            return new BigAggregatorFunction(){
                private BigDecimal myNumber = BigMath.ZERO;

                @Override
                public BigDecimal get() {
                    return this.myNumber;
                }

                @Override
                public int intValue() {
                    return this.get().intValue();
                }

                @Override
                public void invoke(BigDecimal anArg) {
                    this.myNumber = BigFunction.ADD.invoke(this.myNumber, BigFunction.MULTIPLY.invoke(anArg, anArg));
                }

                @Override
                public void merge(BigDecimal result) {
                    this.myNumber = BigFunction.ADD.invoke(this.myNumber, result);
                }

                @Override
                public BigDecimal merge(BigDecimal result1, BigDecimal result2) {
                    return BigFunction.ADD.invoke(result1, result2);
                }

                @Override
                public AggregatorFunction<BigDecimal> reset() {
                    this.myNumber = BigMath.ZERO;
                    return this;
                }
            };
        }
    };
    private static final BigAggregator SET = new BigAggregator();

    public static BigAggregator getSet() {
        return SET;
    }

    private BigAggregator() {
    }

    @Override
    public AggregatorFunction<BigDecimal> average() {
        return AVERAGE.get().reset();
    }

    @Override
    public AggregatorFunction<BigDecimal> cardinality() {
        return CARDINALITY.get().reset();
    }

    @Override
    public AggregatorFunction<BigDecimal> largest() {
        return LARGEST.get().reset();
    }

    @Override
    public AggregatorFunction<BigDecimal> maximum() {
        return MAX.get().reset();
    }

    @Override
    public AggregatorFunction<BigDecimal> minimum() {
        return MIN.get().reset();
    }

    @Override
    public AggregatorFunction<BigDecimal> norm1() {
        return NORM1.get().reset();
    }

    @Override
    public AggregatorFunction<BigDecimal> norm2() {
        return NORM2.get().reset();
    }

    @Override
    public AggregatorFunction<BigDecimal> product() {
        return PRODUCT.get().reset();
    }

    @Override
    public AggregatorFunction<BigDecimal> product2() {
        return PRODUCT2.get().reset();
    }

    @Override
    public AggregatorFunction<BigDecimal> smallest() {
        return SMALLEST.get().reset();
    }

    @Override
    public AggregatorFunction<BigDecimal> sum() {
        return SUM.get().reset();
    }

    @Override
    public AggregatorFunction<BigDecimal> sum2() {
        return SUM2.get().reset();
    }

    static abstract class BigAggregatorFunction
    implements AggregatorFunction<BigDecimal> {
        BigAggregatorFunction() {
        }

        @Override
        public final double doubleValue() {
            return ((BigDecimal)this.get()).doubleValue();
        }

        @Override
        public final void invoke(double anArg) {
            this.invoke(new BigDecimal(anArg));
        }

        @Override
        public final Scalar<BigDecimal> toScalar() {
            return BigScalar.of((BigDecimal)this.get());
        }
    }
}

