/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.machine;

import org.ojalgo.machine.MemoryEstimator;

public enum JavaType {
    BYTE(Byte.TYPE, 8, 1L),
    SHORT(Short.TYPE, 16, 2L),
    INT(Integer.TYPE, 32, 4L),
    LONG(Long.TYPE, 64, 8L),
    FLOAT(Float.TYPE, 32, 4L),
    DOUBLE(Double.TYPE, 64, 8L),
    BOOLEAN(Boolean.TYPE, 1, 1L),
    CHAR(Character.TYPE, 16, 2L),
    REFERENCE(Object.class, 64, 4L);

    private final int myInformationBits;
    private final long myMemoryBytes;
    private final Class<?> myJavaClass;

    public static final JavaType match(Class<?> aClass) {
        for (JavaType tmpType : JavaType.values()) {
            if (!tmpType.getJavaClass().isAssignableFrom(aClass)) continue;
            return tmpType;
        }
        return null;
    }

    private JavaType(Class<?> aClass, int informationBits, long memoryBytes) {
        this.myJavaClass = aClass;
        this.myInformationBits = informationBits;
        this.myMemoryBytes = memoryBytes;
    }

    public final long estimateSizeOfWrapperClass() {
        return MemoryEstimator.makeForClassExtendingObject().add(this).estimate();
    }

    public final long memory() {
        return this.myMemoryBytes;
    }

    final int getInformationBits() {
        return this.myInformationBits;
    }

    Class<?> getJavaClass() {
        return this.myJavaClass;
    }
}

