/*
 * Decompiled with CFR 0.152.
 */
package view5d;

import view5d.AnElement;

public class ByteElement
extends AnElement {
    public byte[] myData;
    int SizeXY;

    ByteElement(int SX, int SY, int SZ) {
        super(SX, SY, SZ, 256.0);
        this.myData = new byte[this.Sizes[0] * this.Sizes[1] * this.Sizes[2]];
        this.SizeXY = this.Sizes[0] * this.Sizes[1];
        this.DataType = ByteType;
    }

    @Override
    void Clear() {
        for (int i = 0; i < this.Sizes[0] * this.Sizes[1] * this.Sizes[2]; ++i) {
            this.myData[i] = 0;
        }
    }

    @Override
    void DeleteData() {
        this.myData = null;
    }

    @Override
    int GetStdByteNum() {
        return 1;
    }

    @Override
    void SetValueAt(int x, int y, int z, double val) {
        if (val < 0.0) {
            val = 0.0;
        }
        if (val > 255.0) {
            val = 255.0;
        }
        this.myData[x + this.Sizes[0] * y + this.SizeXY * z] = (byte)val;
    }

    @Override
    int GetIntValueAt(int x, int y, int z) {
        int val = this.myData[x + this.Sizes[0] * y + this.SizeXY * z] & 0xFF;
        return (int)(((double)val - this.shift) * this.scaleI);
    }

    @Override
    int GetByteValueAt(int x, int y, int z) {
        int val = this.myData[x + this.Sizes[0] * y + this.SizeXY * z] & 0xFF;
        return (int)(((double)val - this.shift) * this.scaleB);
    }

    @Override
    double GetRawValueAt(int x, int y, int z) {
        double val = this.myData[x + this.Sizes[0] * y + this.SizeXY * z] & 0xFF;
        return val;
    }

    @Override
    double GetValueAt(int x, int y, int z) {
        int val = this.myData[x + this.Sizes[0] * y + this.SizeXY * z] & 0xFF;
        return (double)val * this.ScaleV + this.OffsetV;
    }

    @Override
    void ConvertSliceFromSimilar(int myslice, int bufslice, Object Ibuffer, int mstep, int moff) {
        byte[] mbuffer = (byte[])Ibuffer;
        for (int i = 0; i < this.SizeXY; i += mstep) {
            this.myData[i + this.Sizes[0] * this.Sizes[1] * myslice] = mbuffer[bufslice * this.SizeXY + i + moff];
        }
    }

    @Override
    void ConvertSliceFromByte(int myslice, int bufslice, byte[] Ibuffer, int mstep, int moff) {
        for (int i = 0; i < this.SizeXY; i += mstep) {
            this.myData[i + this.Sizes[0] * this.Sizes[1] * myslice] = Ibuffer[bufslice * this.SizeXY + i + moff];
        }
    }

    @Override
    void ConvertSliceFromRGB(int myslice, int bufslice, int[] Ibuffer, int mstep, int moff, int suboff) {
        int bitshift = suboff * 8;
        for (int i = 0; i < this.SizeXY; i += mstep) {
            this.myData[i + this.Sizes[0] * this.Sizes[1] * myslice] = (byte)(Ibuffer[bufslice * this.SizeXY + i + moff] >> bitshift & 0xFF);
        }
    }

    @Override
    void CopySliceToSimilar(int myslice, Object buffer) {
        byte[] mbuffer = (byte[])buffer;
        for (int i = 0; i < this.SizeXY; ++i) {
            mbuffer[i] = this.myData[i + this.Sizes[0] * this.Sizes[1] * myslice];
        }
    }
}

