/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.updater;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.imagej.updater.Dependency;
import net.imagej.updater.FilesCollection;
import net.imagej.updater.UpdateSite;
import net.imagej.updater.util.Platforms;
import net.imagej.updater.util.UpdaterUtil;
import org.scijava.util.FileUtils;

public class FileObject {
    protected Map<String, FileObject> overriddenUpdateSites = new LinkedHashMap<String, FileObject>();
    private Status status;
    private Action action;
    public String updateSite;
    public String originalUpdateSite;
    public String filename;
    public String description;
    public boolean executable;
    public Version current;
    public Set<Version> previous;
    public long filesize;
    public boolean metadataChanged;
    public boolean descriptionFromPOM;
    public String localFilename;
    public String localChecksum;
    public long localTimestamp;
    protected Map<String, Dependency> dependencies;
    private Set<String> links;
    protected Set<String> authors;
    private Set<String> platforms;
    private Set<String> categories;

    public FileObject(String updateSite, String filename, long filesize, String checksum, long timestamp, Status status) {
        this.updateSite = updateSite;
        this.filename = filename;
        if (checksum != null) {
            this.current = new Version(checksum, timestamp);
        }
        this.previous = new LinkedHashSet<Version>();
        this.status = status;
        this.dependencies = new LinkedHashMap<String, Dependency>();
        this.authors = new LinkedHashSet<String>();
        this.platforms = new LinkedHashSet<String>();
        this.categories = new LinkedHashSet<String>();
        this.links = new LinkedHashSet<String>();
        this.filesize = filesize;
        this.setNoAction();
    }

    public void merge(FileObject upstream) {
        for (Version previous : upstream.previous) {
            this.addPreviousVersion(previous);
        }
        if (this.updateSite == null || this.updateSite.equals(upstream.updateSite)) {
            this.updateSite = upstream.updateSite;
            this.description = upstream.description;
            this.dependencies = upstream.dependencies;
            this.authors = upstream.authors;
            this.platforms = upstream.platforms;
            this.categories = upstream.categories;
            this.links = upstream.links;
            this.filesize = upstream.filesize;
            this.executable = upstream.executable;
            if (this.current != null && !upstream.hasPreviousVersion(this.current.checksum)) {
                this.addPreviousVersion(this.current);
            }
            this.current = upstream.current;
            this.status = upstream.status;
            this.action = upstream.action;
        } else {
            Version other = upstream.current;
            if (other != null && !this.hasPreviousVersion(other.checksum)) {
                this.addPreviousVersion(other);
            }
        }
    }

    public void completeMetadataFrom(FileObject other) {
        if (this.description == null || this.description.isEmpty()) {
            this.description = other.description;
        }
        if (this.links == null || this.links.isEmpty()) {
            this.links = other.links;
        }
        if (this.authors == null || this.authors.isEmpty()) {
            this.authors = other.authors;
        }
        if (this.platforms == null || this.platforms.isEmpty()) {
            this.platforms = other.platforms;
        }
        if (this.categories == null || this.categories.isEmpty()) {
            this.categories = other.categories;
        }
    }

    public boolean hasPreviousVersion(String checksum) {
        if (this.current != null && this.current.checksum.equals(checksum)) {
            return true;
        }
        for (Version version : this.previous) {
            if (!version.checksum.equals(checksum)) continue;
            return true;
        }
        for (Map.Entry entry : this.overriddenUpdateSites.entrySet()) {
            if (!((FileObject)entry.getValue()).hasPreviousVersion(checksum)) continue;
            return true;
        }
        return false;
    }

    public boolean overridesOtherUpdateSite() {
        return !this.overriddenUpdateSites.isEmpty();
    }

    public synchronized void removeFromUpdateSite(String updateSite, FilesCollection files) {
        if (!updateSite.equals(this.updateSite)) {
            return;
        }
        switch (this.status) {
            case LOCAL_ONLY: {
                return;
            }
            case NEW: 
            case NOT_INSTALLED: 
            case OBSOLETE_UNINSTALLED: {
                files.remove(this);
                break;
            }
            case MODIFIED: 
            case OBSOLETE: 
            case OBSOLETE_MODIFIED: 
            case UPDATEABLE: 
            case INSTALLED: {
                break;
            }
            default: {
                throw new RuntimeException("Unhandled status: " + (Object)((Object)this.status));
            }
        }
        FileObject overridden = null;
        Iterator<FileObject> iterator = this.overriddenUpdateSites.values().iterator();
        while (iterator.hasNext()) {
            FileObject file;
            overridden = file = iterator.next();
        }
        if (overridden == null) {
            this.setStatus(Status.OBSOLETE);
            this.setAction(files, Action.UNINSTALL);
        } else {
            files.add(overridden);
            if (this.getChecksum().equals(overridden.getChecksum()) && this.filename.equals(overridden.filename)) {
                overridden.setStatus(Status.INSTALLED);
                overridden.setAction(files, Action.INSTALLED);
            } else if (overridden.current != null) {
                overridden.setStatus(Status.MODIFIED);
                overridden.setAction(files, Action.UPDATE);
                if (!this.filename.equals(overridden.filename)) {
                    try {
                        FileObject.touch(files.prefixUpdate(this.filename));
                    }
                    catch (IOException e) {
                        files.log.warn((Object)("Cannot stage '" + this.filename + "' for uninstall"), (Throwable)e);
                    }
                }
            } else {
                overridden.setStatus(Status.OBSOLETE);
                overridden.setAction(files, Action.UNINSTALL);
                overridden.filename = this.filename;
            }
        }
    }

    public boolean isNewerThan(long timestamp) {
        if (this.current != null && this.current.timestamp <= timestamp) {
            return false;
        }
        for (Version version : this.previous) {
            if (version.timestamp > timestamp) continue;
            return false;
        }
        return true;
    }

    void setVersion(String checksum, long timestamp) {
        if (this.current != null) {
            this.previous.add(this.current);
        }
        this.current = new Version(checksum, timestamp);
        this.current.filename = this.filename;
    }

    public void setLocalVersion(String filename, String checksum, long timestamp) {
        this.localFilename = filename;
        if (!this.localFilename.equals(this.filename)) {
            this.metadataChanged = true;
        }
        this.localChecksum = checksum;
        this.localTimestamp = timestamp;
        if (this.current != null && checksum.equals(this.current.checksum)) {
            if (this.status != Status.LOCAL_ONLY) {
                this.status = Status.INSTALLED;
            }
            this.setNoAction();
            return;
        }
        this.status = this.hasPreviousVersion(checksum) ? (this.current == null ? Status.OBSOLETE : Status.UPDATEABLE) : (this.current == null ? Status.OBSOLETE_MODIFIED : Status.MODIFIED);
        this.setNoAction();
    }

    public String getDescription() {
        return this.description;
    }

    public void addDependency(FilesCollection files, FileObject dependency) {
        String filename = dependency.getFilename();
        this.addDependency(filename, files.prefix(filename));
    }

    public void addDependency(String filename, File file) {
        this.addDependency(filename, UpdaterUtil.getTimestamp(file), false);
    }

    public void addDependency(String filename, long timestamp, boolean overrides) {
        this.addDependency(new Dependency(filename, timestamp, overrides));
    }

    public void addDependency(Dependency dependency) {
        if (dependency.filename == null || "".equals(dependency.filename.trim())) {
            return;
        }
        String key = FileObject.getFilename(dependency.filename, true);
        if (this.dependencies.containsKey(key)) {
            Dependency other = this.dependencies.get(key);
            if (other.filename.equals(dependency.filename) || other.timestamp >= dependency.timestamp) {
                return;
            }
        }
        dependency.filename = key;
        this.dependencies.put(key, dependency);
    }

    public void removeDependency(String other) {
        this.dependencies.remove(FileObject.getFilename(other, true));
    }

    public boolean hasDependency(String filename) {
        return this.dependencies.containsKey(FileObject.getFilename(filename, true));
    }

    public void addLink(String link) {
        this.links.add(link);
    }

    public Iterable<String> getLinks() {
        return this.links;
    }

    public void addAuthor(String author) {
        this.authors.add(author);
    }

    public Iterable<String> getAuthors() {
        return this.authors;
    }

    public void addPlatform(String platform) {
        if (platform == null) {
            return;
        }
        for (String p : platform.split(",")) {
            if ("linux".equals(p = p.trim())) {
                this.platforms.add("linux32");
                continue;
            }
            if (p.isEmpty()) continue;
            this.platforms.add(p);
        }
    }

    public Collection<String> getPlatforms() {
        return this.platforms;
    }

    public void addCategory(String category) {
        this.categories.add(category);
    }

    public void replaceList(String tag, String ... list) {
        Set<String> map;
        if (tag.equals("Dependency")) {
            long now = Long.parseLong(UpdaterUtil.timestamp(new Date().getTime()));
            Dependency[] newList = new Dependency[list.length];
            for (int i = 0; i < list.length; ++i) {
                Dependency dep;
                int obsoleted = 0;
                String item = list[i].trim();
                if (item.startsWith("obsoletes ")) {
                    item = item.substring(10);
                    obsoleted = 1;
                }
                if ((dep = this.dependencies.get(item)) == null) {
                    dep = new Dependency(item, now, obsoleted != 0);
                } else if (dep.overrides != obsoleted) {
                    dep.timestamp = now;
                    dep.overrides = obsoleted;
                }
                newList[i] = dep;
            }
            this.dependencies.clear();
            for (Dependency dep : newList) {
                this.addDependency(dep);
            }
            return;
        }
        Set<String> set = tag.equals("Link") ? this.links : (tag.equals("Author") ? this.authors : (tag.equals("Platform") ? this.platforms : (map = tag.equals("Category") ? this.categories : null)));
        if (map == null) {
            return;
        }
        map.clear();
        for (String string : list) {
            map.add(string.trim());
        }
    }

    public Iterable<String> getCategories() {
        return this.categories;
    }

    public Iterable<Version> getPrevious() {
        return this.previous;
    }

    @Deprecated
    public void addPreviousVersion(String checksum, long timestamp, String filename) {
        Version version = new Version(checksum, timestamp);
        if (filename != null && !"".equals(filename)) {
            version.filename = filename;
        }
        if (!this.previous.contains(version)) {
            this.previous.add(version);
        }
    }

    public void addPreviousVersion(Version version) {
        if (!this.previous.contains(version)) {
            this.previous.add(new Version(version));
        }
    }

    public void addPreviousVersion(String checksum, long timestamp, String filename, long timestampObsolete) {
        Version version = new Version(checksum, timestamp);
        version.timestampObsolete = timestampObsolete;
        if (filename != null && !filename.isEmpty()) {
            version.filename = filename;
        }
        this.addPreviousVersion(version);
    }

    public void setNoAction() {
        this.action = this.status.getNoAction();
    }

    public void setAction(FilesCollection files, Action action) {
        if (!(this.status.isValid(action) || action.equals((Object)Action.REMOVE) && this.overridesOtherUpdateSite() || action.equals((Object)Action.UPLOAD) && this.localFilename != null && !this.localFilename.equals(this.filename))) {
            throw new Error("Invalid action requested for file " + this.filename + "(" + (Object)((Object)action) + ", " + (Object)((Object)this.status) + ")");
        }
        if (action == Action.UPLOAD) {
            if (this.current == null) {
                this.current = new Version(this.localChecksum, this.localTimestamp);
            }
            if (this.localFilename != null) {
                this.current.filename = this.filename;
                this.filename = this.localFilename;
            }
            if (this.updateSite == null) {
                Collection<String> sites = files.getSiteNamesToUpload();
                if (sites == null || sites.size() != 1) {
                    throw new Error("Need an update site to upload to!");
                }
                this.updateSite = sites.iterator().next();
            }
            files.updateDependencies(this);
        } else if (this.originalUpdateSite != null && action != Action.REMOVE) {
            this.updateSite = this.originalUpdateSite;
            this.originalUpdateSite = null;
        }
        this.action = action;
    }

    public boolean setFirstValidAction(FilesCollection files, Action ... actions) {
        for (Action action : actions) {
            if (!this.status.isValid(action)) continue;
            this.setAction(files, action);
            return true;
        }
        return false;
    }

    public void setStatus(Status status) {
        this.status = status;
        this.setNoAction();
    }

    public void markUploaded() {
        if (this.isLocalOnly()) {
            this.status = Status.INSTALLED;
            this.localChecksum = this.current.checksum;
            this.localTimestamp = this.current.timestamp;
        } else if (this.isObsolete() || this.status == Status.UPDATEABLE) {
            this.status = Status.INSTALLED;
            this.setVersion(this.localChecksum, this.localTimestamp);
        } else {
            if (!this.metadataChanged && (this.localChecksum == null || this.localChecksum.equals(this.current.checksum))) {
                throw new Error(this.filename + " is already uploaded");
            }
            this.setVersion(this.localChecksum, this.localTimestamp);
        }
    }

    @Deprecated
    public void markRemoved() {
        throw new UnsupportedOperationException("Use #markRemoved(FilesCollection) instead!");
    }

    public void markRemoved(FilesCollection files) {
        FileObject file;
        FileObject overriding = null;
        int overridingRank = -1;
        for (Map.Entry<String, FileObject> entry : this.overriddenUpdateSites.entrySet()) {
            UpdateSite site;
            file = entry.getValue();
            if (file.isObsolete() || overridingRank >= (site = files.getUpdateSite(entry.getKey(), true)).getRank()) continue;
            overriding = file;
            overridingRank = site.getRank();
        }
        this.current.timestampObsolete = UpdaterUtil.currentTimestamp();
        this.addPreviousVersion(this.current);
        this.setStatus(Status.OBSOLETE_UNINSTALLED);
        this.current = null;
        if (overriding != null) {
            for (Map.Entry<String, FileObject> entry : this.overriddenUpdateSites.entrySet()) {
                file = entry.getValue();
                if (file == overriding) continue;
                overriding.overriddenUpdateSites.put(entry.getKey(), file);
            }
            overriding.overriddenUpdateSites.put(this.updateSite, this);
            files.add(overriding);
        }
    }

    public String getLocalFilename(boolean forDisplay) {
        if (this.localFilename == null || this.localFilename.equals(this.filename)) {
            return this.filename;
        }
        if (!forDisplay) {
            return this.localFilename;
        }
        return this.filename + " (local: " + this.localFilename + ")";
    }

    public String getFilename() {
        return this.getFilename(false);
    }

    public String getFilename(boolean stripVersion) {
        return FileObject.getFilename(this.filename, stripVersion);
    }

    public static String getFilename(String filename, boolean stripVersion) {
        if (stripVersion) {
            return FileUtils.stripFilenameVersion((String)filename);
        }
        return filename;
    }

    public String getFilename(long timestamp) {
        if (this.current != null && timestamp >= this.current.timestamp) {
            return this.filename;
        }
        String result = null;
        long matchedTimestamp = 0L;
        for (Version version : this.previous) {
            if (timestamp < version.timestamp || version.timestamp <= matchedTimestamp) continue;
            result = version.filename;
            matchedTimestamp = version.timestamp;
        }
        return result;
    }

    public String getBaseName() {
        String unversioned = FileUtils.stripFilenameVersion((String)this.filename);
        return unversioned.endsWith(".jar") ? unversioned.substring(0, unversioned.length() - 4) : unversioned;
    }

    public String getChecksum() {
        return this.action == Action.UPLOAD ? this.localChecksum : (this.action == Action.REMOVE || this.current == null ? null : this.current.checksum);
    }

    public long getTimestamp() {
        return this.action == Action.UPLOAD ? (this.status == Status.LOCAL_ONLY && this.current != null ? this.current.timestamp : this.localTimestamp) : (this.action == Action.REMOVE || this.current == null ? 0L : this.current.timestamp);
    }

    public Iterable<Dependency> getDependencies() {
        return this.dependencies.values();
    }

    public Iterable<FileObject> getFileDependencies(FilesCollection files, boolean recursive) {
        LinkedHashSet<FileObject> result = new LinkedHashSet<FileObject>();
        if (recursive) {
            result.add(this);
        }
        Stack<FileObject> stack = new Stack<FileObject>();
        stack.push(this);
        while (!stack.empty()) {
            FileObject file = (FileObject)stack.pop();
            for (Dependency dependency : file.getDependencies()) {
                FileObject file2 = files.get(dependency.filename);
                if (file2 == null || file2.isObsolete()) continue;
                if (recursive && !result.contains(file2)) {
                    stack.push(file2);
                }
                result.add(file2);
            }
        }
        return result;
    }

    public Status getStatus() {
        return this.status;
    }

    public Action getAction() {
        return this.action;
    }

    public boolean isInstallable() {
        return this.status.isValid(Action.INSTALL);
    }

    public boolean isUpdateable() {
        return this.status.isValid(Action.UPDATE);
    }

    public boolean isUninstallable() {
        return this.status.isValid(Action.UNINSTALL);
    }

    public boolean isLocallyModified() {
        return this.status.getNoAction() == Action.MODIFIED;
    }

    @Deprecated
    public boolean isUploadable(FilesCollection files) {
        return this.isUploadable(files, false);
    }

    public boolean isUploadable(FilesCollection files, boolean assumeModified) {
        switch (this.status) {
            case INSTALLED: {
                if (assumeModified) break;
                return false;
            }
        }
        if (this.updateSite == null) {
            return files.hasUploadableSites();
        }
        UpdateSite updateSite = files.getUpdateSite(this.updateSite, false);
        return updateSite != null && updateSite.isUploadable();
    }

    public boolean actionSpecified() {
        return this.action != this.status.getNoAction();
    }

    public boolean toUpdate() {
        return this.action == Action.UPDATE;
    }

    public boolean toUninstall() {
        return this.action == Action.UNINSTALL;
    }

    public boolean toInstall() {
        return this.action == Action.INSTALL;
    }

    public boolean toUpload() {
        return this.action == Action.UPLOAD;
    }

    public boolean isObsolete() {
        switch (this.status) {
            case OBSOLETE_UNINSTALLED: 
            case OBSOLETE: 
            case OBSOLETE_MODIFIED: {
                return true;
            }
        }
        return false;
    }

    public boolean isForPlatform(String platform) {
        return Platforms.matches(platform, this.platforms);
    }

    public boolean isActivePlatform(FilesCollection files) {
        if (this.platforms.isEmpty()) {
            return true;
        }
        for (String platform : this.platforms) {
            if (!files.isActivePlatform(platform)) continue;
            return true;
        }
        return false;
    }

    public boolean isLocalOnly() {
        return this.status == Status.LOCAL_ONLY;
    }

    public boolean willNotBeInstalled() {
        switch (this.action) {
            case NOT_INSTALLED: 
            case NEW: 
            case UNINSTALL: 
            case REMOVE: {
                return true;
            }
            case LOCAL_ONLY: 
            case INSTALLED: 
            case UPDATEABLE: 
            case MODIFIED: 
            case OBSOLETE: 
            case INSTALL: 
            case UPDATE: 
            case UPLOAD: {
                return false;
            }
        }
        throw new RuntimeException("Unhandled action: " + (Object)((Object)this.action));
    }

    public boolean willBeUpToDate() {
        switch (this.action) {
            case NOT_INSTALLED: 
            case NEW: 
            case UNINSTALL: 
            case REMOVE: 
            case UPDATEABLE: 
            case MODIFIED: 
            case OBSOLETE: {
                return false;
            }
            case LOCAL_ONLY: 
            case INSTALLED: 
            case INSTALL: 
            case UPDATE: 
            case UPLOAD: {
                return true;
            }
        }
        throw new RuntimeException("Unhandled action: " + (Object)((Object)this.action));
    }

    public boolean isUpdateable(boolean evenForcedUpdates) {
        return this.action == Action.UPDATE || this.action == Action.INSTALL || this.status == Status.UPDATEABLE || this.status == Status.OBSOLETE || evenForcedUpdates && (this.status.isValid(Action.UPDATE) || this.status == Status.OBSOLETE_MODIFIED);
    }

    public boolean stageForUpdate(FilesCollection files, boolean evenForcedOnes) {
        if (!evenForcedOnes && this.status == Status.MODIFIED) {
            return false;
        }
        if (!this.setFirstValidAction(files, Action.UPDATE, Action.INSTALL)) {
            return false;
        }
        for (FileObject file : this.getFileDependencies(files, true)) {
            if (!evenForcedOnes && (file.status == Status.MODIFIED || file.status == Status.OBSOLETE_MODIFIED)) continue;
            file.setFirstValidAction(files, Action.UPDATE, Action.INSTALL);
        }
        return true;
    }

    public void stageForUpload(FilesCollection files, String updateSite) {
        if (this.status == Status.LOCAL_ONLY) {
            this.localChecksum = this.current.checksum;
            this.localTimestamp = this.current.timestamp;
        }
        this.updateSite = updateSite;
        if (this.status == Status.NOT_INSTALLED) {
            this.setAction(files, Action.REMOVE);
        } else {
            this.setAction(files, Action.UPLOAD);
        }
        String baseName = this.getBaseName();
        String withoutVersion = this.getFilename(true);
        ArrayList<Dependency> fixup = new ArrayList<Dependency>();
        for (FileObject file : files.forUpdateSite(updateSite)) {
            if (file.isObsolete()) continue;
            fixup.clear();
            for (Dependency dependency : file.getDependencies()) {
                if (dependency.overrides || !dependency.filename.startsWith(baseName) || !withoutVersion.equals(FileObject.getFilename(dependency.filename, true)) || dependency.filename.equals(this.filename)) continue;
                fixup.add(dependency);
            }
            for (Dependency dependency : fixup) {
                file.dependencies.remove(dependency.filename);
                dependency.filename = this.filename;
                file.dependencies.put(this.filename, dependency);
            }
        }
    }

    public void stageForUninstall(FilesCollection files) throws IOException {
        String filename = this.getLocalFilename(false);
        if (this.action != Action.UNINSTALL) {
            this.setAction(files, Action.UNINSTALL);
        }
        if (filename.endsWith(".jar")) {
            FileObject.touch(files.prefixUpdate(filename));
        } else {
            String old = filename + ".old";
            if (old.endsWith(".exe.old")) {
                old = old.substring(0, old.length() - 8) + ".old.exe";
            }
            files.prefix(filename).renameTo(files.prefix(old));
            FileObject.touch(files.prefixUpdate(old));
        }
        if (this.status != Status.LOCAL_ONLY) {
            this.setStatus(this.isObsolete() ? Status.OBSOLETE_UNINSTALLED : Status.NOT_INSTALLED);
        }
    }

    public static void touch(File file) throws IOException {
        if (file.exists()) {
            long now = new Date().getTime();
            file.setLastModified(now);
        } else {
            File parent = file.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            file.createNewFile();
        }
    }

    public String toDebug() {
        return this.filename + "(" + (Object)((Object)this.status) + ", " + (Object)((Object)this.action) + ")";
    }

    public String toString() {
        return this.filename;
    }

    public static enum Status {
        NOT_INSTALLED(Action.NOT_INSTALLED, Action.INSTALL, Action.REMOVE),
        INSTALLED(Action.INSTALLED, Action.UNINSTALL),
        UPDATEABLE(Action.UPDATEABLE, Action.UNINSTALL, Action.UPDATE, Action.UPLOAD),
        MODIFIED(Action.MODIFIED, Action.UNINSTALL, Action.UPDATE, Action.UPLOAD),
        LOCAL_ONLY(Action.LOCAL_ONLY, Action.UNINSTALL, Action.UPLOAD),
        NEW(Action.NEW, Action.INSTALL, Action.REMOVE),
        OBSOLETE_UNINSTALLED(Action.NOT_INSTALLED),
        OBSOLETE(Action.OBSOLETE, Action.UNINSTALL, Action.UPLOAD),
        OBSOLETE_MODIFIED(Action.MODIFIED, Action.UNINSTALL, Action.UPLOAD);

        private final Action[] actions;
        private final boolean[] validActions;

        private Status(Action ... actions) {
            this.actions = actions;
            this.validActions = new boolean[Action.values().length];
            for (Action action : actions) {
                this.validActions[action.ordinal()] = true;
            }
        }

        @Deprecated
        public Action[] getActions() {
            return this.actions;
        }

        public Action[] getDeveloperActions() {
            return this.actions;
        }

        public boolean isValid(Action action) {
            return this.validActions[action.ordinal()];
        }

        public Action getNoAction() {
            return this.actions[0];
        }
    }

    public static enum Action {
        LOCAL_ONLY("Local-only"),
        NOT_INSTALLED("Not installed"),
        INSTALLED("Up-to-date"),
        UPDATEABLE("Update available"),
        MODIFIED("Locally modified"),
        NEW("New file"),
        OBSOLETE("Obsolete"),
        UNINSTALL("Uninstall it"),
        INSTALL("Install it"),
        UPDATE("Update it"),
        UPLOAD("Upload it"),
        REMOVE("Remove it");

        private final String label;

        private Action(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static class Version
    implements Comparable<Version> {
        public String checksum;
        public long timestamp;
        public long timestampObsolete;
        public String filename;

        Version(String checksum, long timestamp) {
            this.checksum = checksum;
            this.timestamp = timestamp;
        }

        public Version(Version other) {
            this.checksum = other.checksum;
            this.timestamp = other.timestamp;
            this.filename = other.filename;
            this.timestampObsolete = other.timestampObsolete;
        }

        @Override
        public int compareTo(Version other) {
            long diff = this.timestamp - other.timestamp;
            if (diff != 0L) {
                return diff < 0L ? -1 : 1;
            }
            return this.checksum.compareTo(other.checksum);
        }

        public boolean equals(Object other) {
            return other instanceof Version && this.equals((Version)other);
        }

        public boolean equals(Version other) {
            return this.timestamp == other.timestamp && this.checksum.equals(other.checksum);
        }

        public int hashCode() {
            return (this.checksum == null ? 0 : this.checksum.hashCode()) ^ new Long(this.timestamp).hashCode();
        }

        public String toString() {
            return "Version(" + this.checksum + ";" + this.timestamp + ")";
        }
    }
}

