/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.behaviour.io.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import org.scijava.ui.behaviour.io.gui.RoundBorder;

public class TagPanelEditor
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String COMMIT_ACTION = "commit";
    protected final List<String> selectedTags;
    protected final List<TagPanel> tagPanels;
    protected final List<String> tags;
    private final JTextField textField;
    private final boolean editable;
    private final HashSet<TagSelectionChangeListener> listeners;
    private final Map<String, String> printables;

    public TagPanelEditor(Collection<String> tags) {
        this(tags, true);
    }

    public TagPanelEditor(Collection<String> tags, boolean editable) {
        this(tags, editable, Collections.emptyMap());
    }

    public TagPanelEditor(Collection<String> tags, boolean editable, Map<String, String> printables) {
        this.editable = editable;
        this.printables = printables;
        this.tags = new ArrayList<String>(tags);
        this.tags.sort(null);
        this.selectedTags = new ArrayList<String>();
        this.tagPanels = new ArrayList<TagPanel>();
        this.listeners = new HashSet();
        this.setPreferredSize(new Dimension(400, 26));
        this.setMinimumSize(new Dimension(26, 26));
        this.setLayout(new BoxLayout(this, 2));
        this.textField = new JTextField();
        this.textField.setColumns(10);
        this.textField.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.textField.setOpaque(false);
        this.textField.setEditable(editable);
        if (editable) {
            Autocomplete autoComplete = new Autocomplete();
            this.textField.getDocument().addDocumentListener(autoComplete);
            this.textField.getInputMap().put(KeyStroke.getKeyStroke(10, 0), COMMIT_ACTION);
            this.textField.setFocusTraversalKeys(0, Collections.emptySet());
            this.textField.getInputMap().put(KeyStroke.getKeyStroke(9, 0), COMMIT_ACTION);
            this.textField.getActionMap().put(COMMIT_ACTION, autoComplete.new Autocomplete.CommitAction());
            this.textField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 8 && TagPanelEditor.this.textField.getText().isEmpty() && !TagPanelEditor.this.selectedTags.isEmpty()) {
                        TagPanelEditor.this.removeTag(TagPanelEditor.this.selectedTags.get(TagPanelEditor.this.selectedTags.size() - 1));
                        e.consume();
                    }
                }
            });
        }
        this.add(this.textField);
        this.add(Box.createHorizontalGlue());
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBorder(UIManager.getBorder("TextField.border"));
        this.setBackground(UIManager.getColor("TextField.background"));
    }

    public List<String> getSelectedTags() {
        return Collections.unmodifiableList(this.selectedTags);
    }

    public void setTags(Collection<String> tags) {
        for (TagPanel tagPanel : this.tagPanels) {
            this.remove(tagPanel);
        }
        this.selectedTags.clear();
        this.tagPanels.clear();
        for (String tag : tags) {
            this.addTag(tag);
        }
        this.revalidate();
        this.repaint();
    }

    public void setAcceptableTags(Collection<String> acceptableTags) {
        this.tags.clear();
        this.tags.addAll(acceptableTags);
        this.tags.sort(null);
        this.repaint();
    }

    protected void addTag(String tag) {
        TagPanel tagp = new TagPanel(tag, this.tags.contains(tag));
        this.selectedTags.add(tag);
        this.tagPanels.add(tagp);
        this.add((Component)tagp, this.getComponentCount() - 2);
    }

    private void removeTag(String tag) {
        int index = this.selectedTags.indexOf(tag);
        if (index < 0) {
            return;
        }
        this.selectedTags.remove(index);
        TagPanel tagPanel = this.tagPanels.remove(index);
        this.notifyListeners();
        this.remove(tagPanel);
        this.revalidate();
        this.repaint();
    }

    private static Box.Filler createHorizontalStrutWithMaxHeight1(int width) {
        return new Box.Filler(new Dimension(width, 0), new Dimension(width, 0), new Dimension(width, 1));
    }

    private void notifyListeners() {
        for (TagSelectionChangeListener listener : this.listeners) {
            listener.tagSelectionChanged();
        }
    }

    public void addTagSelectionChangeListener(TagSelectionChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeTagSelectionChangeListener(TagSelectionChangeListener listener) {
        this.listeners.remove(listener);
    }

    static Color mix(Color c1, Color c2, double c1Weight) {
        double c2Weight = 1.0 - c1Weight;
        return new Color((int)((double)c1.getRed() * c1Weight + (double)c2.getRed() * c2Weight), (int)((double)c1.getGreen() * c1Weight + (double)c2.getGreen() * c2Weight), (int)((double)c1.getBlue() * c1Weight + (double)c2.getBlue() * c2Weight));
    }

    final class TagPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private final JPanel content;
        private final boolean valid;
        private final JLabel txt;
        private JLabel close;

        public TagPanel(final String tag, boolean valid) {
            this.valid = valid;
            this.content = new JPanel();
            this.content.setLayout(new BoxLayout(this.content, 2));
            this.content.setOpaque(true);
            if (TagPanelEditor.this.editable) {
                this.close = new JLabel("\u00d7");
                this.close.setOpaque(false);
                this.close.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent evt) {
                        TagPanelEditor.this.removeTag(tag);
                    }
                });
                this.content.add(this.close);
                this.content.add(TagPanelEditor.createHorizontalStrutWithMaxHeight1(2));
            }
            String str = TagPanelEditor.this.printables.containsKey(tag) ? (String)TagPanelEditor.this.printables.get(tag) : tag;
            this.txt = new JLabel(str);
            this.txt.setOpaque(false);
            this.content.add(this.txt);
            this.updateTxtLook();
            this.setLayout(new BoxLayout(this, 2));
            this.add(Box.createHorizontalStrut(1));
            this.add(this.content);
            this.add(Box.createHorizontalStrut(4));
            this.setOpaque(false);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.updateTxtLook();
        }

        private void updateTxtLook() {
            if (this.content != null) {
                Color tfg = UIManager.getColor("TextField.foreground");
                Color tbg = UIManager.getColor("TextField.background");
                Color bg = this.valid ? TagPanelEditor.mix(tbg, tfg, 0.95) : TagPanelEditor.mix(tbg, Color.red, 0.5);
                Color borderColor = TagPanelEditor.mix(bg, tfg, 0.8);
                this.content.setBackground(bg);
                this.content.setBorder(new RoundBorder(borderColor, TagPanelEditor.this, 1));
                Font font = UIManager.getFont("Label.font");
                font = font.deriveFont(font.getSize2D() - 2.0f);
                this.txt.setFont(font);
                if (this.close != null) {
                    this.close.setFont(font);
                }
            }
        }
    }

    private class Autocomplete
    implements DocumentListener {
        private Autocomplete() {
        }

        @Override
        public void changedUpdate(DocumentEvent ev) {
        }

        @Override
        public void removeUpdate(DocumentEvent ev) {
        }

        @Override
        public void insertUpdate(DocumentEvent ev) {
            String match;
            int w;
            if (ev.getLength() != 1) {
                return;
            }
            int pos = ev.getOffset();
            String content = null;
            try {
                content = TagPanelEditor.this.textField.getText(0, pos + 1);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            for (w = pos; w >= 0 && Character.isLetter(content.charAt(w)); --w) {
            }
            if (pos - w < 2) {
                return;
            }
            String prefix = content.substring(w + 1).toLowerCase();
            int n = Collections.binarySearch(TagPanelEditor.this.tags, prefix);
            if (n < 0 && -n <= TagPanelEditor.this.tags.size() && (match = TagPanelEditor.this.tags.get(-n - 1)).startsWith(prefix)) {
                String completion = match.substring(pos - w);
                SwingUtilities.invokeLater(new CompletionTask(completion, pos + 1));
            }
        }

        private class CompletionTask
        implements Runnable {
            private final String completion;
            private final int position;

            CompletionTask(String completion, int position) {
                this.completion = completion;
                this.position = position;
            }

            @Override
            public void run() {
                StringBuffer sb = new StringBuffer(TagPanelEditor.this.textField.getText());
                sb.insert(this.position, this.completion);
                TagPanelEditor.this.textField.setText(sb.toString());
                TagPanelEditor.this.textField.setCaretPosition(this.position + this.completion.length());
                TagPanelEditor.this.textField.moveCaretPosition(this.position);
            }
        }

        public class CommitAction
        extends AbstractAction {
            private static final long serialVersionUID = 5794543109646743416L;

            @Override
            public void actionPerformed(ActionEvent ev) {
                String tag = TagPanelEditor.this.textField.getText();
                if (tag.isEmpty()) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                    return;
                }
                if (TagPanelEditor.this.selectedTags.contains(tag)) {
                    TagPanelEditor.this.textField.setText("");
                    return;
                }
                TagPanelEditor.this.addTag(tag);
                TagPanelEditor.this.textField.setText("");
                TagPanelEditor.this.notifyListeners();
                TagPanelEditor.this.revalidate();
                TagPanelEditor.this.repaint();
            }
        }
    }

    @FunctionalInterface
    public static interface TagSelectionChangeListener {
        public void tagSelectionChanged();
    }
}

