/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.colourDeconvolution;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.NewImage;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.util.regex.Pattern;

public class StainMatrix {
    double[] MODx;
    double[] MODy;
    double[] MODz;
    String myStain;
    private double[] cosx = new double[3];
    private double[] cosy = new double[3];
    private double[] cosz = new double[3];

    public StainMatrix() {
        this.MODx = new double[3];
        this.MODy = new double[3];
        this.MODz = new double[3];
    }

    public void init(String line) {
        String[] parts = line.split(Pattern.quote(","));
        if (parts.length != 10) {
            return;
        }
        this.myStain = parts[0].replaceAll("\\s+$", "");
        this.MODx[0] = Double.parseDouble(parts[1].replaceAll("\\s+$", ""));
        this.MODy[0] = Double.parseDouble(parts[2].replaceAll("\\s+$", ""));
        this.MODz[0] = Double.parseDouble(parts[3].replaceAll("\\s+$", ""));
        this.MODx[1] = Double.parseDouble(parts[4].replaceAll("\\s+$", ""));
        this.MODy[1] = Double.parseDouble(parts[5].replaceAll("\\s+$", ""));
        this.MODz[1] = Double.parseDouble(parts[6].replaceAll("\\s+$", ""));
        this.MODx[2] = Double.parseDouble(parts[7].replaceAll("\\s+$", ""));
        this.MODy[2] = Double.parseDouble(parts[8].replaceAll("\\s+$", ""));
        this.MODz[2] = Double.parseDouble(parts[9].replaceAll("\\s+$", ""));
    }

    public void init(String stainName, double x0, double y0, double z0, double x1, double y1, double z1, double x2, double y2, double z2) {
        this.myStain = stainName;
        this.MODx[0] = x0;
        this.MODy[0] = y0;
        this.MODz[0] = z0;
        this.MODx[1] = x1;
        this.MODy[1] = y1;
        this.MODz[1] = z1;
        this.MODx[2] = x2;
        this.MODy[2] = y2;
        this.MODz[2] = z2;
    }

    public double[] getMODx() {
        return this.MODx;
    }

    public void setMODx(double[] mODx) {
        this.MODx = mODx;
    }

    public double[] getMODy() {
        return this.MODy;
    }

    public void setMODy(double[] mODy) {
        this.MODy = mODy;
    }

    public double[] getMODz() {
        return this.MODz;
    }

    public void setMODz(double[] mODz) {
        this.MODz = mODz;
    }

    public void computeAndShow(boolean doIshow, boolean hideLegend, ImagePlus imp) {
        String title = imp.getTitle();
        ImageStack[] stack = this.compute(doIshow, hideLegend, imp);
        new ImagePlus(title + "-(Colour_1)", stack[0]).show();
        new ImagePlus(title + "-(Colour_2)", stack[1]).show();
        new ImagePlus(title + "-(Colour_3)", stack[2]).show();
    }

    public ImageStack[] compute(boolean doIshow, boolean hideLegend, ImagePlus imp) {
        int i;
        ImageStack stack = imp.getStack();
        int width = stack.getWidth();
        int height = stack.getHeight();
        double[] len = new double[3];
        double[] q = new double[9];
        byte[] rLUT = new byte[256];
        byte[] gLUT = new byte[256];
        byte[] bLUT = new byte[256];
        double log255 = Math.log(255.0);
        for (i = 0; i < 3; ++i) {
            this.cosz[i] = 0.0;
            this.cosy[i] = 0.0;
            this.cosx[i] = 0.0;
            len[i] = Math.sqrt(this.MODx[i] * this.MODx[i] + this.MODy[i] * this.MODy[i] + this.MODz[i] * this.MODz[i]);
            if (len[i] == 0.0) continue;
            this.cosx[i] = this.MODx[i] / len[i];
            this.cosy[i] = this.MODy[i] / len[i];
            this.cosz[i] = this.MODz[i] / len[i];
        }
        if (this.cosx[1] == 0.0 && this.cosy[1] == 0.0 && this.cosz[1] == 0.0) {
            this.cosx[1] = this.cosz[0];
            this.cosy[1] = this.cosx[0];
            this.cosz[1] = this.cosy[0];
        }
        if (this.cosx[2] == 0.0 && this.cosy[2] == 0.0 && this.cosz[2] == 0.0) {
            if (this.cosx[0] * this.cosx[0] + this.cosx[1] * this.cosx[1] > 1.0) {
                if (doIshow) {
                    IJ.log((String)"Colour_3 has a negative R component.");
                }
                this.cosx[2] = 0.0;
            } else {
                this.cosx[2] = Math.sqrt(1.0 - this.cosx[0] * this.cosx[0] - this.cosx[1] * this.cosx[1]);
            }
            if (this.cosy[0] * this.cosy[0] + this.cosy[1] * this.cosy[1] > 1.0) {
                if (doIshow) {
                    IJ.log((String)"Colour_3 has a negative G component.");
                }
                this.cosy[2] = 0.0;
            } else {
                this.cosy[2] = Math.sqrt(1.0 - this.cosy[0] * this.cosy[0] - this.cosy[1] * this.cosy[1]);
            }
            if (this.cosz[0] * this.cosz[0] + this.cosz[1] * this.cosz[1] > 1.0) {
                if (doIshow) {
                    IJ.log((String)"Colour_3 has a negative B component.");
                }
                this.cosz[2] = 0.0;
            } else {
                this.cosz[2] = Math.sqrt(1.0 - this.cosz[0] * this.cosz[0] - this.cosz[1] * this.cosz[1]);
            }
        }
        double leng = Math.sqrt(this.cosx[2] * this.cosx[2] + this.cosy[2] * this.cosy[2] + this.cosz[2] * this.cosz[2]);
        this.cosx[2] = this.cosx[2] / leng;
        this.cosy[2] = this.cosy[2] / leng;
        this.cosz[2] = this.cosz[2] / leng;
        for (i = 0; i < 3; ++i) {
            if (this.cosx[i] == 0.0) {
                this.cosx[i] = 0.001;
            }
            if (this.cosy[i] == 0.0) {
                this.cosy[i] = 0.001;
            }
            if (this.cosz[i] != 0.0) continue;
            this.cosz[i] = 0.001;
        }
        if (!hideLegend) {
            this.showLegend(this.myStain);
        }
        if (doIshow) {
            this.showMatrix(this.myStain);
        }
        double A = this.cosy[1] - this.cosx[1] * this.cosy[0] / this.cosx[0];
        double V = this.cosz[1] - this.cosx[1] * this.cosz[0] / this.cosx[0];
        double C = this.cosz[2] - this.cosy[2] * V / A + this.cosx[2] * (V / A * this.cosy[0] / this.cosx[0] - this.cosz[0] / this.cosx[0]);
        q[2] = (-this.cosx[2] / this.cosx[0] - this.cosx[2] / A * this.cosx[1] / this.cosx[0] * this.cosy[0] / this.cosx[0] + this.cosy[2] / A * this.cosx[1] / this.cosx[0]) / C;
        q[1] = -q[2] * V / A - this.cosx[1] / (this.cosx[0] * A);
        q[0] = 1.0 / this.cosx[0] - q[1] * this.cosy[0] / this.cosx[0] - q[2] * this.cosz[0] / this.cosx[0];
        q[5] = (-this.cosy[2] / A + this.cosx[2] / A * this.cosy[0] / this.cosx[0]) / C;
        q[4] = -q[5] * V / A + 1.0 / A;
        q[3] = -q[4] * this.cosy[0] / this.cosx[0] - q[5] * this.cosz[0] / this.cosx[0];
        q[8] = 1.0 / C;
        q[7] = -q[8] * V / A;
        q[6] = -q[7] * this.cosy[0] / this.cosx[0] - q[8] * this.cosz[0] / this.cosx[0];
        ImageStack[] outputstack = new ImageStack[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int j = 0; j < 256; ++j) {
                rLUT[255 - j] = (byte)(255.0 - (double)j * this.cosx[i2]);
                gLUT[255 - j] = (byte)(255.0 - (double)j * this.cosy[i2]);
                bLUT[255 - j] = (byte)(255.0 - (double)j * this.cosz[i2]);
            }
            IndexColorModel cm = new IndexColorModel(8, 256, rLUT, gLUT, bLUT);
            outputstack[i2] = new ImageStack(width, height, (ColorModel)cm);
        }
        int imagesize = width * height;
        int modulo = imagesize / 60;
        for (int imagenum = 1; imagenum <= stack.getSize(); ++imagenum) {
            int[] pixels = (int[])stack.getPixels(imagenum);
            String label = stack.getSliceLabel(imagenum);
            byte[][] newpixels = new byte[][]{new byte[imagesize], new byte[imagesize], new byte[imagesize]};
            for (int j = 0; j < imagesize; ++j) {
                if (j % modulo == 0) {
                    IJ.showProgress((int)j, (int)imagesize);
                }
                int R = (pixels[j] & 0xFF0000) >> 16;
                int G = (pixels[j] & 0xFF00) >> 8;
                int B = pixels[j] & 0xFF;
                double Rlog = -(255.0 * Math.log(((double)R + 1.0) / 255.0) / log255);
                double Glog = -(255.0 * Math.log(((double)G + 1.0) / 255.0) / log255);
                double Blog = -(255.0 * Math.log(((double)B + 1.0) / 255.0) / log255);
                for (int i3 = 0; i3 < 3; ++i3) {
                    double Rscaled = Rlog * q[i3 * 3];
                    double Gscaled = Glog * q[i3 * 3 + 1];
                    double Bscaled = Blog * q[i3 * 3 + 2];
                    double output = Math.exp(-(Rscaled + Gscaled + Bscaled - 255.0) * log255 / 255.0);
                    if (output > 255.0) {
                        output = 255.0;
                    }
                    newpixels[i3][j] = (byte)(0xFF & (int)Math.floor(output + 0.5));
                }
            }
            outputstack[0].addSlice(label, (Object)newpixels[0]);
            outputstack[1].addSlice(label, (Object)newpixels[1]);
            outputstack[2].addSlice(label, (Object)newpixels[2]);
        }
        IJ.showProgress((double)1.0);
        return outputstack;
    }

    private void showLegend(String myStain) {
        ImagePlus imp0 = NewImage.createRGBImage((String)"Colour Deconvolution", (int)350, (int)65, (int)1, (int)0);
        ImageProcessor ip0 = imp0.getProcessor();
        ip0.setFont(new Font("Monospaced", 1, 11));
        ip0.setAntialiasedText(true);
        ip0.setColor(Color.black);
        ip0.moveTo(10, 15);
        ip0.drawString("Colour deconvolution: " + myStain);
        ip0.setFont(new Font("Monospaced", 0, 10));
        for (int i = 0; i < 3; ++i) {
            ip0.setRoi(10, 18 + i * 15, 14, 14);
            ip0.setColor(((255 - (int)(255.0 * this.cosx[i]) & 0xFF) << 16) + ((255 - (int)(255.0 * this.cosy[i]) & 0xFF) << 8) + (255 - (int)(255.0 * this.cosz[i]) & 0xFF));
            ip0.fill();
            ip0.setFont(new Font("Monospaced", 0, 10));
            ip0.setAntialiasedText(true);
            ip0.setColor(Color.black);
            ip0.moveTo(27, 32 + i * 15);
            ip0.drawString("Colour_" + (i + 1) + " R:" + (float)this.cosx[i] + ", G:" + (float)this.cosy[i] + ", B:" + (float)this.cosz[i]);
        }
        imp0.show();
        imp0.updateAndDraw();
    }

    private void showMatrix(String myStain) {
        int i;
        IJ.log((String)(myStain + " Vector Matrix ---"));
        for (i = 0; i < 3; ++i) {
            IJ.log((String)("Colour[" + (i + 1) + "]:\n  R" + (i + 1) + ": " + (float)this.MODx[i] + "\n  G" + (i + 1) + ": " + (float)this.MODy[i] + "\n  B" + (i + 1) + ": " + (float)this.MODz[i] + "\n \n"));
        }
        IJ.log((String)(myStain + " Java code ---"));
        IJ.log((String)"\t\tif (myStain.equals(\"New_Stain\")){");
        IJ.log((String)"\t\t// This is the New_Stain");
        for (i = 0; i < 3; ++i) {
            IJ.log((String)("\t\t\tMODx[" + i + "]=" + (float)this.cosx[i] + ";\n\t\t\tMODy[" + i + "]=" + (float)this.cosy[i] + ";\n\t\t\tMODz[" + i + "]=" + (float)this.cosz[i] + ";\n\n"));
        }
        IJ.log((String)"}");
    }

    public void init(Roi[] rois, ImageProcessor ip, String stainName) {
        this.myStain = stainName;
        double log255 = Math.log(255.0);
        double[] rgbOD = new double[]{0.0, 0.0, 0.0};
        for (int c = 0; c < 3; ++c) {
            Roi roi = rois[c];
            if (!(roi instanceof PolygonRoi)) continue;
            PolygonRoi polygon = (PolygonRoi)roi;
            Rectangle bounds = roi.getBounds();
            int w = roi.getBounds().width;
            int h = roi.getBounds().height;
            int n = polygon.getNCoordinates();
            int[] x = polygon.getXCoordinates();
            int[] y = polygon.getYCoordinates();
            for (int i = 0; i < n; ++i) {
                int p = ip.getPixel(bounds.x + x[i], bounds.y + y[i]);
                rgbOD[0] = rgbOD[0] + -(255.0 * Math.log(((double)((p & 0xFF0000) >> 16) + 1.0) / 255.0) / log255);
                rgbOD[1] = rgbOD[1] + -(255.0 * Math.log(((double)((p & 0xFF00) >> 8) + 1.0) / 255.0) / log255);
                rgbOD[2] = rgbOD[2] + -(255.0 * Math.log(((double)(p & 0xFF) + 1.0) / 255.0) / log255);
            }
            rgbOD[0] = rgbOD[0] / (double)(w * h);
            rgbOD[1] = rgbOD[1] / (double)(w * h);
            rgbOD[2] = rgbOD[2] / (double)(w * h);
            this.MODx[c] = rgbOD[0];
            this.MODy[c] = rgbOD[1];
            this.MODz[c] = rgbOD[2];
        }
    }
}

