/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm;

import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;

public class CanvasImage<T extends Type<T>>
implements OutputAlgorithm<T>,
Benchmark {
    final Image<T> input;
    final Image<T> output;
    final OutOfBoundsStrategyFactory<T> outOfBoundsFactory;
    final int numDimensions;
    final int[] newSize;
    final int[] offset;
    final int[] location;
    String errorMessage = "";
    int numThreads;
    long processingTime;

    public CanvasImage(Image<T> input, int[] newSize, int[] offset, OutOfBoundsStrategyFactory<T> outOfBoundsFactory) {
        this.input = input;
        this.outOfBoundsFactory = outOfBoundsFactory;
        this.numDimensions = input.getNumDimensions();
        this.newSize = (int[])newSize.clone();
        this.location = new int[this.numDimensions];
        this.offset = offset;
        this.processingTime = -1L;
        if (newSize == null || newSize.length != this.numDimensions) {
            this.errorMessage = "newSize is invalid: null or not of same dimensionality as input image";
            this.output = null;
        } else if (offset == null || offset.length != this.numDimensions) {
            this.errorMessage = "offset is invalid: null or not of same dimensionality as input image";
            this.output = null;
        } else {
            for (int d = 0; d < this.numDimensions; ++d) {
                if (outOfBoundsFactory != null || offset[d] >= 0) continue;
                this.errorMessage = "no OutOfBoundsStrategyFactory given but image size should increase, that is not possible";
            }
            this.output = this.errorMessage.length() == 0 ? input.createNewImage(newSize) : null;
        }
    }

    public int[] getOffset() {
        return (int[])this.offset.clone();
    }

    public CanvasImage(Image<T> input, int[] newSize, OutOfBoundsStrategyFactory<T> outOfBoundsFactory) {
        this(input, newSize, CanvasImage.computeOffset(input, newSize), outOfBoundsFactory);
    }

    private static int[] computeOffset(Image<?> input, int[] newSize) {
        int[] offset = new int[input.getNumDimensions()];
        for (int d = 0; d < input.getNumDimensions(); ++d) {
            offset[d] = (input.getDimension(d) - newSize[d]) / 2;
        }
        return offset;
    }

    public CanvasImage(Image<T> input, int[] newSize) {
        this(input, newSize, null);
    }

    @Override
    public boolean process() {
        long startTime = System.currentTimeMillis();
        LocalizableCursor<T> outputCursor = this.output.createLocalizableCursor();
        LocalizableByDimCursor<T> inputCursor = this.outOfBoundsFactory == null ? this.input.createLocalizableByDimCursor() : this.input.createLocalizableByDimCursor(this.outOfBoundsFactory);
        while (outputCursor.hasNext()) {
            outputCursor.fwd();
            outputCursor.getPosition(this.location);
            for (int d = 0; d < this.numDimensions; ++d) {
                int n = d;
                this.location[n] = this.location[n] + this.offset[d];
            }
            inputCursor.moveTo(this.location);
            outputCursor.getType().set(inputCursor.getType());
        }
        outputCursor.close();
        inputCursor.close();
        this.processingTime = System.currentTimeMillis() - startTime;
        return true;
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public Image<T> getResult() {
        return this.output;
    }

    @Override
    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.input == null) {
            this.errorMessage = "Input image is null";
            return false;
        }
        if (this.output == null) {
            this.errorMessage = "Output image is null, maybe not enough memory";
            return false;
        }
        return true;
    }

    @Override
    public String getErrorMessage() {
        if (this.errorMessage.length() > 0) {
            this.errorMessage = "CanvasImage(): " + this.errorMessage;
        }
        return this.errorMessage;
    }
}

