/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.math;

import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.Algorithm;
import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.MultiThreaded;
import mpicbg.imglib.cursor.Cursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.multithreading.Chunk;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.util.Util;

public class ComputeMinMax<T extends Type<T> & Comparable<T>>
implements Algorithm,
MultiThreaded,
Benchmark {
    final Image<T> image;
    final T min;
    final T max;
    String errorMessage = "";
    int numThreads;
    long processingTime;

    public ComputeMinMax(Image<T> image) {
        this.setNumThreads();
        this.image = image;
        this.min = image.createType();
        this.max = image.createType();
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    @Override
    public boolean process() {
        long startTime = System.currentTimeMillis();
        long imageSize = this.image.getNumPixels();
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads(this.getNumThreads());
        final Vector<Chunk> threadChunks = SimpleMultiThreading.divideIntoChunks(imageSize, this.numThreads);
        final Vector<T> minValues = new Vector<T>();
        final Vector<T> maxValues = new Vector<T>();
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            minValues.add(this.image.createType());
            maxValues.add(this.image.createType());
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    Chunk myChunk = (Chunk)threadChunks.get(myNumber);
                    ComputeMinMax.this.compute(myChunk.getStartPosition(), myChunk.getLoopSize(), (Type)minValues.get(myNumber), (Type)maxValues.get(myNumber));
                }
            });
        }
        SimpleMultiThreading.startAndJoin(threads);
        this.min.set((Type)((Type)minValues.get(0)));
        this.max.set((Type)((Type)maxValues.get(0)));
        for (int i = 0; i < threads.length; ++i) {
            Type value = (Type)minValues.get(i);
            if (Util.min(this.min, value) == value) {
                this.min.set((Type)value);
            }
            if (Util.max(this.max, value = (Type)maxValues.get(i)) != value) continue;
            this.max.set((Type)value);
        }
        this.processingTime = System.currentTimeMillis() - startTime;
        return true;
    }

    protected void compute(long startPos, long loopSize, T min, T max) {
        Cursor<T> cursor = this.image.createCursor();
        cursor.fwd();
        min.set(cursor.getType());
        max.set(cursor.getType());
        cursor.reset();
        cursor.fwd(startPos);
        for (long j = 0L; j < loopSize; ++j) {
            cursor.fwd();
            T value = cursor.getType();
            if (Util.min(min, value) == value) {
                min.set(value);
            }
            if (Util.max(max, value) != value) continue;
            max.set(value);
        }
        cursor.close();
    }

    @Override
    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.image == null) {
            this.errorMessage = "ScaleSpace: [Image<A> img] is null.";
            return false;
        }
        return true;
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    @Override
    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    @Override
    public int getNumThreads() {
        return this.numThreads;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }
}

