/*
 * Decompiled with CFR 0.152.
 */
package video;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileSaver;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Arrays;

public class VideoStack {
    static final int DIGITS = 8;
    static final String LAST = "99999999";
    private String dir;
    private String basename;
    private String ending;
    private int w_org;
    private int h_org;
    private int w_prev;
    private int h_prev;
    private int d;
    private ImageStack preview;
    DecimalFormat df = new DecimalFormat("00000000");

    public void open(String dir, String basename, String ending) {
        this.basename = basename;
        this.ending = ending;
        this.dir = dir;
        File prev = new File(dir, "Preview.tif");
        if (prev.exists()) {
            System.out.println("Loading existing preview stack");
            this.preview = IJ.openImage((String)(dir + "/Preview.tif")).getStack();
            this.w_prev = this.preview.getWidth();
            this.h_prev = this.preview.getHeight();
            String one = this.preview.getSliceLabel(1);
            ImagePlus tmp = IJ.openImage((String)(dir + "/" + one));
            this.w_org = tmp.getWidth();
            this.h_org = tmp.getHeight();
            this.d = this.preview.getSize();
            return;
        }
        Object[] files = new File(dir).list();
        if (files.length == 0) {
            return;
        }
        Arrays.sort(files);
        this.d = files.length;
        System.out.println("Loading " + this.d + " files");
        for (int i = 0; i < this.d; ++i) {
            if (!((String)files[i]).startsWith(basename) || !((String)files[i]).endsWith(ending)) continue;
            System.out.println("opening " + (String)files[i]);
            ImageProcessor ip = IJ.openImage((String)(dir + "/" + (String)files[i])).getProcessor();
            if (this.preview != null) {
                ip = ip.resize(64).convertToByte(true);
                this.preview.addSlice((String)files[i], ip);
                continue;
            }
            this.w_org = ip.getWidth();
            this.h_org = ip.getHeight();
            ip = ip.resize(64).convertToByte(true);
            this.w_prev = ip.getWidth();
            this.h_prev = ip.getHeight();
            this.preview = new ImageStack(this.w_prev, this.h_prev);
            this.preview.addSlice((String)files[i], ip);
        }
        this.d = this.preview.getSize();
    }

    public ImageProcessor getProcessor(int index) {
        return IJ.openImage((String)(this.dir + "/" + this.preview.getSliceLabel(index))).getProcessor();
    }

    public void setSlice(int index, ImageProcessor ip) {
        String name = this.preview.getSliceLabel(index);
        ImagePlus imp = new ImagePlus(name, ip);
        new FileSaver(imp).saveAsPng(this.dir + "/" + name);
        ip = ip.resize(this.w_prev).convertToByte(true);
        this.preview.setPixels(ip.getPixels(), index);
    }

    public boolean addSlice(int index, ImageProcessor ip) {
        int b;
        if (ip == null) {
            ip = new ColorProcessor(this.w_org, this.h_org);
        }
        String name_b = this.preview.getSliceLabel(index);
        name_b = name_b.substring(this.basename.length(), this.basename.length() + 8);
        String name_a = this.preview.getSliceLabel(index + 1);
        name_a = name_a.substring(this.basename.length(), this.basename.length() + 8);
        int dig = 8;
        String name = "";
        int a = Integer.parseInt(name_a.substring(0, dig));
        if (a > (b = Integer.parseInt(name_b.substring(0, dig))) + 1) {
            name = this.df.format(b + 1);
        }
        if (name == null || name.equals("")) {
            try {
                if (!this.rebaseImages()) {
                    return false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            return this.addSlice(index, ip);
        }
        while (name.length() < 8) {
            name = name + '0';
        }
        name = this.basename + name + "." + this.ending;
        ImagePlus imp = new ImagePlus(name, ip);
        new FileSaver(imp).saveAsPng(this.dir + "/" + name);
        ip = ip.resize(this.w_prev).convertToByte(true);
        this.preview.addSlice(name, ip, index);
        return true;
    }

    public boolean rebaseImages() {
        System.out.println("rebase images");
        int N = this.preview.getSize();
        File tmpdir = new File(this.dir, "tmp");
        if (tmpdir.exists()) {
            IJ.error((String)"Cannot rebase images, since temporary\ndirectory already exists");
            return false;
        }
        if (!tmpdir.mkdir()) {
            IJ.error((String)"Cannot create temporary");
            return false;
        }
        for (int z = 0; z < N; ++z) {
            String name = this.preview.getSliceLabel(z + 1);
            new FileSaver(IJ.openImage((String)(this.dir + "/" + name))).saveAsPng(tmpdir.getAbsolutePath() + "/" + name);
            new File(this.dir, name).delete();
        }
        int num = 1;
        int digitsNeeded = 1;
        String format = "0";
        while (N / num >= 10) {
            ++digitsNeeded;
            format = format + '0';
            num *= 10;
        }
        DecimalFormat df = new DecimalFormat(format);
        String app = "";
        for (int i = 0; i < 8 - digitsNeeded; ++i) {
            app = app + '0';
        }
        for (int z = 0; z < N; ++z) {
            String oldname = this.preview.getSliceLabel(z + 1);
            String newname = this.basename + df.format(z + 1) + app + "." + this.ending;
            ImagePlus imp = IJ.openImage((String)(tmpdir.getAbsolutePath() + "/" + oldname));
            new FileSaver(imp).saveAsPng(this.dir + "/" + newname);
            this.preview.setSliceLabel(newname, z + 1);
        }
        File[] tmpfiles = tmpdir.listFiles();
        for (int i = 0; i < tmpfiles.length; ++i) {
            tmpfiles[i].delete();
        }
        tmpdir.delete();
        System.out.println("rebased");
        return true;
    }

    public void deleteSlice(int index) {
        File f = new File(this.dir + "/" + this.preview.getSliceLabel(index));
        f.delete();
        this.preview.deleteSlice(index);
    }

    public ImageStack getPreview() {
        return this.preview;
    }

    public int getPreviewWidth() {
        return this.w_prev;
    }

    public int getPreviewHeight() {
        return this.h_prev;
    }

    public int getWidth() {
        return this.w_org;
    }

    public int getHeight() {
        return this.h_org;
    }

    public String getDir() {
        return this.dir;
    }
}

