/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;

public class IntSlider
extends Panel
implements AdjustmentListener,
ActionListener {
    private Scrollbar bar;
    private IntField field;
    private int value;
    private int minValue;
    private int maxValue;
    private String actionCommand;
    transient ActionListener actionListener;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int NORTH = 1;
    public static final int SOUTH = 2;
    public static final int EAST = 3;
    public static final int WEST = 4;

    public IntSlider(int minValue, int maxValue) {
        super(new BorderLayout(1, 1));
        if (maxValue < minValue) {
            throw new IllegalArgumentException("maximum smaller than minimum");
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.value = minValue;
        this.bar = new Scrollbar(0, minValue, 1, minValue, maxValue + 1);
        this.bar.addAdjustmentListener(this);
        this.add(this.bar, "Center", 0);
        this.field = new IntField(minValue, minValue, maxValue);
        this.field.addActionListener(this);
        this.add(this.field, "East", 1);
    }

    public IntSlider(int value, int minValue, int maxValue, int orientation, int visible, int textPosition) {
        this(value, minValue, maxValue, orientation, visible, textPosition, "IntSlider value changed");
    }

    public IntSlider(int value, int minValue, int maxValue, int orientation, int visible, int textPosition, String actionCommand) {
        super(new BorderLayout(1, 1));
        if (value < minValue || value > maxValue) {
            throw new IllegalArgumentException("value, minValue and maxValue inconsistent");
        }
        if (visible < 1 || visible > maxValue - minValue) {
            throw new IllegalArgumentException("block Increment out of range");
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.value = value;
        this.actionCommand = actionCommand;
        this.bar = new Scrollbar(orientation, value, visible, minValue, maxValue + visible);
        this.bar.addAdjustmentListener(this);
        this.add(this.bar, "Center", 0);
        this.field = new IntField(value, minValue, maxValue);
        this.field.addActionListener(this);
        switch (textPosition) {
            case 1: {
                this.add(this.field, "North", 1);
                break;
            }
            case 2: {
                this.add(this.field, "South", 1);
                break;
            }
            case 3: {
                this.add(this.field, "East", 1);
                break;
            }
            case 4: {
                this.add(this.field, "West", 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown textPosition");
            }
        }
    }

    public void setValue(int newValue) {
        this.setValue(newValue, false);
    }

    public void setValue(int newValue, boolean sendEvent) {
        if (newValue >= this.minValue && newValue <= this.maxValue) {
            if (newValue != this.value) {
                this.value = newValue;
                this.bar.setValue(this.value);
                this.field.setValue(this.value);
                if (sendEvent) {
                    this.processEvent(new ActionEvent(this, 1001, this.actionCommand));
                }
            }
        } else {
            throw new IllegalArgumentException("value out of range: " + newValue);
        }
    }

    public int getValue() {
        return this.value;
    }

    public void setActionCommand(String newCommand) {
        this.actionCommand = newCommand;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.field) {
            int tempval = this.field.getValue();
            if (tempval != this.value) {
                this.value = tempval;
                this.bar.setValue(this.value);
                this.processEvent(new ActionEvent(this, 1001, this.actionCommand));
            } else {
                this.field.setValue(this.value);
            }
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (e.getSource() == this.bar && e.getValue() != this.value) {
            this.value = this.bar.getValue();
            this.field.setValue(this.value);
            this.processEvent(new ActionEvent(this, 1001, this.actionCommand));
        }
    }

    public void setColumns(int columns) {
        this.field.setColumns(columns);
    }

    public int getColumns() {
        return this.field.getColumns();
    }

    public synchronized void addActionListener(ActionListener l) {
        if (l == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (l == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)e);
            return;
        }
        super.processEvent(e);
    }

    protected void processActionEvent(ActionEvent e) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(e);
        }
    }
}

