/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import org.jhotdraw.app.action.edit.DuplicateAction;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.draw.action.BringToFrontAction;
import org.jhotdraw.draw.action.ButtonFactory;
import org.jhotdraw.draw.action.GroupAction;
import org.jhotdraw.draw.action.SendToBackAction;
import org.jhotdraw.draw.action.UngroupAction;
import org.jhotdraw.draw.tool.CreationTool;
import org.jhotdraw.draw.tool.TextAreaCreationTool;
import org.jhotdraw.draw.tool.TextCreationTool;
import org.jhotdraw.gui.plaf.palette.PaletteButtonUI;
import org.jhotdraw.samples.svg.PathTool;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.SVGCreateFromFileTool;
import org.jhotdraw.samples.svg.action.CombineAction;
import org.jhotdraw.samples.svg.action.SplitAction;
import org.jhotdraw.samples.svg.figures.SVGBezierFigure;
import org.jhotdraw.samples.svg.figures.SVGEllipseFigure;
import org.jhotdraw.samples.svg.figures.SVGGroupFigure;
import org.jhotdraw.samples.svg.figures.SVGImageFigure;
import org.jhotdraw.samples.svg.figures.SVGPathFigure;
import org.jhotdraw.samples.svg.figures.SVGRectFigure;
import org.jhotdraw.samples.svg.figures.SVGTextAreaFigure;
import org.jhotdraw.samples.svg.figures.SVGTextFigure;
import org.jhotdraw.samples.svg.gui.AbstractToolBar;
import org.jhotdraw.util.ResourceBundleUtil;

public class ToolsToolBar
extends AbstractToolBar {
    public ToolsToolBar() {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
        this.setName(labels.getString("tools.toolbar"));
    }

    @Override
    protected JComponent createDisclosedComponent(int state) {
        JPanel p = null;
        switch (state) {
            case 1: {
                p = new JPanel();
                p.setOpaque(false);
                p.setBorder(new EmptyBorder(5, 5, 5, 8));
                if (this.editor == null) break;
                ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");
                GridBagLayout layout = new GridBagLayout();
                p.setLayout(layout);
                JToggleButton btn = ButtonFactory.addSelectionToolTo(this, this.editor, ButtonFactory.createDrawingActions(this.editor, this.disposables), this.createSelectionActions(this.editor));
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                btn.addMouseListener(new SelectionToolButtonHandler(this.editor));
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 0;
                p.add((Component)btn, gbc);
                labels.configureToolBarButton(btn, "selectionTool");
                HashMap<AttributeKey, Object> attributes = new HashMap<AttributeKey, Object>();
                CreationTool creationTool = new CreationTool(new SVGRectFigure(), attributes);
                btn = ButtonFactory.addToolTo(this, this.editor, creationTool, "createRectangle", labels);
                creationTool.setToolDoneAfterCreation(false);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 1;
                gbc.insets = new Insets(3, 0, 0, 0);
                p.add((Component)btn, gbc);
                creationTool = new CreationTool(new SVGEllipseFigure(), attributes);
                btn = ButtonFactory.addToolTo(this, this.editor, creationTool, "createEllipse", labels);
                creationTool.setToolDoneAfterCreation(false);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 1;
                gbc.insets = new Insets(3, 3, 0, 0);
                p.add((Component)btn, gbc);
                PathTool pathTool = new PathTool(new SVGPathFigure(), new SVGBezierFigure(true), attributes);
                btn = ButtonFactory.addToolTo(this, this.editor, pathTool, "createPolygon", labels);
                pathTool.setToolDoneAfterCreation(false);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                gbc = new GridBagConstraints();
                gbc.gridx = 2;
                gbc.gridy = 1;
                gbc.insets = new Insets(3, 3, 0, 0);
                p.add((Component)btn, gbc);
                attributes = new HashMap();
                attributes.put(AttributeKeys.FILL_COLOR, null);
                attributes.put(SVGAttributeKeys.PATH_CLOSED, false);
                creationTool = new CreationTool(new SVGPathFigure(), attributes);
                btn = ButtonFactory.addToolTo(this, this.editor, creationTool, "createLine", labels);
                creationTool.setToolDoneAfterCreation(false);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 0;
                gbc.insets = new Insets(0, 3, 0, 0);
                p.add((Component)btn, gbc);
                pathTool = new PathTool(new SVGPathFigure(), new SVGBezierFigure(false), attributes);
                btn = ButtonFactory.addToolTo(this, this.editor, pathTool, "createScribble", labels);
                pathTool.setToolDoneAfterCreation(false);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                gbc = new GridBagConstraints();
                gbc.gridx = 2;
                gbc.gridy = 0;
                gbc.insets = new Insets(0, 3, 0, 0);
                p.add((Component)btn, gbc);
                attributes = new HashMap();
                attributes.put(AttributeKeys.FILL_COLOR, Color.black);
                attributes.put(AttributeKeys.STROKE_COLOR, null);
                TextCreationTool textTool = new TextCreationTool(new SVGTextFigure(), attributes);
                btn = ButtonFactory.addToolTo(this, this.editor, textTool, "createText", labels);
                textTool.setToolDoneAfterCreation(true);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = 2;
                gbc.insets = new Insets(3, 0, 0, 0);
                p.add((Component)btn, gbc);
                TextAreaCreationTool textAreaTool = new TextAreaCreationTool(new SVGTextAreaFigure(), attributes);
                textAreaTool.setRubberbandColor(Color.BLACK);
                textAreaTool.setToolDoneAfterCreation(true);
                btn = ButtonFactory.addToolTo(this, this.editor, textAreaTool, "createTextArea", labels);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 2;
                gbc.insets = new Insets(3, 3, 0, 0);
                p.add((Component)btn, gbc);
                attributes = new HashMap();
                attributes.put(AttributeKeys.FILL_COLOR, null);
                attributes.put(AttributeKeys.STROKE_COLOR, null);
                SVGCreateFromFileTool imageTool = new SVGCreateFromFileTool(new SVGImageFigure(), new SVGGroupFigure(), attributes);
                btn = ButtonFactory.addToolTo(this, this.editor, imageTool, "createImage", labels);
                imageTool.setToolDoneAfterCreation(true);
                imageTool.setUseFileDialog(true);
                btn.setUI((PaletteButtonUI)PaletteButtonUI.createUI(btn));
                gbc = new GridBagConstraints();
                gbc.gridx = 2;
                gbc.gridy = 2;
                gbc.insets = new Insets(3, 3, 0, 0);
                p.add((Component)btn, gbc);
            }
        }
        return p;
    }

    public Collection<Action> createSelectionActions(DrawingEditor editor) {
        LinkedList<Action> list = new LinkedList<Action>();
        list.add(new DuplicateAction());
        list.add(null);
        AbstractSelectedAction a = new GroupAction(editor, new SVGGroupFigure());
        list.add(a);
        this.disposables.add(a);
        a = new UngroupAction(editor, new SVGGroupFigure());
        list.add(a);
        this.disposables.add(a);
        a = new CombineAction(editor);
        list.add(a);
        this.disposables.add(a);
        a = new SplitAction(editor);
        list.add(a);
        this.disposables.add(a);
        list.add(null);
        a = new BringToFrontAction(editor);
        list.add(a);
        this.disposables.add(a);
        a = new SendToBackAction(editor);
        list.add(a);
        this.disposables.add(a);
        return list;
    }

    @Override
    protected String getID() {
        return "tools";
    }

    @Override
    protected int getDefaultDisclosureState() {
        return 1;
    }

    private void initComponents() {
        this.setOpaque(false);
    }

    private static class SelectionToolButtonHandler
    extends MouseAdapter {
        private DrawingEditor editor;
        private boolean wasSelectedOnPressed = false;

        public SelectionToolButtonHandler(DrawingEditor editor) {
            this.editor = editor;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            DrawingView view;
            if (this.wasSelectedOnPressed && (view = this.editor.getActiveView()) != null) {
                view.setHandleDetailLevel(view.getHandleDetailLevel() + 1);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.wasSelectedOnPressed = ((AbstractButton)e.getSource()).isSelected();
        }
    }
}

