/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.utils.Utils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class LayerPanel
extends JPanel
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private final JLabel title;
    protected final JSlider slider = new JSlider(0, 0, 100, 0);
    private Color color = Color.white;
    private float alpha = 0.0f;
    private final Display display;
    protected final Layer layer;

    public LayerPanel(final Display display, Layer layer) {
        this.display = display;
        this.layer = layer;
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ce) {
                float a = (float)LayerPanel.this.slider.getValue() / 100.0f;
                LayerPanel.this.setAlpha(a);
                display.storeLayerAlpha(LayerPanel.this, a);
                display.getCanvas().repaint(true);
            }
        });
        this.title = new JLabel(this.makeTitle());
        this.title.addMouseListener(this);
        GridBagLayout gb = new GridBagLayout();
        this.setLayout(gb);
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 2;
        c.weighty = 0.0;
        gb.setConstraints(this.title, c);
        this.add(this.title);
        JPanel empty = new JPanel();
        ++c.gridy;
        c.fill = 1;
        c.weighty = 1.0;
        gb.setConstraints(empty, c);
        ++c.gridy;
        c.weighty = 0.0;
        c.fill = 2;
        gb.setConstraints(this.slider, c);
        this.add(this.slider);
        this.setMinimumSize(new Dimension(0, 52));
        this.setPreferredSize(new Dimension(250, 52));
        this.addMouseListener(this);
        this.setBackground(this.color);
        this.setBorder(BorderFactory.createLineBorder(Color.black));
    }

    private final String makeTitle() {
        return "" + (this.layer.getParent().indexOf(this.layer) + 1) + ':' + ' ' + this.layer.getTitle();
    }

    public final void setColor(Color color) {
        this.color = color;
        this.setBackground(color);
        this.slider.setBackground(color);
        if (Color.white == color) {
            this.title.setForeground(Color.black);
        } else {
            this.title.setForeground(Color.white);
        }
        this.repaint();
    }

    public final Color getColor() {
        return this.color;
    }

    public final void setAlpha(float alpha) {
        if (alpha < 0.0f || alpha > 1.0f) {
            return;
        }
        this.alpha = alpha;
        this.slider.setValue((int)(alpha * 100.0f));
    }

    public final float getAlpha() {
        return this.alpha;
    }

    @Override
    public final void paint(Graphics g) {
        this.title.setText(this.makeTitle());
        if (this.display.getLayer() == this.layer) {
            this.setBackground(Color.green);
            this.slider.setBackground(Color.green);
        } else {
            this.setBackground(this.color);
            this.slider.setBackground(this.color);
        }
        super.paint(g);
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.doMousePressed(me);
    }

    private void doMousePressed(MouseEvent me) {
        if (Utils.isPopupTrigger(me)) {
            JPopupMenu popup = new JPopupMenu();
            JMenuItem item = new JMenuItem("Set as red channel");
            popup.add(item);
            if (Color.red == this.color) {
                item.setEnabled(false);
            } else {
                item.addActionListener(new ColorActionListener(Color.red));
            }
            item = new JMenuItem("Set as blue channel");
            popup.add(item);
            if (Color.blue == this.color) {
                item.setEnabled(false);
            } else {
                item.addActionListener(new ColorActionListener(Color.blue));
            }
            item = new JMenuItem("Reset");
            popup.add(item);
            if (Color.white == this.color) {
                item.setEnabled(false);
            } else {
                item.addActionListener(new ColorActionListener(Color.white));
            }
            JCheckBoxMenuItem citem = new JCheckBoxMenuItem("Invert");
            popup.add(citem);
            citem.setState(this.display.invert_colors);
            citem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    ((LayerPanel)LayerPanel.this).display.invert_colors = !((LayerPanel)LayerPanel.this).display.invert_colors;
                    LayerPanel.this.display.getCanvas().repaint(true);
                }
            });
            JMenu transp_menu = new JMenu("Overlay items");
            popup.add(transp_menu);
            final JCheckBoxMenuItem cbI = new JCheckBoxMenuItem("Images", this.display.transp_overlay_images);
            final JCheckBoxMenuItem cbA = new JCheckBoxMenuItem("Areas", this.display.transp_overlay_areas);
            final JCheckBoxMenuItem cbL = new JCheckBoxMenuItem("Text labels", this.display.transp_overlay_text_labels);
            ActionListener lis = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Object src = ae.getSource();
                    if (src == cbI) {
                        LayerPanel.this.display.setTranspOverlayImages(cbI.getState());
                    } else if (src == cbA) {
                        LayerPanel.this.display.setTranspOverlayAreas(cbA.getState());
                    } else if (src == cbL) {
                        LayerPanel.this.display.setTranspOverlayTextLabels(cbL.getState());
                    }
                }
            };
            for (JCheckBoxMenuItem rb : new JCheckBoxMenuItem[]{cbI, cbA, cbL}) {
                transp_menu.add(rb);
                rb.addActionListener(lis);
            }
            popup.addSeparator();
            JMenu composites = new JMenu("Composite mode");
            ButtonGroup group = new ButtonGroup();
            byte compositeMode = this.display.getLayerCompositeMode(this.layer);
            for (int i = 0; i < Displayable.compositeModes.length; ++i) {
                JRadioButton rb = new JRadioButton(Displayable.compositeModes[i], compositeMode == i);
                rb.setActionCommand(Displayable.compositeModes[i]);
                final byte cm = (byte)i;
                rb.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        LayerPanel.this.display.setLayerCompositeMode(LayerPanel.this.layer, cm);
                    }
                });
                composites.add(rb);
                group.add(rb);
            }
            popup.add(composites);
            popup.addSeparator();
            item = new JMenuItem("Reset all layer coloring");
            popup.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    LayerPanel.this.display.resetLayerColors();
                }
            });
            item = new JMenuItem("Reset all layer alphas");
            popup.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    LayerPanel.this.display.resetLayerAlphas();
                }
            });
            item = new JMenuItem("Reset all layer composites");
            popup.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    LayerPanel.this.display.resetLayerComposites();
                }
            });
            popup.show(this, me.getX(), me.getY());
            me.consume();
            return;
        }
        int mod = me.getModifiers();
        Utils.log2("mouse pressed : " + mod);
        if ((0 != (mod & 8) || 0 != (mod & 1)) && this.display.getLayer() != this.layer) {
            if (0 != (mod & 8)) {
                if (this.color == Color.blue) {
                    this.setColor(Color.white);
                } else {
                    this.setColor(Color.blue);
                }
                this.display.setColorChannel(this.layer, this.color);
                me.consume();
            } else if (0 != (mod & 1)) {
                if (this.color == Color.red) {
                    this.setColor(Color.white);
                } else {
                    this.setColor(Color.red);
                }
                this.display.setColorChannel(this.layer, this.color);
                me.consume();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public final String toString() {
        return "Layer panel for " + this.layer.getTitle();
    }

    private class ColorActionListener
    implements ActionListener {
        final Color c;

        ColorActionListener(Color c) {
            this.c = c;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            LayerPanel.this.setColor(this.c);
            LayerPanel.this.display.setColorChannel(LayerPanel.this.layer, this.c);
        }
    }
}

