/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.utils;

import ini.trakem2.Project;
import ini.trakem2.persistence.FSLoader;
import ini.trakem2.persistence.Loader;
import ini.trakem2.persistence.XMLOptions;
import ini.trakem2.utils.Utils;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class RedPhone {
    public int port = 29391;
    ServerSocket server = null;
    final Set<Socket> openConnections = Collections.synchronizedSet(new HashSet());
    private ThreadGroup group = new ThreadGroup("RedPhone");
    private final Object WRITE = new Object();
    private static final Hashtable<Project, ScheduledExecutorService> periodic_flushers = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void quit() {
        if (null != this.server) {
            try {
                this.group.interrupt();
                Object object = this.WRITE;
                synchronized (object) {
                    this.server.close();
                    for (Socket s : this.openConnections.toArray(new Socket[0])) {
                        s.close();
                    }
                }
            }
            catch (IOException e) {
                System.out.println("Error closing RedPhone socket:");
                e.printStackTrace();
            }
        }
    }

    public synchronized void start() {
        while (true) {
            try {
                this.server = new ServerSocket(this.port);
                this.server.setReuseAddress(true);
            }
            catch (IOException e) {
                ++this.port;
                if (this.port <= 31000) continue;
                System.out.println("Red phone not running: no port available");
                return;
            }
            break;
        }
        System.out.println("Red phone at port " + this.port);
        new Thread(this.group, "RedPhone-server"){
            {
                this.setPriority(5);
            }

            @Override
            public void run() {
                HashMap<String, Action> cmds = new HashMap<String, Action>();
                cmds.put("save", new Save());
                cmds.put("saveas", new SaveAs());
                cmds.put("stream", new Stream());
                cmds.put("flushcache", new FlushCache());
                cmds.put("flushcacheevery1minute", new StartPeriodicFlushCache(1));
                cmds.put("flushcacheevery2minutes", new StartPeriodicFlushCache(2));
                cmds.put("flushcacheevery5minutes", new StartPeriodicFlushCache(5));
                cmds.put("flushcacheevery10minutes", new StartPeriodicFlushCache(10));
                cmds.put("stopflushcache", new StopPeriodicFlushCache());
                cmds.put("heap0.2", new SetHeapFraction(0.1f));
                cmds.put("heap0.2", new SetHeapFraction(0.2f));
                cmds.put("heap0.3", new SetHeapFraction(0.3f));
                cmds.put("heap0.4", new SetHeapFraction(0.4f));
                cmds.put("help", new Help(cmds));
                cmds.put("?", new Help(cmds));
                while (!this.isInterrupted()) {
                    Socket s = null;
                    try {
                        s = RedPhone.this.server.accept();
                        System.out.println("Connected.");
                        new Connection(s, cmds).start();
                    }
                    catch (IOException e) {
                        if (!this.isInterrupted()) {
                            e.printStackTrace();
                        }
                        System.out.println("RedPhone hang up!");
                    }
                }
            }
        }.start();
    }

    private String handlePath(String path) {
        if (null == path) {
            String dir = System.getProperty("user.dir");
            int count = 1;
            do {
                path = dir + "/trakem2-recovered-" + count + ".xml";
                ++count;
            } while (new File(path).exists());
            return path;
        }
        int count = 1;
        String p = path;
        while (new File(p).exists()) {
            p = path + "-" + count + ".xml";
            ++count;
        }
        return p;
    }

    private final class IO {
        private final BufferedReader in;
        private final Writer out;

        IO(Socket s) throws IOException {
            this.in = new BufferedReader(new InputStreamReader(s.getInputStream()));
            this.out = new OutputStreamWriter(new BufferedOutputStream(s.getOutputStream()));
        }

        final String readOneLine() throws IOException {
            return this.in.readLine();
        }

        final void writeLine(String answer) throws IOException {
            this.out.append(answer);
            this.out.append('\n');
            this.out.flush();
        }
    }

    private class Help
    extends Action {
        private final HashMap<String, Action> cmds;

        protected Help(HashMap<String, Action> cmds) {
            this.cmds = cmds;
        }

        @Override
        protected void exec(Project p, FSLoader fl, IO io, int count) throws IOException {
            io.writeLine("### START HELP ###");
            io.writeLine("Available commands:");
            ArrayList<String> commands = new ArrayList<String>(this.cmds.keySet());
            Collections.sort(commands);
            for (String command : commands) {
                io.writeLine("  " + command);
            }
            io.writeLine("  quit");
            io.writeLine("### END HELP ###");
        }
    }

    private class SetHeapFraction
    extends Action {
        private final float heap_fraction;

        protected SetHeapFraction(float heap_fraction) {
            this.heap_fraction = heap_fraction;
        }

        @Override
        protected void exec(Project p, FSLoader fl, IO io, int count) throws IOException {
            Loader.setHeapFraction(this.heap_fraction);
            io.writeLine("Set Loader.heap_fraction to " + this.heap_fraction);
        }
    }

    private class StopPeriodicFlushCache
    extends Action {
        private StopPeriodicFlushCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void exec(Project p, FSLoader fl, IO io, int count) throws IOException {
            Hashtable hashtable = periodic_flushers;
            synchronized (hashtable) {
                ScheduledExecutorService ses = (ScheduledExecutorService)periodic_flushers.remove(p);
                if (null == ses) {
                    io.writeLine("No periodic flushing running for project: " + p.getTitle());
                } else {
                    ses.shutdownNow();
                    io.writeLine("Stopped periodic flushing for project: " + p.getTitle());
                }
            }
        }
    }

    private class StartPeriodicFlushCache
    extends Action {
        private final int n_minutes;

        protected StartPeriodicFlushCache(int n_minutes) {
            this.n_minutes = n_minutes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void exec(final Project p, FSLoader fl, IO io, int count) throws IOException {
            Hashtable hashtable = periodic_flushers;
            synchronized (hashtable) {
                if (periodic_flushers.containsKey(p)) {
                    io.writeLine("Periodic flushing already running. Stop it first to relaunch it.");
                } else {
                    ScheduledExecutorService ses = Executors.newSingleThreadScheduledExecutor();
                    ses.scheduleWithFixedDelay(new Runnable(){

                        @Override
                        public void run() {
                            p.getLoader().releaseAll();
                            System.out.println(Utils.now() + " :: Flushed cache for project: " + p.getTitle());
                        }
                    }, 0L, this.n_minutes, TimeUnit.MINUTES);
                    periodic_flushers.put(p, ses);
                    io.writeLine("Started periodic flushing every " + this.n_minutes + " minutes for project: " + p.getTitle());
                }
            }
        }
    }

    private class FlushCache
    extends Action {
        private FlushCache() {
        }

        @Override
        protected void exec(Project p, FSLoader fl, IO io, int count) throws IOException {
            io.writeLine("Flushing cache...");
            p.getLoader().releaseAll();
            io.writeLine("Done flushing cache.");
        }
    }

    private class Stream
    extends Action {
        private Stream() {
        }

        @Override
        protected void exec(Project p, FSLoader fl, IO io, int count) throws IOException {
            io.writeLine("Streaming: " + fl.getProjectXMLPath());
            try {
                XMLOptions options = new XMLOptions();
                options.export_images = false;
                options.patches_dir = null;
                options.include_coordinate_transform = true;
                fl.writeXMLTo(p, io.out, options);
            }
            catch (Exception e) {
                e.printStackTrace();
                io.writeLine("Could not stream project " + fl.getProjectXMLPath());
            }
        }
    }

    private class SaveAs
    extends Action {
        private SaveAs() {
        }

        @Override
        protected void exec(Project p, FSLoader fl, IO io, int count) throws IOException {
            String path = RedPhone.this.handlePath(fl.getProjectXMLPath());
            io.writeLine("Saving...");
            p.saveAs(path, false);
            String answer = "Saved project[" + count + "] to: " + path;
            System.out.println(answer);
            io.writeLine(answer);
        }
    }

    private class Save
    extends Action {
        private Save() {
        }

        @Override
        protected void exec(Project p, FSLoader fl, IO io, int count) throws IOException {
            io.writeLine("Saving...");
            String path = fl.getProjectXMLPath();
            if (null == path) {
                new SaveAs().exec(p, fl, io, count);
                return;
            }
            io.writeLine("Saved: " + p.save());
        }
    }

    private abstract class Action {
        private Action() {
        }

        protected abstract void exec(Project var1, FSLoader var2, IO var3, int var4) throws IOException;

        public void execute(Project p, FSLoader fl, IO io, int count) {
            try {
                this.exec(p, fl, io, count);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                try {
                    ioe.printStackTrace(new PrintWriter(io.out));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    private class Connection
    extends Thread {
        private final Socket s;
        private final Map<String, Action> cmds;

        Connection(Socket s, Map<String, Action> cmds) {
            super(RedPhone.this.group, "RedPhone-connection");
            this.s = s;
            this.cmds = cmds;
            RedPhone.this.openConnections.add(s);
            this.setPriority(5);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                IO io = new IO(this.s);
                while (!this.isInterrupted()) {
                    String command = io.readOneLine();
                    System.out.println("RedPhone read command: " + command);
                    Object object = RedPhone.this.WRITE;
                    synchronized (object) {
                        block15: {
                            if (null == command || "quit".equals(command.trim().toLowerCase())) {
                                io.writeLine("OK bye!");
                                this.s.close();
                                RedPhone.this.openConnections.remove(this.s);
                                return;
                            }
                            if (0 == (command = command.trim().toLowerCase()).length()) {
                                continue;
                            }
                            Action action = this.cmds.get(command);
                            if (null == action) {
                                io.writeLine("Do not know command: " + command);
                                continue;
                            }
                            try {
                                int count = 0;
                                for (Project p : Project.getProjects()) {
                                    Loader l = p.getLoader();
                                    if (l instanceof FSLoader) {
                                        action.execute(p, (FSLoader)l, io, count);
                                    } else {
                                        String answer = "Could not save project[" + count + "]: not an XML-based project.";
                                        System.out.println(answer);
                                        io.writeLine(answer);
                                    }
                                    ++count;
                                }
                            }
                            catch (IOException ioe) {
                                ioe.printStackTrace();
                                if (this.s.isClosed()) break block15;
                                ioe.printStackTrace(new PrintWriter(this.s.getOutputStream()));
                            }
                        }
                    }
                }
                return;
            }
            catch (IOException ioe) {
                System.out.println("Red phone hang up!");
                if (this.isInterrupted()) return;
                ioe.printStackTrace();
                if (this.s.isClosed()) return;
                try {
                    ioe.printStackTrace(new PrintWriter(this.s.getOutputStream()));
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

