/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.trakem2.align;

import ij.IJ;
import ij.gui.GenericDialog;
import ij.process.ImageProcessor;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.Patch;
import ini.trakem2.display.Selection;
import ini.trakem2.persistence.FSLoader;
import ini.trakem2.persistence.Loader;
import ini.trakem2.utils.Filter;
import ini.trakem2.utils.Utils;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.ij.FeatureTransform;
import mpicbg.ij.SIFT;
import mpicbg.imagefeatures.Feature;
import mpicbg.imagefeatures.FloatArray2DSIFT;
import mpicbg.models.AbstractAffineModel2D;
import mpicbg.models.Affine2D;
import mpicbg.models.AffineModel2D;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.InterpolatedAffineModel2D;
import mpicbg.models.Model;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;
import mpicbg.models.SimilarityModel2D;
import mpicbg.models.Tile;
import mpicbg.models.Transforms;
import mpicbg.trakem2.align.AbstractAffineTile2D;
import mpicbg.trakem2.align.AffineTile2D;
import mpicbg.trakem2.align.GenericAffineTile2D;
import mpicbg.trakem2.align.RigidTile2D;
import mpicbg.trakem2.align.SimilarityTile2D;
import mpicbg.trakem2.align.TileConfiguration;
import mpicbg.trakem2.align.TranslationTile2D;
import mpicbg.trakem2.align.Util;
import mpicbg.trakem2.transform.HomographyModel2D;
import mpicbg.trakem2.transform.MovingLeastSquaresTransform2;
import mpicbg.trakem2.transform.RigidModel2D;
import mpicbg.trakem2.transform.TranslationModel2D;

public class Align {
    public static final Param param = new Param();
    public static final ParamOptimize paramOptimize = new ParamOptimize();

    public static final boolean findModel(Model<?> model, List<PointMatch> candidates, Collection<PointMatch> inliers, float maxEpsilon, float minInlierRatio, int minNumInliers, boolean rejectIdentity, float identityTolerance, boolean multipleHypotheses) {
        boolean again = false;
        int nHypotheses = 0;
        ArrayList<PointMatch> hypothesisCandidates = new ArrayList<PointMatch>(candidates);
        try {
            do {
                again = false;
                ArrayList inliers2 = new ArrayList();
                boolean modelFound = model.filterRansac(hypothesisCandidates, inliers2, 1000, (double)maxEpsilon, (double)minInlierRatio, minNumInliers, 3.0);
                if (!modelFound) continue;
                hypothesisCandidates.removeAll(inliers2);
                if (rejectIdentity) {
                    ArrayList points = new ArrayList();
                    PointMatch.sourcePoints(inliers2, points);
                    if (Transforms.isIdentity(model, points, (double)Align.param.identityTolerance)) {
                        Utils.log("Identity transform for " + inliers2.size() + " matches rejected.");
                        again = true;
                        continue;
                    }
                    ++nHypotheses;
                    inliers.addAll(inliers2);
                    again = multipleHypotheses;
                    continue;
                }
                ++nHypotheses;
                inliers.addAll(inliers2);
                again = multipleHypotheses;
            } while (again);
        }
        catch (NotEnoughDataPointsException inliers2) {
            // empty catch block
        }
        if (nHypotheses > 0 && multipleHypotheses) {
            try {
                model.fit(inliers);
                PointMatch.apply(inliers, model);
                model.setCost(PointMatch.meanDistance(inliers));
                Utils.log(nHypotheses + " hypotheses");
            }
            catch (NotEnoughDataPointsException inliers2) {
            }
            catch (IllDefinedDataPointsException e) {
                nHypotheses = 0;
            }
        }
        return nHypotheses > 0;
    }

    public static final boolean findModel(Model<?> model, List<PointMatch> candidates, Collection<PointMatch> inliers, float maxEpsilon, float minInlierRatio, int minNumInliers, boolean rejectIdentity, float identityTolerance) {
        return Align.findModel(model, candidates, inliers, maxEpsilon, minInlierRatio, minNumInliers, rejectIdentity, identityTolerance, false);
    }

    protected static final boolean serializeFeatures(Param p, AbstractAffineTile2D<?> t, Collection<Feature> f) {
        ArrayList<Feature> list = new ArrayList<Feature>();
        list.addAll(f);
        Patch patch = t.getPatch();
        Loader loader = patch.getProject().getLoader();
        Features fe = new Features(p.sift, list);
        return loader.serialize(fe, loader.getUNUIdFolder() + "features.ser/" + FSLoader.createIdPath(Long.toString(patch.getId()), "features", ".ser"));
    }

    protected static final Collection<Feature> deserializeFeatures(Param p, AbstractAffineTile2D<?> t) {
        Patch patch = t.getPatch();
        Loader loader = patch.getProject().getLoader();
        Object ob = loader.deserialize(loader.getUNUIdFolder() + "features.ser/" + FSLoader.createIdPath(Long.toString(patch.getId()), "features", ".ser"));
        if (null != ob) {
            try {
                Features fe = (Features)ob;
                if (p.sift.equals(fe.p) && null != fe.p) {
                    return fe.features;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected static final Collection<Feature> fetchFeatures(Param p, AbstractAffineTile2D<?> t) {
        Collection<Feature> features = Align.deserializeFeatures(p, t);
        if (features == null) {
            FloatArray2DSIFT sift = new FloatArray2DSIFT(p.sift);
            SIFT ijSIFT = new SIFT(sift);
            features = new ArrayList<Feature>();
            long s = System.currentTimeMillis();
            ijSIFT.extractFeatures((ImageProcessor)t.createMaskedByteImage(), features);
            Utils.log(features.size() + " features extracted in tile \"" + t.getPatch().getTitle() + "\" (took " + (System.currentTimeMillis() - s) + " ms).");
            if (!Align.serializeFeatures(p, t, features)) {
                Utils.log("Saving features failed for tile: " + t.getPatch());
            }
        }
        return features;
    }

    protected static final boolean serializePointMatches(Param p, AbstractAffineTile2D<?> t1, AbstractAffineTile2D<?> t2, Collection<PointMatch> m) {
        ArrayList<PointMatch> list = new ArrayList<PointMatch>();
        list.addAll(m);
        ArrayList<PointMatch> tsil = new ArrayList<PointMatch>();
        PointMatch.flip(m, tsil);
        Patch p1 = t1.getPatch();
        Patch p2 = t2.getPatch();
        Loader loader = p1.getProject().getLoader();
        return loader.serialize(new PointMatches(p, list), loader.getUNUIdFolder() + "pointmatches.ser/" + FSLoader.createIdPath(Long.toString(p1.getId()) + "_" + Long.toString(p2.getId()), "pointmatches", ".ser")) && loader.serialize(new PointMatches(p, tsil), loader.getUNUIdFolder() + "pointmatches.ser/" + FSLoader.createIdPath(Long.toString(p2.getId()) + "_" + Long.toString(p1.getId()), "pointmatches", ".ser"));
    }

    protected static final Collection<PointMatch> deserializePointMatches(Param p, AbstractAffineTile2D<?> t1, AbstractAffineTile2D<?> t2) {
        Patch p1 = t1.getPatch();
        Patch p2 = t2.getPatch();
        Loader loader = p1.getProject().getLoader();
        Object ob = loader.deserialize(loader.getUNUIdFolder() + "pointmatches.ser/" + FSLoader.createIdPath(Long.toString(p1.getId()) + "_" + Long.toString(p2.getId()), "pointmatches", ".ser"));
        if (null != ob) {
            try {
                PointMatches pm = (PointMatches)ob;
                if (p.equals(pm.p) && null != pm.p) {
                    return pm.pointMatches;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected static final Collection<PointMatch> fetchPointMatches(Param p, AbstractAffineTile2D<?> t1, AbstractAffineTile2D<?> t2) {
        Collection<PointMatch> pointMatches = Align.deserializePointMatches(p, t1, t2);
        if (pointMatches == null) {
            TranslationModel2D model;
            ArrayList<PointMatch> candidates = new ArrayList<PointMatch>();
            ArrayList<PointMatch> inliers = new ArrayList<PointMatch>();
            long s = System.currentTimeMillis();
            FeatureTransform.matchFeatures(Align.fetchFeatures(p, t1), Align.fetchFeatures(p, t2), candidates, (float)p.rod);
            switch (p.expectedModelIndex) {
                case 0: {
                    model = new TranslationModel2D();
                    break;
                }
                case 1: {
                    model = new RigidModel2D();
                    break;
                }
                case 2: {
                    model = new SimilarityModel2D();
                    break;
                }
                case 3: {
                    model = new AffineModel2D();
                    break;
                }
                default: {
                    return null;
                }
            }
            boolean modelFound = Align.findModel(model, candidates, inliers, p.maxEpsilon, p.minInlierRatio, p.minNumInliers, p.rejectIdentity, p.identityTolerance);
            if (modelFound) {
                Utils.log("Model found for tiles \"" + t1.getPatch() + "\" and \"" + t2.getPatch() + "\":\n  correspondences  " + inliers.size() + " of " + candidates.size() + "\n  average residual error  " + model.getCost() + " px\n  took " + (System.currentTimeMillis() - s) + " ms");
            } else {
                Utils.log("No model found for tiles \"" + t1.getPatch() + "\" and \"" + t2.getPatch() + "\":\n  correspondence candidates  " + candidates.size() + "\n  took " + (System.currentTimeMillis() - s) + " ms");
            }
            if (!Align.serializePointMatches(p, t1, t2, pointMatches)) {
                Utils.log("Saving point matches failed for tile \"" + t1.getPatch() + "\" and tile \"" + t2.getPatch() + "\"");
            }
        }
        return pointMatches;
    }

    public static final void alignTiles(ParamOptimize p, List<AbstractAffineTile2D<?>> tiles, List<AbstractAffineTile2D<?>> fixedTiles, boolean tilesAreInPlace, int numThreads) {
        ArrayList<AbstractAffineTile2D<?>[]> tilePairs = new ArrayList<AbstractAffineTile2D<?>[]>();
        if (tilesAreInPlace) {
            AbstractAffineTile2D.pairOverlappingTiles(tiles, tilePairs);
        } else {
            AbstractAffineTile2D.pairTiles(tiles, tilePairs);
        }
        Align.connectTilePairs(p, tiles, tilePairs, numThreads);
        Align.optimizeTileConfiguration(p, tiles, fixedTiles);
    }

    public static final void alignTiles(ParamOptimize p, List<AbstractAffineTile2D<?>> tiles, List<AbstractAffineTile2D<?>> fixedTiles, int numThreads) {
        Align.alignTiles(p, tiles, fixedTiles, true, numThreads);
    }

    public static final void optimizeTileConfiguration(ParamOptimize p, List<AbstractAffineTile2D<?>> tiles, List<AbstractAffineTile2D<?>> fixedTiles) {
        TileConfiguration tc = new TileConfiguration();
        for (AbstractAffineTile2D<?> abstractAffineTile2D : tiles) {
            if (abstractAffineTile2D.getConnectedTiles().size() <= 0) continue;
            tc.addTile(abstractAffineTile2D);
        }
        for (Tile tile : fixedTiles) {
            tc.fixTile(tile);
        }
        try {
            if (p.filterOutliers) {
                tc.optimizeAndFilter(p.maxEpsilon, p.maxIterations, p.maxPlateauwidth, p.meanFactor);
            } else {
                tc.optimize(p.maxEpsilon, p.maxIterations, p.maxPlateauwidth);
            }
        }
        catch (Exception e) {
            IJ.error((String)(e.getMessage() + " " + e.getStackTrace()));
        }
    }

    protected static final void pairwiseAlign(AbstractAffineTile2D<?> tile, Set<AbstractAffineTile2D<?>> visited) {
        visited.add(tile);
        for (Tile t : tile.getConnectedTiles()) {
            if (visited.contains(t)) continue;
            Align.pairwiseAlign((AbstractAffineTile2D)t, visited);
        }
    }

    public static final void pairwiseAlignTileConfiguration(List<AbstractAffineTile2D<?>> tiles) {
    }

    public static final void connectTilePairs(Param p, List<AbstractAffineTile2D<?>> tiles, List<AbstractAffineTile2D<?>[]> tilePairs, int numThreads, boolean multipleHypotheses) {
        AtomicInteger ai = new AtomicInteger(0);
        AtomicInteger ap = new AtomicInteger(0);
        int steps = tiles.size() + tilePairs.size();
        ArrayList<ExtractFeaturesThread> extractFeaturesThreads = new ArrayList<ExtractFeaturesThread>();
        ArrayList<MatchFeaturesAndFindModelThread> matchFeaturesAndFindModelThreads = new ArrayList<MatchFeaturesAndFindModelThread>();
        for (int i = 0; i < numThreads; ++i) {
            ExtractFeaturesThread extractFeaturesThread = new ExtractFeaturesThread(p.clone(), tiles, ai, ap, steps);
            extractFeaturesThreads.add(extractFeaturesThread);
            extractFeaturesThread.start();
        }
        try {
            for (ExtractFeaturesThread interruptedException : extractFeaturesThreads) {
                interruptedException.join();
            }
        }
        catch (InterruptedException e) {
            Utils.log("Feature extraction interrupted.");
            for (Thread thread : extractFeaturesThreads) {
                thread.interrupt();
            }
            try {
                for (Thread thread : extractFeaturesThreads) {
                    thread.join();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Thread.currentThread().interrupt();
            IJ.showProgress((double)1.0);
            return;
        }
        ai.set(0);
        for (int i = 0; i < numThreads; ++i) {
            MatchFeaturesAndFindModelThread matchFeaturesAndFindModelThread = new MatchFeaturesAndFindModelThread(p.clone(), tiles, tilePairs, ai, ap, steps, multipleHypotheses);
            matchFeaturesAndFindModelThreads.add(matchFeaturesAndFindModelThread);
            matchFeaturesAndFindModelThread.start();
        }
        try {
            for (MatchFeaturesAndFindModelThread matchFeaturesAndFindModelThread : matchFeaturesAndFindModelThreads) {
                matchFeaturesAndFindModelThread.join();
            }
        }
        catch (InterruptedException e) {
            Utils.log("Establishing feature correspondences interrupted.");
            for (Thread thread : matchFeaturesAndFindModelThreads) {
                thread.interrupt();
            }
            try {
                for (Thread thread : matchFeaturesAndFindModelThreads) {
                    thread.join();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Thread.currentThread().interrupt();
            IJ.showProgress((double)1.0);
        }
    }

    public static final void connectTilePairs(Param p, List<AbstractAffineTile2D<?>> tiles, List<AbstractAffineTile2D<?>[]> tilePairs, int numThreads) {
        Align.connectTilePairs(p, tiles, tilePairs, numThreads, false);
    }

    public static final void tilesFromPatches(Param p, List<? extends Patch> patches, Collection<? extends Patch> fixedPatches, List<AbstractAffineTile2D<?>> tiles, Collection<AbstractAffineTile2D<?>> fixedTiles) {
        for (Patch patch : patches) {
            AbstractAffineTile2D t;
            if (p.regularize) {
                AbstractAffineModel2D m = (AbstractAffineModel2D)Util.createModel(p.desiredModelIndex);
                AbstractAffineModel2D r = (AbstractAffineModel2D)Util.createModel(p.regularizerModelIndex);
                InterpolatedAffineModel2D interpolatedModel = new InterpolatedAffineModel2D((Model)m, (Model)r, p.lambda);
                t = new GenericAffineTile2D<InterpolatedAffineModel2D>(interpolatedModel, patch);
            } else {
                switch (p.desiredModelIndex) {
                    case 0: {
                        t = new TranslationTile2D(patch);
                        break;
                    }
                    case 1: {
                        t = new RigidTile2D(patch);
                        break;
                    }
                    case 2: {
                        t = new SimilarityTile2D(patch);
                        break;
                    }
                    case 3: {
                        t = new AffineTile2D(patch);
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            tiles.add(t);
            if ((fixedPatches == null || !fixedPatches.contains(patch)) && !patch.isLocked()) continue;
            fixedTiles.add(t);
        }
    }

    public static final void alignSelectedPatches(Selection selection, int numThreads) {
        ArrayList<Patch> patches = new ArrayList<Patch>();
        for (Displayable d : selection.getSelected()) {
            if (!(d instanceof Patch)) continue;
            patches.add((Patch)d);
        }
        if (patches.size() < 2) {
            return;
        }
        if (!paramOptimize.setup("Align selected patches")) {
            return;
        }
        ArrayList tiles = new ArrayList();
        ArrayList fixedTiles = new ArrayList();
        ArrayList<Patch> fixedPatches = new ArrayList<Patch>();
        Displayable active = selection.getActive();
        if (active != null && active instanceof Patch) {
            fixedPatches.add((Patch)active);
        }
        Align.tilesFromPatches(paramOptimize, patches, fixedPatches, tiles, fixedTiles);
        Align.alignTiles(paramOptimize, tiles, fixedTiles, numThreads);
        for (AbstractAffineTile2D abstractAffineTile2D : tiles) {
            abstractAffineTile2D.getPatch().setAffineTransform(((Affine2D)abstractAffineTile2D.getModel()).createAffine());
        }
    }

    public static final void alignLayer(Layer layer, int numThreads) {
        if (!paramOptimize.setup("Align patches in layer")) {
            return;
        }
        ArrayList<Displayable> displayables = layer.getDisplayables(Patch.class);
        ArrayList<Patch> patches = new ArrayList<Patch>();
        for (Displayable d : displayables) {
            patches.add((Patch)d);
        }
        ArrayList tiles = new ArrayList();
        ArrayList fixedTiles = new ArrayList();
        Align.tilesFromPatches(paramOptimize, patches, null, tiles, fixedTiles);
        Align.alignTiles(paramOptimize, tiles, fixedTiles, numThreads);
        for (AbstractAffineTile2D abstractAffineTile2D : tiles) {
            abstractAffineTile2D.getPatch().setAffineTransform(((Affine2D)abstractAffineTile2D.getModel()).createAffine());
        }
    }

    public static final void alignLayersLinearly(List<Layer> layers, int numThreads) {
        Align.alignLayersLinearly(layers, numThreads, null);
    }

    public static final void alignLayersLinearly(List<Layer> layers, int numThreads, Filter<Patch> filter) {
        Align.param.sift.maxOctaveSize = 1600;
        if (!param.setup("Align layers linearly")) {
            return;
        }
        Rectangle box = layers.get(0).getParent().getMinimalBoundingBox(Patch.class);
        double scale = Math.min(1.0, Math.min((double)Align.param.sift.maxOctaveSize / (double)box.width, (double)Align.param.sift.maxOctaveSize / (double)box.height));
        Param p = param.clone();
        p.maxEpsilon = (float)((double)p.maxEpsilon * scale);
        FloatArray2DSIFT sift = new FloatArray2DSIFT(p.sift);
        SIFT ijSIFT = new SIFT(sift);
        Rectangle box1 = null;
        Rectangle box2 = null;
        ArrayList features1 = new ArrayList();
        ArrayList features2 = new ArrayList();
        ArrayList candidates = new ArrayList();
        ArrayList inliers = new ArrayList();
        AffineTransform a = new AffineTransform();
        int i = 0;
        for (Layer l : layers) {
            long s = System.currentTimeMillis();
            features1.clear();
            features1.addAll(features2);
            features2.clear();
            Rectangle box3 = l.getMinimalBoundingBox(Patch.class);
            if (box3 == null) continue;
            box1 = box2;
            box2 = box3;
            ArrayList<Patch> patches = l.getAll(Patch.class);
            if (null != filter) {
                Iterator it = patches.iterator();
                while (it.hasNext()) {
                    if (filter.accept((Patch)it.next())) continue;
                    it.remove();
                }
            }
            ijSIFT.extractFeatures(l.getProject().getLoader().getFlatImage(l, box2, scale, -1, 0, Patch.class, patches, true).getProcessor(), features2);
            Utils.log(features2.size() + " features extracted in layer \"" + l.getTitle() + "\" (took " + (System.currentTimeMillis() - s) + " ms).");
            if (features1.size() > 0) {
                boolean modelFound;
                TranslationModel2D model;
                s = System.currentTimeMillis();
                candidates.clear();
                FeatureTransform.matchFeatures(features2, features1, candidates, (float)p.rod);
                switch (p.expectedModelIndex) {
                    case 0: {
                        model = new TranslationModel2D();
                        break;
                    }
                    case 1: {
                        model = new RigidModel2D();
                        break;
                    }
                    case 2: {
                        model = new SimilarityModel2D();
                        break;
                    }
                    case 3: {
                        model = new AffineModel2D();
                        break;
                    }
                    default: {
                        return;
                    }
                }
                boolean again = false;
                try {
                    do {
                        again = false;
                        modelFound = model.filterRansac(candidates, inliers, 1000, (double)p.maxEpsilon, (double)p.minInlierRatio, p.minNumInliers, 3.0);
                        if (!modelFound || !p.rejectIdentity) continue;
                        ArrayList points = new ArrayList();
                        PointMatch.sourcePoints(inliers, points);
                        if (!Transforms.isIdentity((CoordinateTransform)model, points, (double)p.identityTolerance)) continue;
                        Utils.log("Identity transform for " + inliers.size() + " matches rejected.");
                        candidates.removeAll(inliers);
                        inliers.clear();
                        again = true;
                    } while (again);
                }
                catch (NotEnoughDataPointsException e) {
                    modelFound = false;
                }
                if (modelFound) {
                    Utils.log("Model found for layer \"" + l.getTitle() + "\" and its predecessor:\n  correspondences  " + inliers.size() + " of " + candidates.size() + "\n  average residual error  " + model.getCost() / scale + " px\n  took " + (System.currentTimeMillis() - s) + " ms");
                    AffineTransform b = new AffineTransform();
                    b.translate(box1.x, box1.y);
                    b.scale(1.0 / scale, 1.0 / scale);
                    b.concatenate(model.createAffine());
                    b.scale(scale, scale);
                    b.translate(-box2.x, -box2.y);
                    a.concatenate(b);
                    l.apply(Displayable.class, a);
                    Display.repaint(l);
                } else {
                    Utils.log("No model found for layer \"" + l.getTitle() + "\" and its predecessor:\n  correspondence candidates  " + candidates.size() + "\n  took " + (System.currentTimeMillis() - s) + " ms");
                    a.setToIdentity();
                }
            }
            IJ.showProgress((int)(++i), (int)layers.size());
        }
    }

    public static final MovingLeastSquaresTransform2 createMLST(Collection<PointMatch> matches, double alpha) throws Exception {
        MovingLeastSquaresTransform2 mlst = new MovingLeastSquaresTransform2();
        mlst.setAlpha(alpha);
        Class<AffineModel2D> c = AffineModel2D.class;
        switch (matches.size()) {
            case 1: {
                c = TranslationModel2D.class;
                break;
            }
            case 2: {
                c = SimilarityModel2D.class;
                break;
            }
        }
        mlst.setModel(c);
        mlst.setMatches(matches);
        return mlst;
    }

    public static final void alignTileCollections(Param p, Collection<AbstractAffineTile2D<?>> a, Collection<AbstractAffineTile2D<?>> b) {
        ArrayList<Patch> pa = new ArrayList<Patch>();
        ArrayList<Patch> pb = new ArrayList<Patch>();
        for (AbstractAffineTile2D<?> t : a) {
            pa.add(t.getPatch());
        }
        for (AbstractAffineTile2D<?> t : b) {
            pb.add(t.getPatch());
        }
        Layer la = ((Patch)pa.iterator().next()).getLayer();
        Layer lb = ((Patch)pb.iterator().next()).getLayer();
        Rectangle boxA = Displayable.getBoundingBox(pa, null);
        Rectangle boxB = Displayable.getBoundingBox(pb, null);
        double scale = Math.min(1.0, Math.min(Math.min((double)p.sift.maxOctaveSize / (double)boxA.width, (double)p.sift.maxOctaveSize / (double)boxA.height), Math.min((double)p.sift.maxOctaveSize / (double)boxB.width, (double)p.sift.maxOctaveSize / (double)boxB.height)));
        Param pp = p.clone();
        pp.maxEpsilon = (float)((double)pp.maxEpsilon * scale);
        FloatArray2DSIFT sift = new FloatArray2DSIFT(pp.sift);
        SIFT ijSIFT = new SIFT(sift);
        ArrayList featuresA = new ArrayList();
        ArrayList featuresB = new ArrayList();
        ArrayList candidates = new ArrayList();
        ArrayList inliers = new ArrayList();
        long s = System.currentTimeMillis();
        ijSIFT.extractFeatures(la.getProject().getLoader().getFlatImage(la, boxA, scale, -1, 0, null, pa, true, Color.GRAY).getProcessor(), featuresA);
        Utils.log(featuresA.size() + " features extracted in graph A in layer \"" + la.getTitle() + "\" (took " + (System.currentTimeMillis() - s) + " ms).");
        s = System.currentTimeMillis();
        ijSIFT.extractFeatures(lb.getProject().getLoader().getFlatImage(lb, boxB, scale, -1, 0, null, pb, true, Color.GRAY).getProcessor(), featuresB);
        Utils.log(featuresB.size() + " features extracted in graph B in layer \"" + lb.getTitle() + "\" (took " + (System.currentTimeMillis() - s) + " ms).");
        if (featuresA.size() > 0 && featuresB.size() > 0) {
            boolean modelFound;
            TranslationModel2D model;
            s = System.currentTimeMillis();
            FeatureTransform.matchFeatures(featuresA, featuresB, candidates, (float)pp.rod);
            switch (p.expectedModelIndex) {
                case 0: {
                    model = new TranslationModel2D();
                    break;
                }
                case 1: {
                    model = new RigidModel2D();
                    break;
                }
                case 2: {
                    model = new SimilarityModel2D();
                    break;
                }
                case 3: {
                    model = new AffineModel2D();
                    break;
                }
                default: {
                    return;
                }
            }
            boolean again = false;
            try {
                do {
                    again = false;
                    modelFound = model.filterRansac(candidates, inliers, 1000, (double)p.maxEpsilon, (double)p.minInlierRatio, p.minNumInliers, 3.0);
                    if (!modelFound || !p.rejectIdentity) continue;
                    ArrayList points = new ArrayList();
                    PointMatch.sourcePoints(inliers, points);
                    if (!Transforms.isIdentity((CoordinateTransform)model, points, (double)p.identityTolerance)) continue;
                    Utils.log("Identity transform for " + inliers.size() + " matches rejected.");
                    candidates.removeAll(inliers);
                    inliers.clear();
                    again = true;
                } while (again);
            }
            catch (NotEnoughDataPointsException e) {
                modelFound = false;
            }
            if (modelFound) {
                Utils.log("Model found for graph A and B in layers \"" + la.getTitle() + "\" and \"" + lb.getTitle() + "\":\n  correspondences  " + inliers.size() + " of " + candidates.size() + "\n  average residual error  " + model.getCost() / scale + " px\n  took " + (System.currentTimeMillis() - s) + " ms");
                AffineTransform at = new AffineTransform();
                at.translate(boxA.x, boxA.y);
                at.scale(1.0 / scale, 1.0 / scale);
                at.concatenate(model.createAffine());
                at.scale(scale, scale);
                at.translate(-boxB.x, -boxB.y);
                for (Patch t : pa) {
                    t.preTransform(at, false);
                }
                Display.repaint(la);
            } else {
                Utils.log("No model found for graph A and B in layers \"" + la.getTitle() + "\" and \"" + lb.getTitle() + "\":\n  correspondence candidates  " + candidates.size() + "\n  took " + (System.currentTimeMillis() - s) + " ms");
            }
        }
    }

    protected static final class MatchFeaturesAndFindModelThread
    extends Thread {
        protected final Param p;
        protected final List<AbstractAffineTile2D<?>> tiles;
        protected final List<AbstractAffineTile2D<?>[]> tilePairs;
        protected final AtomicInteger ai;
        protected final AtomicInteger ap;
        protected final int steps;
        protected final boolean multipleHypotheses;

        public MatchFeaturesAndFindModelThread(Param p, List<AbstractAffineTile2D<?>> tiles, List<AbstractAffineTile2D<?>[]> tilePairs, AtomicInteger ai, AtomicInteger ap, int steps, boolean multipleHypotheses) {
            this.p = p;
            this.tiles = tiles;
            this.tilePairs = tilePairs;
            this.ai = ai;
            this.ap = ap;
            this.steps = steps;
            this.multipleHypotheses = multipleHypotheses;
        }

        public MatchFeaturesAndFindModelThread(Param p, List<AbstractAffineTile2D<?>> tiles, List<AbstractAffineTile2D<?>[]> tilePairs, AtomicInteger ai, AtomicInteger ap, int steps) {
            this(p, tiles, tilePairs, ai, ap, steps, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            ArrayList<PointMatch> candidates = new ArrayList<PointMatch>();
            int i = this.ai.getAndIncrement();
            while (i < this.tilePairs.size() && !this.isInterrupted()) {
                if (this.isInterrupted()) {
                    return;
                }
                candidates.clear();
                AbstractAffineTile2D<?>[] tilePair = this.tilePairs.get(i);
                Collection<PointMatch> inliers = Align.deserializePointMatches(this.p, tilePair[0], tilePair[1]);
                if (inliers == null) {
                    TranslationModel2D model;
                    inliers = new ArrayList<PointMatch>();
                    long s = System.currentTimeMillis();
                    FeatureTransform.matchFeatures(Align.fetchFeatures(this.p, tilePair[0]), Align.fetchFeatures(this.p, tilePair[1]), candidates, (float)this.p.rod);
                    switch (this.p.expectedModelIndex) {
                        case 0: {
                            model = new TranslationModel2D();
                            break;
                        }
                        case 1: {
                            model = new RigidModel2D();
                            break;
                        }
                        case 2: {
                            model = new SimilarityModel2D();
                            break;
                        }
                        case 3: {
                            model = new AffineModel2D();
                            break;
                        }
                        case 4: {
                            model = new HomographyModel2D();
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    boolean modelFound = Align.findModel(model, candidates, inliers, this.p.maxEpsilon, this.p.minInlierRatio, this.p.minNumInliers, this.p.rejectIdentity, this.p.identityTolerance, this.multipleHypotheses);
                    if (modelFound) {
                        Utils.log("Model found for tiles \"" + tilePair[0].getPatch() + "\" and \"" + tilePair[1].getPatch() + "\":\n  correspondences  " + inliers.size() + " of " + candidates.size() + "\n  average residual error  " + model.getCost() + " px\n  took " + (System.currentTimeMillis() - s) + " ms");
                    } else {
                        Utils.log("No model found for tiles \"" + tilePair[0].getPatch() + "\" and \"" + tilePair[1].getPatch() + "\":\n  correspondence candidates  " + candidates.size() + "\n  took " + (System.currentTimeMillis() - s) + " ms");
                    }
                    if (!Align.serializePointMatches(this.p, tilePair[0], tilePair[1], inliers)) {
                        Utils.log("Saving point matches failed for tiles \"" + tilePair[0].getPatch() + "\" and \"" + tilePair[1].getPatch() + "\"");
                    }
                } else {
                    Utils.log("Point matches for tiles \"" + tilePair[0].getPatch().getTitle() + "\" and \"" + tilePair[1].getPatch().getTitle() + "\" fetched from disk cache");
                }
                if (inliers != null && inliers.size() > 0) {
                    for (PointMatch pm : inliers) {
                        pm.setWeights(new double[]{this.p.correspondenceWeight});
                    }
                    Object object = tilePair[0];
                    synchronized (object) {
                        AbstractAffineTile2D<?> abstractAffineTile2D = tilePair[1];
                        synchronized (abstractAffineTile2D) {
                            tilePair[0].connect(tilePair[1], inliers);
                        }
                        tilePair[0].clearVirtualMatches();
                    }
                    object = tilePair[1];
                    synchronized (object) {
                        tilePair[1].clearVirtualMatches();
                    }
                }
                IJ.showProgress((int)this.ap.getAndIncrement(), (int)this.steps);
                i = this.ai.getAndIncrement();
            }
        }
    }

    protected static final class ExtractFeaturesThread
    extends Thread {
        protected final Param p;
        protected final List<AbstractAffineTile2D<?>> tiles;
        protected final AtomicInteger ai;
        protected final AtomicInteger ap;
        protected final int steps;

        public ExtractFeaturesThread(Param p, List<AbstractAffineTile2D<?>> tiles, AtomicInteger ai, AtomicInteger ap, int steps) {
            this.p = p;
            this.tiles = tiles;
            this.ai = ai;
            this.ap = ap;
            this.steps = steps;
        }

        @Override
        public final void run() {
            FloatArray2DSIFT sift = new FloatArray2DSIFT(this.p.sift);
            SIFT ijSIFT = new SIFT(sift);
            int i = this.ai.getAndIncrement();
            while (i < this.tiles.size() && !this.isInterrupted()) {
                if (this.isInterrupted()) {
                    return;
                }
                AbstractAffineTile2D<?> tile = this.tiles.get(i);
                Collection<Feature> features = Align.deserializeFeatures(this.p, tile);
                if (features == null) {
                    boolean memoryFlushed;
                    do {
                        try {
                            features = new ArrayList<Feature>();
                            long s = System.currentTimeMillis();
                            ijSIFT.extractFeatures((ImageProcessor)tile.createMaskedByteImage(), features);
                            Utils.log(features.size() + " features extracted in tile " + i + " \"" + tile.getPatch().getTitle() + "\" (took " + (System.currentTimeMillis() - s) + " ms).");
                            if (!Align.serializeFeatures(this.p, tile, features)) {
                                Utils.log("Saving features failed for tile \"" + tile.getPatch() + "\"");
                            }
                            memoryFlushed = false;
                        }
                        catch (OutOfMemoryError e) {
                            Utils.log2("Flushing memory for feature extraction");
                            Loader.releaseAllCaches();
                            memoryFlushed = true;
                        }
                    } while (memoryFlushed);
                } else {
                    Utils.log(features.size() + " features loaded for tile " + i + " \"" + tile.getPatch().getTitle() + "\".");
                }
                IJ.showProgress((int)this.ap.getAndIncrement(), (int)this.steps);
                i = this.ai.getAndIncrement();
            }
        }
    }

    private static final class PointMatches
    implements Serializable {
        private static final long serialVersionUID = -2564147268101223484L;
        Param p;
        ArrayList<PointMatch> pointMatches;

        PointMatches(Param p, ArrayList<PointMatch> pointMatches) {
            this.p = p;
            this.pointMatches = pointMatches;
        }
    }

    private static final class Features
    implements Serializable {
        private static final long serialVersionUID = 2689219384710526198L;
        FloatArray2DSIFT.Param p;
        ArrayList<Feature> features;

        Features(FloatArray2DSIFT.Param p, ArrayList<Feature> features) {
            this.p = p;
            this.features = features;
        }
    }

    public static class ParamOptimize
    extends Param {
        private static final long serialVersionUID = 2173278806083343006L;
        public int maxIterations = 2000;
        public int maxPlateauwidth = 200;
        public boolean filterOutliers = false;
        public float meanFactor = 3.0f;

        @Override
        public void addAlignmentFields(GenericDialog gd) {
            super.addAlignmentFields(gd);
            gd.addMessage("Optimization:");
            gd.addNumericField("maximal_iterations :", (double)this.maxIterations, 0);
            gd.addNumericField("maximal_plateauwidth :", (double)this.maxPlateauwidth, 0);
            gd.addCheckbox("filter outliers", this.filterOutliers);
            gd.addNumericField("mean_factor :", (double)this.meanFactor, 2);
        }

        @Override
        public boolean readAlignmentFields(GenericDialog gd) {
            super.readAlignmentFields(gd);
            this.maxIterations = (int)gd.getNextNumber();
            this.maxPlateauwidth = (int)gd.getNextNumber();
            this.filterOutliers = gd.getNextBoolean();
            this.meanFactor = (float)gd.getNextNumber();
            return !gd.invalidNumber();
        }

        @Override
        public void addFields(GenericDialog gd) {
            super.addFields(gd);
            gd.addNumericField("maximal_iterations :", (double)this.maxIterations, 0);
            gd.addNumericField("maximal_plateauwidth :", (double)this.maxPlateauwidth, 0);
            gd.addCheckbox("filter outliers", this.filterOutliers);
            gd.addNumericField("mean_factor :", (double)this.meanFactor, 2);
        }

        @Override
        public boolean readFields(GenericDialog gd) {
            super.readFields(gd);
            this.maxIterations = (int)gd.getNextNumber();
            this.maxPlateauwidth = (int)gd.getNextNumber();
            this.filterOutliers = gd.getNextBoolean();
            this.meanFactor = (float)gd.getNextNumber();
            return !gd.invalidNumber();
        }

        @Override
        public final ParamOptimize clone() {
            ParamOptimize p = new ParamOptimize();
            p.sift.initialSigma = this.sift.initialSigma;
            p.sift.steps = this.sift.steps;
            p.sift.minOctaveSize = this.sift.minOctaveSize;
            p.sift.maxOctaveSize = this.sift.maxOctaveSize;
            p.sift.fdSize = this.sift.fdSize;
            p.sift.fdBins = this.sift.fdBins;
            p.rod = this.rod;
            p.maxEpsilon = this.maxEpsilon;
            p.minInlierRatio = this.minInlierRatio;
            p.minNumInliers = this.minNumInliers;
            p.expectedModelIndex = this.expectedModelIndex;
            p.rejectIdentity = this.rejectIdentity;
            p.identityTolerance = this.identityTolerance;
            p.desiredModelIndex = this.desiredModelIndex;
            p.regularize = this.regularize;
            p.regularizerModelIndex = this.regularizerModelIndex;
            p.lambda = this.lambda;
            p.maxIterations = this.maxIterations;
            p.maxPlateauwidth = this.maxPlateauwidth;
            p.filterOutliers = this.filterOutliers;
            p.meanFactor = this.meanFactor;
            return p;
        }

        public boolean equals(ParamOptimize p) {
            return super.equals(p) && this.maxIterations == p.maxIterations && this.maxPlateauwidth == p.maxPlateauwidth && this.filterOutliers == p.filterOutliers && this.meanFactor == p.meanFactor;
        }
    }

    public static class Param
    implements Serializable {
        private static final long serialVersionUID = -6469820142091971052L;
        public final FloatArray2DSIFT.Param sift = new FloatArray2DSIFT.Param();
        public float rod = 0.92f;
        public float maxEpsilon = 100.0f;
        public float minInlierRatio = 0.2f;
        public int minNumInliers = 7;
        public static final String[] modelStrings = new String[]{"Translation", "Rigid", "Similarity", "Affine"};
        public int expectedModelIndex = 1;
        public int desiredModelIndex = 1;
        public int regularizerModelIndex = 1;
        public boolean regularize = false;
        public double lambda = 0.1;
        public float correspondenceWeight = 1.0f;
        public boolean rejectIdentity = false;
        public float identityTolerance = 0.5f;

        public Param() {
            this.sift.maxOctaveSize = 600;
            this.sift.fdSize = 8;
        }

        public void addSIFTFields(GenericDialog gd) {
            SIFT.addFields((GenericDialog)gd, (FloatArray2DSIFT.Param)this.sift);
            gd.addNumericField("closest/next_closest_ratio :", (double)this.rod, 2);
        }

        public void addGeometricConsensusFilterFields(GenericDialog gd) {
            gd.addNumericField("maximal_alignment_error :", (double)this.maxEpsilon, 2, 6, "px");
            gd.addNumericField("minimal_inlier_ratio :", (double)this.minInlierRatio, 2);
            gd.addNumericField("minimal_number_of_inliers :", (double)this.minNumInliers, 0);
            gd.addChoice("expected_transformation :", modelStrings, modelStrings[this.expectedModelIndex]);
            gd.addCheckbox("ignore constant background", this.rejectIdentity);
            gd.addNumericField("tolerance :", (double)this.identityTolerance, 2, 6, "px");
        }

        public void addAlignmentFields(GenericDialog gd) {
            gd.addChoice("desired_transformation :", modelStrings, modelStrings[this.desiredModelIndex]);
            gd.addNumericField("correspondence weight :", (double)this.correspondenceWeight, 2);
            gd.addCheckbox("regularize", this.regularize);
        }

        public void addRegularizationFields(GenericDialog gd) {
            gd.addChoice("regularizer :", modelStrings, modelStrings[this.regularizerModelIndex]);
            gd.addNumericField("lambda :", this.lambda, 2);
        }

        public void addFields(GenericDialog gd) {
            this.addSIFTFields(gd);
            gd.addMessage("Geometric Consensus Filter:");
            this.addGeometricConsensusFilterFields(gd);
            gd.addMessage("Alignment:");
            this.addAlignmentFields(gd);
            this.addRegularizationFields(gd);
        }

        public boolean readSIFTFields(GenericDialog gd) {
            SIFT.readFields((GenericDialog)gd, (FloatArray2DSIFT.Param)this.sift);
            this.rod = (float)gd.getNextNumber();
            return !gd.invalidNumber();
        }

        public boolean readGeometricConsensusFilterFields(GenericDialog gd) {
            this.maxEpsilon = (float)gd.getNextNumber();
            this.minInlierRatio = (float)gd.getNextNumber();
            this.minNumInliers = (int)gd.getNextNumber();
            this.expectedModelIndex = gd.getNextChoiceIndex();
            this.rejectIdentity = gd.getNextBoolean();
            this.identityTolerance = (float)gd.getNextNumber();
            return !gd.invalidNumber();
        }

        public boolean readAlignmentFields(GenericDialog gd) {
            this.desiredModelIndex = gd.getNextChoiceIndex();
            this.correspondenceWeight = (float)gd.getNextNumber();
            this.regularize = gd.getNextBoolean();
            return !gd.invalidNumber();
        }

        public boolean readRegularizationFields(GenericDialog gd) {
            this.regularizerModelIndex = gd.getNextChoiceIndex();
            this.lambda = gd.getNextNumber();
            return !gd.invalidNumber();
        }

        public boolean readFields(GenericDialog gd) {
            boolean b = this.readSIFTFields(gd);
            b &= this.readGeometricConsensusFilterFields(gd);
            b &= this.readAlignmentFields(gd);
            return b &= this.readRegularizationFields(gd);
        }

        public final boolean setup(String title) {
            GenericDialog gdSIFT = new GenericDialog(title + ": SIFT parameters");
            this.addSIFTFields(gdSIFT);
            do {
                gdSIFT.showDialog();
                if (!gdSIFT.wasCanceled()) continue;
                return false;
            } while (!this.readSIFTFields(gdSIFT));
            GenericDialog gdGeometricConsensusFilter = new GenericDialog(title + ": Geometric Consensus Filter");
            this.addGeometricConsensusFilterFields(gdGeometricConsensusFilter);
            do {
                gdGeometricConsensusFilter.showDialog();
                if (!gdGeometricConsensusFilter.wasCanceled()) continue;
                return false;
            } while (!this.readGeometricConsensusFilterFields(gdGeometricConsensusFilter));
            GenericDialog gdAlignment = new GenericDialog(title + ": Alignment parameters");
            this.addAlignmentFields(gdAlignment);
            do {
                gdAlignment.showDialog();
                if (!gdAlignment.wasCanceled()) continue;
                return false;
            } while (!this.readAlignmentFields(gdAlignment));
            if (this.regularize) {
                GenericDialog gdRegularization = new GenericDialog(title + ": Regularization parameters");
                this.addRegularizationFields(gdRegularization);
                do {
                    gdRegularization.showDialog();
                    if (!gdRegularization.wasCanceled()) continue;
                    return false;
                } while (!this.readRegularizationFields(gdRegularization));
            }
            return true;
        }

        public Param clone() {
            Param p = new Param();
            p.sift.initialSigma = this.sift.initialSigma;
            p.sift.steps = this.sift.steps;
            p.sift.minOctaveSize = this.sift.minOctaveSize;
            p.sift.maxOctaveSize = this.sift.maxOctaveSize;
            p.sift.fdSize = this.sift.fdSize;
            p.sift.fdBins = this.sift.fdBins;
            p.rod = this.rod;
            p.maxEpsilon = this.maxEpsilon;
            p.minInlierRatio = this.minInlierRatio;
            p.minNumInliers = this.minNumInliers;
            p.expectedModelIndex = this.expectedModelIndex;
            p.rejectIdentity = this.rejectIdentity;
            p.identityTolerance = this.identityTolerance;
            p.desiredModelIndex = this.desiredModelIndex;
            p.correspondenceWeight = this.correspondenceWeight;
            p.regularize = this.regularize;
            p.regularizerModelIndex = this.regularizerModelIndex;
            p.lambda = this.lambda;
            return p;
        }

        public boolean equals(Param p) {
            return this.sift.equals(p.sift) && this.rod == p.rod && this.maxEpsilon == p.maxEpsilon && this.minInlierRatio == p.minInlierRatio && this.minNumInliers == p.minNumInliers && this.expectedModelIndex == p.expectedModelIndex && this.rejectIdentity == p.rejectIdentity && this.identityTolerance == p.identityTolerance;
        }
    }
}

