/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import java.util.Arrays;
import java.util.List;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.algebra.ScalarOperation;
import org.ojalgo.algebra.VectorSpace;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.ComplexArray;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.QuaternionArray;
import org.ojalgo.array.RationalArray;
import org.ojalgo.array.ReferenceTypeArray;
import org.ojalgo.array.ScalarArray;
import org.ojalgo.concurrent.DivideAndConquer;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.FunctionUtils;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.aggregator.AggregatorSet;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.store.ConjugatedStore;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.IdentityStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.SingleStore;
import org.ojalgo.matrix.store.TransposedStore;
import org.ojalgo.matrix.store.WrapperStore;
import org.ojalgo.matrix.store.ZeroStore;
import org.ojalgo.matrix.store.operation.AggregateAll;
import org.ojalgo.matrix.store.operation.ApplyCholesky;
import org.ojalgo.matrix.store.operation.ApplyLDL;
import org.ojalgo.matrix.store.operation.ApplyLU;
import org.ojalgo.matrix.store.operation.FillMatchingDual;
import org.ojalgo.matrix.store.operation.FillMatchingSingle;
import org.ojalgo.matrix.store.operation.GenerateApplyAndCopyHouseholderColumn;
import org.ojalgo.matrix.store.operation.GenerateApplyAndCopyHouseholderRow;
import org.ojalgo.matrix.store.operation.HouseholderHermitian;
import org.ojalgo.matrix.store.operation.HouseholderLeft;
import org.ojalgo.matrix.store.operation.HouseholderRight;
import org.ojalgo.matrix.store.operation.ModifyAll;
import org.ojalgo.matrix.store.operation.MultiplyBoth;
import org.ojalgo.matrix.store.operation.MultiplyLeft;
import org.ojalgo.matrix.store.operation.MultiplyNeither;
import org.ojalgo.matrix.store.operation.MultiplyRight;
import org.ojalgo.matrix.store.operation.RotateLeft;
import org.ojalgo.matrix.store.operation.RotateRight;
import org.ojalgo.matrix.store.operation.SubstituteBackwards;
import org.ojalgo.matrix.store.operation.SubstituteForwards;
import org.ojalgo.matrix.transformation.Householder;
import org.ojalgo.matrix.transformation.HouseholderReference;
import org.ojalgo.matrix.transformation.Rotation;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.type.context.NumberContext;

public final class GenericDenseStore<N extends Number>
extends ScalarArray<N>
implements PhysicalStore<N>,
DecompositionStore<N> {
    public static final PhysicalStore.Factory<ComplexNumber, GenericDenseStore<ComplexNumber>> COMPLEX = new Factory<ComplexNumber>(ComplexArray.FACTORY);
    public static final PhysicalStore.Factory<Quaternion, GenericDenseStore<Quaternion>> QUATERNION = new Factory<Quaternion>(QuaternionArray.FACTORY);
    public static final PhysicalStore.Factory<RationalNumber, GenericDenseStore<RationalNumber>> RATIONAL = new Factory<RationalNumber>(RationalArray.FACTORY);
    private final GenericMultiplyBoth<N> multiplyBoth;
    private final GenericMultiplyLeft<N> multiplyLeft;
    private final GenericMultiplyNeither<N> multiplyNeither;
    private final GenericMultiplyRight<N> multiplyRight;
    private final int myColDim;
    private final Factory<N> myFactory;
    private final int myRowDim;
    private final Array2D<N> myUtility;
    private transient N[] myWorkerColumn;

    private GenericDenseStore(Factory<N> factory, int numbRows) {
        this(factory, numbRows, 1);
    }

    private GenericDenseStore(Factory<N> factory, N[] dataArray) {
        this(factory, dataArray.length, 1, (Number[])dataArray);
    }

    GenericDenseStore(Factory<N> factory, int numbRows, int numbCols) {
        super(factory.array(), numbRows * numbCols);
        this.myFactory = factory;
        this.myRowDim = numbRows;
        this.myColDim = numbCols;
        this.myUtility = this.wrapInArray2D(this.myRowDim);
        this.multiplyBoth = MultiplyBoth.getGeneric(this.myRowDim, this.myColDim);
        this.multiplyLeft = MultiplyLeft.getGeneric(this.myRowDim, this.myColDim);
        this.multiplyRight = MultiplyRight.getGeneric(this.myRowDim, this.myColDim);
        this.multiplyNeither = MultiplyNeither.getGeneric(this.myRowDim, this.myColDim);
    }

    GenericDenseStore(Factory<N> factory, int numbRows, int numbCols, N[] dataArray) {
        super(factory.array(), dataArray);
        this.myFactory = factory;
        this.myRowDim = numbRows;
        this.myColDim = numbCols;
        this.myUtility = this.wrapInArray2D(this.myRowDim);
        this.multiplyBoth = MultiplyBoth.getGeneric(this.myRowDim, this.myColDim);
        this.multiplyLeft = MultiplyLeft.getGeneric(this.myRowDim, this.myColDim);
        this.multiplyRight = MultiplyRight.getGeneric(this.myRowDim, this.myColDim);
        this.multiplyNeither = MultiplyNeither.getGeneric(this.myRowDim, this.myColDim);
    }

    @Override
    public void accept(Access2D<?> supplied) {
        for (long j = 0L; j < supplied.countColumns(); ++j) {
            for (long i = 0L; i < supplied.countRows(); ++i) {
                this.set(i, j, (Number)supplied.get(i, j));
            }
        }
    }

    @Override
    public void add(long row, long col, double addend) {
        this.myUtility.add(row, col, addend);
    }

    @Override
    public void add(long row, long col, Number addend) {
        this.myUtility.add(row, col, addend);
    }

    @Override
    public N aggregateAll(final Aggregator aggregator) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        final AggregatorFunction<N> mainAggr = aggregator.getFunction(this.myFactory.aggregator());
        if (mainAggr.isMergeable() && tmpColDim > AggregateAll.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void conquer(int aFirst, int aLimit) {
                    AggregatorFunction tmpPartAggr = aggregator.getFunction(GenericDenseStore.this.myFactory.aggregator());
                    GenericDenseStore.this.visit(tmpRowDim * aFirst, tmpRowDim * aLimit, 1, tmpPartAggr);
                    AggregatorFunction aggregatorFunction = mainAggr;
                    synchronized (aggregatorFunction) {
                        mainAggr.merge(tmpPartAggr.get());
                    }
                }
            };
            tmpConquerer.invoke(0, tmpColDim, AggregateAll.THRESHOLD);
        } else {
            this.visit(0, this.size(), 1, mainAggr);
        }
        return mainAggr.get();
    }

    @Override
    public void applyCholesky(int iterationPoint, BasicArray<N> multipliers) {
        final Number[] tmpData = this.data;
        final Number[] tmpColumn = ((ScalarArray)multipliers).data;
        if (this.myColDim - iterationPoint - 1 > ApplyCholesky.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int aFirst, int aLimit) {
                    ApplyCholesky.invoke((Number[])tmpData, (int)GenericDenseStore.this.myRowDim, (int)aFirst, (int)aLimit, (Number[])tmpColumn);
                }
            };
            tmpConquerer.invoke(iterationPoint + 1, this.myColDim, ApplyCholesky.THRESHOLD);
        } else {
            ApplyCholesky.invoke((Number[])tmpData, (int)this.myRowDim, (int)(iterationPoint + 1), (int)this.myColDim, (Number[])tmpColumn);
        }
    }

    @Override
    public void applyLDL(final int iterationPoint, BasicArray<N> multipliers) {
        final Number[] tmpData = this.data;
        final Number[] tmpColumn = ((ScalarArray)multipliers).data;
        if (this.myColDim - iterationPoint - 1 > ApplyLDL.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int first, int limit) {
                    ApplyLDL.invoke((Number[])tmpData, (int)GenericDenseStore.this.myRowDim, (int)first, (int)limit, (Number[])tmpColumn, (int)iterationPoint);
                }
            };
            tmpConquerer.invoke(iterationPoint + 1, this.myColDim, ApplyLDL.THRESHOLD);
        } else {
            ApplyLDL.invoke((Number[])tmpData, (int)this.myRowDim, (int)(iterationPoint + 1), (int)this.myColDim, (Number[])tmpColumn, (int)iterationPoint);
        }
    }

    @Override
    public void applyLU(final int iterationPoint, BasicArray<N> multipliers) {
        final Number[] tmpData = this.data;
        final Number[] tmpColumn = ((ScalarArray)multipliers).data;
        if (this.myColDim - iterationPoint - 1 > ApplyLU.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int aFirst, int aLimit) {
                    ApplyLU.invoke((Number[])tmpData, (int)GenericDenseStore.this.myRowDim, (int)aFirst, (int)aLimit, (Number[])tmpColumn, (int)iterationPoint);
                }
            };
            tmpConquerer.invoke(iterationPoint + 1, this.myColDim, ApplyLU.THRESHOLD);
        } else {
            ApplyLU.invoke((Number[])tmpData, (int)this.myRowDim, (int)(iterationPoint + 1), (int)this.myColDim, (Number[])tmpColumn, (int)iterationPoint);
        }
    }

    @Override
    public Array1D<N> asList() {
        return this.myUtility.asArray1D();
    }

    @Override
    public Array1D<ComplexNumber> computeInPlaceSchur(PhysicalStore<N> transformationCollector, boolean eigenvalue) {
        ProgrammingError.throwForUnsupportedOptionalOperation();
        return null;
    }

    @Override
    public MatrixStore<N> conjugate() {
        return new ConjugatedStore(this);
    }

    @Override
    public GenericDenseStore<N> copy() {
        return new GenericDenseStore(this.myFactory, this.myRowDim, this.myColDim, this.copyOfData());
    }

    @Override
    public long countColumns() {
        return this.myColDim;
    }

    @Override
    public long countRows() {
        return this.myRowDim;
    }

    @Override
    public void divideAndCopyColumn(int row, int column, BasicArray<N> destination) {
        Number[] tmpData = this.data;
        int tmpRowDim = this.myRowDim;
        Number[] tmpDestination = ((ScalarArray)destination).data;
        int tmpIndex = row + column * tmpRowDim;
        Number tmpDenominator = tmpData[tmpIndex];
        for (int i = row + 1; i < tmpRowDim; ++i) {
            tmpDestination[i] = tmpData[tmpIndex] = ((Scalar)((ScalarOperation.Division)((Object)tmpData[++tmpIndex])).divide(tmpDenominator)).get();
        }
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.doubleValue(row + col * (long)this.myRowDim);
    }

    @Override
    public boolean equals(Object anObj) {
        if (anObj instanceof MatrixStore) {
            return this.equals((MatrixStore)anObj, NumberContext.getGeneral(6));
        }
        return super.equals(anObj);
    }

    @Override
    public void exchangeColumns(long colA, long colB) {
        this.myUtility.exchangeColumns(colA, colB);
    }

    @Override
    public void exchangeHermitian(int indexA, int indexB) {
        N tmpVal;
        int tmpMin = Math.min(indexA, indexB);
        int tmpMax = Math.max(indexA, indexB);
        for (int j = 0; j < tmpMin; ++j) {
            tmpVal = this.get(tmpMin, j);
            this.set((long)tmpMin, (long)j, (Number)this.get(tmpMax, j));
            this.set((long)tmpMax, (long)j, (Number)tmpVal);
        }
        tmpVal = this.get(tmpMin, tmpMin);
        this.set((long)tmpMin, (long)tmpMin, (Number)this.get(tmpMax, tmpMax));
        this.set((long)tmpMax, (long)tmpMax, (Number)tmpVal);
        for (int ij = tmpMin + 1; ij < tmpMax; ++ij) {
            tmpVal = this.get(ij, tmpMin);
            this.set((long)ij, (long)tmpMin, (Number)((Scalar)((VectorSpace)this.get(tmpMax, ij)).conjugate()).get());
            this.set((long)tmpMax, (long)ij, (Number)((Scalar)((VectorSpace)tmpVal).conjugate()).get());
        }
        for (int i = tmpMax + 1; i < this.myRowDim; ++i) {
            tmpVal = this.get(i, tmpMin);
            this.set((long)i, (long)tmpMin, (Number)this.get(i, tmpMax));
            this.set((long)i, (long)tmpMax, (Number)tmpVal);
        }
    }

    @Override
    public void exchangeRows(long rowA, long rowB) {
        this.myUtility.exchangeRows(rowA, rowB);
    }

    @Override
    public void fillByMultiplying(Access1D<N> left, Access1D<N> right) {
        int complexity = (int)left.count() / this.myRowDim;
        if (left instanceof GenericDenseStore) {
            if (right instanceof GenericDenseStore) {
                this.multiplyNeither.invoke(this.data, this.cast(left).data, complexity, this.cast(right).data, this.myFactory.scalar());
            } else {
                this.multiplyRight.invoke(this.data, this.cast(left).data, complexity, right, this.myFactory.scalar());
            }
        } else if (right instanceof GenericDenseStore) {
            this.multiplyLeft.invoke(this.data, left, complexity, this.cast(right).data, this.myFactory.scalar());
        } else {
            this.multiplyBoth.invoke(this, left, complexity, right);
        }
    }

    @Override
    public void fillColumn(long row, long col, Access1D<N> values) {
        this.myUtility.fillColumn(row, col, values);
    }

    @Override
    public void fillColumn(long row, long col, N value) {
        this.myUtility.fillColumn(row, col, value);
    }

    @Override
    public void fillColumn(long row, long col, NullaryFunction<N> supplier) {
        this.myUtility.fillColumn(row, col, supplier);
    }

    @Override
    public void fillDiagonal(long row, long col, N value) {
        this.myUtility.fillDiagonal(row, col, value);
    }

    @Override
    public void fillDiagonal(long row, long col, NullaryFunction<N> supplier) {
        this.myUtility.fillDiagonal(row, col, supplier);
    }

    @Override
    public void fillMatching(Access1D<?> values) {
        if (values instanceof ConjugatedStore) {
            final ConjugatedStore conjugated = (ConjugatedStore)values;
            if (this.myColDim > FillMatchingSingle.THRESHOLD) {
                DivideAndConquer tmpConquerer = new DivideAndConquer(){

                    @Override
                    public void conquer(int first, int limit) {
                        FillMatchingSingle.conjugate((Number[])GenericDenseStore.this.data, (int)GenericDenseStore.this.myRowDim, (int)first, (int)limit, conjugated.getOriginal(), GenericDenseStore.this.myFactory.scalar());
                    }
                };
                tmpConquerer.invoke(0, this.myColDim, FillMatchingSingle.THRESHOLD);
            } else {
                FillMatchingSingle.conjugate((Number[])this.data, (int)this.myRowDim, (int)0, (int)this.myColDim, conjugated.getOriginal(), this.myFactory.scalar());
            }
        } else if (values instanceof TransposedStore) {
            final TransposedStore transposed = (TransposedStore)values;
            if (this.myColDim > FillMatchingSingle.THRESHOLD) {
                DivideAndConquer tmpConquerer = new DivideAndConquer(){

                    @Override
                    public void conquer(int first, int limit) {
                        FillMatchingSingle.transpose((Number[])GenericDenseStore.this.data, (int)GenericDenseStore.this.myRowDim, (int)first, (int)limit, transposed.getOriginal(), GenericDenseStore.this.myFactory.scalar());
                    }
                };
                tmpConquerer.invoke(0, this.myColDim, FillMatchingSingle.THRESHOLD);
            } else {
                FillMatchingSingle.transpose((Number[])this.data, (int)this.myRowDim, (int)0, (int)this.myColDim, transposed.getOriginal(), this.myFactory.scalar());
            }
        } else {
            super.fillMatching(values);
        }
    }

    @Override
    public void fillMatching(final Access1D<N> left, final BinaryFunction<N> function, final Access1D<N> right) {
        int matchingCount = (int)FunctionUtils.min(this.count(), left.count(), right.count());
        if (this.myColDim > FillMatchingDual.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int first, int limit) {
                    GenericDenseStore.invoke((Number[])GenericDenseStore.this.data, (int)first, (int)limit, (int)1, (Access1D)left, (BinaryFunction)function, (Access1D)right);
                }
            };
            tmpConquerer.invoke(0, matchingCount, FillMatchingDual.THRESHOLD * FillMatchingDual.THRESHOLD);
        } else {
            ReferenceTypeArray.invoke((Number[])this.data, (int)0, (int)matchingCount, (int)1, left, function, right);
        }
    }

    @Override
    public void fillMatching(final UnaryFunction<N> function, final Access1D<N> arguments) {
        int matchingCount = (int)FunctionUtils.min(this.count(), arguments.count());
        if (this.myColDim > FillMatchingSingle.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                protected void conquer(int first, int limit) {
                    GenericDenseStore.invoke((Number[])GenericDenseStore.this.data, (int)first, (int)limit, (int)1, (Access1D)arguments, (UnaryFunction)function);
                }
            };
            tmpConquerer.invoke(0, matchingCount, FillMatchingSingle.THRESHOLD * FillMatchingSingle.THRESHOLD);
        } else {
            ReferenceTypeArray.invoke((Number[])this.data, (int)0, (int)matchingCount, (int)1, arguments, function);
        }
    }

    @Override
    public void fillOne(long row, long col, Access1D<?> values, long valueIndex) {
        this.set(row, col, (Number)values.get(valueIndex));
    }

    @Override
    public void fillOne(long row, long col, N value) {
        this.myUtility.fillOne(row, col, value);
    }

    @Override
    public void fillOne(long row, long col, NullaryFunction<N> supplier) {
        this.myUtility.fillOne(row, col, supplier);
    }

    @Override
    public void fillRow(long row, long col, Access1D<N> values) {
        this.myUtility.fillRow(row, col, values);
    }

    @Override
    public void fillRow(long row, long col, N value) {
        this.myUtility.fillRow(row, col, value);
    }

    @Override
    public void fillRow(long row, long col, NullaryFunction<N> supplier) {
        this.myUtility.fillRow(row, col, supplier);
    }

    @Override
    public boolean generateApplyAndCopyHouseholderColumn(int row, int column, Householder<N> destination) {
        return GenerateApplyAndCopyHouseholderColumn.invoke((Number[])this.data, (int)this.myRowDim, (int)row, (int)column, (Householder.Generic)((Householder.Generic)destination), this.myFactory.scalar());
    }

    @Override
    public boolean generateApplyAndCopyHouseholderRow(int row, int column, Householder<N> destination) {
        return GenerateApplyAndCopyHouseholderRow.invoke((Number[])this.data, (int)this.myRowDim, (int)row, (int)column, (Householder.Generic)((Householder.Generic)destination), this.myFactory.scalar());
    }

    @Override
    public final MatrixStore<N> get() {
        return this;
    }

    @Override
    public N get(long row, long col) {
        return this.myUtility.get(row, col);
    }

    @Override
    public int hashCode() {
        return MatrixUtils.hashCode(this);
    }

    @Override
    public long indexOfLargestInColumn(long row, long col) {
        return this.myUtility.indexOfLargestInColumn(row, col);
    }

    @Override
    public long indexOfLargestInRow(long row, long col) {
        return this.myUtility.indexOfLargestInRow(row, col);
    }

    @Override
    public long indexOfLargestOnDiagonal(long first) {
        return this.myUtility.indexOfLargestOnDiagonal(first);
    }

    @Override
    public boolean isAbsolute(long row, long col) {
        return this.myUtility.isAbsolute(row, col);
    }

    @Override
    public boolean isColumnSmall(long row, long col, double comparedTo) {
        return this.myUtility.isColumnSmall(row, col, comparedTo);
    }

    @Override
    public boolean isRowSmall(long row, long col, double comparedTo) {
        return this.myUtility.isRowSmall(row, col, comparedTo);
    }

    @Override
    public boolean isSmall(long row, long col, double comparedTo) {
        return this.myUtility.isSmall(row, col, comparedTo);
    }

    @Override
    public void modifyAll(final UnaryFunction<N> aFunc) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > ModifyAll.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int aFirst, int aLimit) {
                    GenericDenseStore.this.modify(tmpRowDim * aFirst, tmpRowDim * aLimit, 1, aFunc);
                }
            };
            tmpConquerer.invoke(0, tmpColDim, ModifyAll.THRESHOLD);
        } else {
            this.modify(tmpRowDim * 0, tmpRowDim * tmpColDim, 1, aFunc);
        }
    }

    @Override
    public void modifyColumn(long row, long col, UnaryFunction<N> modifier) {
        this.myUtility.modifyColumn(row, col, modifier);
    }

    @Override
    public void modifyDiagonal(long row, long col, UnaryFunction<N> modifier) {
        this.myUtility.modifyDiagonal(row, col, modifier);
    }

    @Override
    public void modifyMatching(Access1D<N> left, BinaryFunction<N> function) {
        long tmpLimit = FunctionUtils.min(left.count(), this.count(), this.count());
        for (long i = 0L; i < tmpLimit; ++i) {
            this.fillOne(i, (Number)function.invoke(left.get(i), this.get(i)));
        }
    }

    @Override
    public void modifyMatching(BinaryFunction<N> function, Access1D<N> right) {
        long tmpLimit = FunctionUtils.min(this.count(), right.count(), this.count());
        for (long i = 0L; i < tmpLimit; ++i) {
            this.fillOne(i, (Number)function.invoke(this.get(i), right.get(i)));
        }
    }

    @Override
    public void modifyOne(long row, long col, UnaryFunction<N> modifier) {
        N tmpValue = this.get(row, col);
        tmpValue = modifier.invoke(tmpValue);
        this.set(row, col, (Number)tmpValue);
    }

    @Override
    public void modifyRow(long row, long col, UnaryFunction<N> modifier) {
        this.myUtility.modifyRow(row, col, modifier);
    }

    @Override
    public MatrixStore<N> multiply(MatrixStore<N> right) {
        GenericDenseStore retVal = (GenericDenseStore)this.physical().makeZero(this.myRowDim, right.count() / (long)this.myColDim);
        if (right instanceof GenericDenseStore) {
            retVal.multiplyNeither.invoke(retVal.data, this.data, this.myColDim, this.cast(right).data, this.myFactory.scalar());
        } else {
            retVal.multiplyRight.invoke(retVal.data, this.data, this.myColDim, right, this.myFactory.scalar());
        }
        return retVal;
    }

    @Override
    public N multiplyBoth(Access1D<N> leftAndRight) {
        Structure2D tmpStep1 = this.myFactory.makeZero(1L, leftAndRight.count());
        Structure2D tmpStep2 = this.myFactory.makeZero(1L, 1L);
        Structure2D tmpLeft = this.myFactory.rows(new Access1D[]{leftAndRight});
        tmpLeft.modifyAll(this.myFactory.function().conjugate());
        tmpStep1.fillByMultiplying(tmpLeft, this);
        tmpStep2.fillByMultiplying(tmpStep1, leftAndRight);
        return tmpStep2.get(0L);
    }

    @Override
    public void negateColumn(int column) {
        this.myUtility.modifyColumn(0L, column, this.myFactory.function().negate());
    }

    @Override
    public PhysicalStore.Factory<N, GenericDenseStore<N>> physical() {
        return this.myFactory;
    }

    @Override
    public final ElementsConsumer<N> regionByColumns(int ... columns) {
        return new ElementsConsumer.ColumnsRegion<N>(this, this.multiplyBoth, columns);
    }

    @Override
    public final ElementsConsumer<N> regionByLimits(int rowLimit, int columnLimit) {
        return new ElementsConsumer.LimitRegion<N>(this, this.multiplyBoth, rowLimit, columnLimit);
    }

    @Override
    public final ElementsConsumer<N> regionByOffsets(int rowOffset, int columnOffset) {
        return new ElementsConsumer.OffsetRegion<N>(this, this.multiplyBoth, rowOffset, columnOffset);
    }

    @Override
    public final ElementsConsumer<N> regionByRows(int ... rows) {
        return new ElementsConsumer.RowsRegion<N>(this, this.multiplyBoth, rows);
    }

    @Override
    public final ElementsConsumer<N> regionByTransposing() {
        return new ElementsConsumer.TransposedRegion<N>(this, this.multiplyBoth);
    }

    @Override
    public void rotateRight(int low, int high, double cos, double sin) {
        RotateRight.invoke((Number[])this.data, (int)this.myRowDim, (int)low, (int)high, this.myFactory.scalar().cast(cos), this.myFactory.scalar().cast(sin));
    }

    @Override
    public void set(long row, long col, double value) {
        this.myUtility.set(row, col, value);
    }

    @Override
    public void set(long row, long col, Number value) {
        this.myUtility.set(row, col, value);
    }

    @Override
    public void setToIdentity(int col) {
        this.myUtility.set((long)col, (long)col, (Number)this.myFactory.scalar().one().get());
        this.myUtility.fillColumn((long)(col + 1), (long)col, this.myFactory.scalar().zero().get());
    }

    @Override
    public Array1D<N> sliceColumn(long row, long col) {
        return this.myUtility.sliceColumn(row, col);
    }

    @Override
    public Array1D<N> sliceDiagonal(long row, long col) {
        return this.myUtility.sliceDiagonal(row, col);
    }

    @Override
    public Array1D<N> sliceRange(long first, long limit) {
        return this.myUtility.sliceRange(first, limit);
    }

    @Override
    public Array1D<N> sliceRow(long row, long col) {
        return this.myUtility.sliceRow(row, col);
    }

    @Override
    public void substituteBackwards(final Access2D<N> body, final boolean unitDiagonal, final boolean conjugated, final boolean hermitian) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > SubstituteBackwards.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int aFirst, int aLimit) {
                    SubstituteBackwards.invoke((Number[])GenericDenseStore.this.data, (int)tmpRowDim, (int)aFirst, (int)aLimit, (Access2D)body, (boolean)unitDiagonal, (boolean)conjugated, (boolean)hermitian, GenericDenseStore.this.myFactory.scalar());
                }
            };
            tmpConquerer.invoke(0, tmpColDim, SubstituteBackwards.THRESHOLD);
        } else {
            SubstituteBackwards.invoke((Number[])this.data, (int)tmpRowDim, (int)0, (int)tmpColDim, body, (boolean)unitDiagonal, (boolean)conjugated, (boolean)hermitian, this.myFactory.scalar());
        }
    }

    @Override
    public void substituteForwards(final Access2D<N> body, final boolean unitDiagonal, final boolean conjugated, final boolean identity) {
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim > SubstituteForwards.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int aFirst, int aLimit) {
                    SubstituteForwards.invoke((Number[])GenericDenseStore.this.data, (int)tmpRowDim, (int)aFirst, (int)aLimit, (Access2D)body, (boolean)unitDiagonal, (boolean)conjugated, (boolean)identity, GenericDenseStore.this.myFactory.scalar());
                }
            };
            tmpConquerer.invoke(0, tmpColDim, SubstituteForwards.THRESHOLD);
        } else {
            SubstituteForwards.invoke((Number[])this.data, (int)tmpRowDim, (int)0, (int)tmpColDim, body, (boolean)unitDiagonal, (boolean)conjugated, (boolean)identity, this.myFactory.scalar());
        }
    }

    @Override
    public void supplyTo(ElementsConsumer<N> receiver) {
        receiver.fillMatching(this);
    }

    @Override
    public Scalar<N> toScalar(long row, long column) {
        return (Scalar)this.myUtility.get(row, column);
    }

    @Override
    public final String toString() {
        return Access2D.toString(this);
    }

    @Override
    public void transformLeft(Householder<N> transformation, int firstColumn) {
        final Householder.Generic<N> tmpTransf = this.cast(transformation);
        final Number[] tmpData = this.data;
        final int tmpRowDim = this.myRowDim;
        int tmpColDim = this.myColDim;
        if (tmpColDim - firstColumn > HouseholderLeft.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int aFirst, int aLimit) {
                    HouseholderLeft.invoke((Number[])tmpData, (int)tmpRowDim, (int)aFirst, (int)aLimit, (Householder.Generic)tmpTransf, GenericDenseStore.this.myFactory.scalar());
                }
            };
            tmpConquerer.invoke(firstColumn, tmpColDim, HouseholderLeft.THRESHOLD);
        } else {
            HouseholderLeft.invoke((Number[])tmpData, (int)tmpRowDim, (int)firstColumn, (int)tmpColDim, tmpTransf, this.myFactory.scalar());
        }
    }

    @Override
    public void transformLeft(Rotation<N> transformation) {
        Rotation.Generic<N> tmpTransf = this.cast(transformation);
        int tmpLow = tmpTransf.low;
        int tmpHigh = tmpTransf.high;
        if (tmpLow != tmpHigh) {
            if (tmpTransf.cos != null && tmpTransf.sin != null) {
                RotateLeft.invoke((Number[])this.data, (int)this.myRowDim, (int)tmpLow, (int)tmpHigh, tmpTransf.cos, tmpTransf.sin);
            } else {
                this.myUtility.exchangeRows(tmpLow, tmpHigh);
            }
        } else if (tmpTransf.cos != null) {
            this.myUtility.modifyRow(tmpLow, 0L, this.myFactory.function().multiply().second(tmpTransf.cos));
        } else if (tmpTransf.sin != null) {
            this.myUtility.modifyRow(tmpLow, 0L, this.myFactory.function().divide().second(tmpTransf.sin));
        } else {
            this.myUtility.modifyRow(tmpLow, 0L, this.myFactory.function().negate());
        }
    }

    @Override
    public void transformRight(Householder<N> transformation, int firstRow) {
        final Householder.Generic<N> tmpTransf = this.cast(transformation);
        final Number[] tmpData = this.data;
        int tmpRowDim = this.myRowDim;
        final int tmpColDim = this.myColDim;
        if (tmpRowDim - firstRow > HouseholderRight.THRESHOLD) {
            DivideAndConquer tmpConquerer = new DivideAndConquer(){

                @Override
                public void conquer(int aFirst, int aLimit) {
                    HouseholderRight.invoke((Number[])tmpData, (int)aFirst, (int)aLimit, (int)tmpColDim, (Householder.Generic)tmpTransf, GenericDenseStore.this.myFactory.scalar());
                }
            };
            tmpConquerer.invoke(firstRow, tmpRowDim, HouseholderRight.THRESHOLD);
        } else {
            HouseholderRight.invoke((Number[])tmpData, (int)firstRow, (int)tmpRowDim, (int)tmpColDim, tmpTransf, this.myFactory.scalar());
        }
    }

    @Override
    public void transformRight(Rotation<N> transformation) {
        Rotation.Generic<N> tmpTransf = this.cast(transformation);
        int tmpLow = tmpTransf.low;
        int tmpHigh = tmpTransf.high;
        if (tmpLow != tmpHigh) {
            if (tmpTransf.cos != null && tmpTransf.sin != null) {
                RotateRight.invoke((Number[])this.data, (int)this.myRowDim, (int)tmpLow, (int)tmpHigh, tmpTransf.cos, tmpTransf.sin);
            } else {
                this.myUtility.exchangeColumns(tmpLow, tmpHigh);
            }
        } else if (tmpTransf.cos != null) {
            this.myUtility.modifyColumn(0L, tmpHigh, this.myFactory.function().multiply().second(tmpTransf.cos));
        } else if (tmpTransf.sin != null) {
            this.myUtility.modifyColumn(0L, tmpHigh, this.myFactory.function().divide().second(tmpTransf.sin));
        } else {
            this.myUtility.modifyColumn(0L, tmpHigh, this.myFactory.function().negate());
        }
    }

    @Override
    public void transformSymmetric(Householder<N> transformation) {
        HouseholderHermitian.invoke((Number[])this.data, this.cast(transformation), (Number[])this.getWorkerColumn(), this.myFactory.scalar());
    }

    @Override
    public MatrixStore<N> transpose() {
        return new TransposedStore(this);
    }

    @Override
    public void tred2(BasicArray<N> mainDiagonal, BasicArray<N> offDiagonal, boolean yesvecs) {
        ProgrammingError.throwForUnsupportedOptionalOperation();
    }

    @Override
    public void visitColumn(long row, long col, VoidFunction<N> visitor) {
        this.myUtility.visitColumn(row, col, visitor);
    }

    @Override
    public void visitDiagonal(long row, long col, VoidFunction<N> visitor) {
        this.myUtility.visitDiagonal(row, col, visitor);
    }

    @Override
    public void visitRow(long row, long col, VoidFunction<N> visitor) {
        this.myUtility.visitRow(row, col, visitor);
    }

    private GenericDenseStore<N> cast(Access1D<N> matrix) {
        if (matrix instanceof GenericDenseStore) {
            return (GenericDenseStore)matrix;
        }
        if (matrix instanceof Access2D) {
            return this.myFactory.copy((Access2D)matrix);
        }
        return this.myFactory.columns(new Access1D[]{matrix});
    }

    private Householder.Generic<N> cast(Householder<N> transformation) {
        if (transformation instanceof Householder.Generic) {
            return (Householder.Generic)transformation;
        }
        if (transformation instanceof HouseholderReference) {
            return ((Householder.Generic)((HouseholderReference)transformation).getWorker(this.myFactory)).copy(transformation);
        }
        return new Householder.Generic<N>(this.myFactory.scalar(), transformation);
    }

    private Rotation.Generic<N> cast(Rotation<N> transformation) {
        if (transformation instanceof Rotation.Generic) {
            return (Rotation.Generic)transformation;
        }
        return new Rotation.Generic<N>(transformation);
    }

    private N[] getWorkerColumn() {
        if (this.myWorkerColumn == null) {
            this.myWorkerColumn = this.myFactory.scalar().newArrayInstance(this.myRowDim);
        }
        Arrays.fill(this.myWorkerColumn, this.myFactory.scalar().zero().get());
        return this.myWorkerColumn;
    }

    int getColDim() {
        return this.myColDim;
    }

    int getMaxDim() {
        return Math.max(this.myRowDim, this.myColDim);
    }

    int getMinDim() {
        return Math.min(this.myRowDim, this.myColDim);
    }

    int getRowDim() {
        return this.myRowDim;
    }

    static final class Factory<N extends Number>
    implements PhysicalStore.Factory<N, GenericDenseStore<N>> {
        private final DenseArray.Factory<N> myDenseArrayFactory;

        Factory(DenseArray.Factory<N> denseArrayFactory) {
            this.myDenseArrayFactory = denseArrayFactory;
        }

        @Override
        public AggregatorSet<N> aggregator() {
            return this.myDenseArrayFactory.aggregator();
        }

        @Override
        public DenseArray.Factory<N> array() {
            return this.myDenseArrayFactory;
        }

        @Override
        public MatrixStore.Factory<N> builder() {
            return new MatrixStore.Factory<N>(){

                @Override
                public MatrixStore.LogicalBuilder<N> makeIdentity(int dimension) {
                    return new MatrixStore.LogicalBuilder(new IdentityStore(this, dimension));
                }

                @Override
                public MatrixStore.LogicalBuilder<N> makeSingle(N element) {
                    return new MatrixStore.LogicalBuilder(new SingleStore(this, (Number)element));
                }

                @Override
                public MatrixStore.LogicalBuilder<N> makeWrapper(Access2D<?> access) {
                    return new MatrixStore.LogicalBuilder(new WrapperStore(this, access));
                }

                @Override
                public MatrixStore.LogicalBuilder<N> makeZero(int rowsCount, int columnsCount) {
                    return new MatrixStore.LogicalBuilder(new ZeroStore(this, rowsCount, columnsCount));
                }
            };
        }

        @Override
        public GenericDenseStore<N> columns(Access1D<?> ... source) {
            int tmpRowDim = (int)source[0].count();
            int tmpColDim = source.length;
            Number[] tmpData = this.myDenseArrayFactory.scalar().newArrayInstance(tmpRowDim * tmpColDim);
            for (int j = 0; j < tmpColDim; ++j) {
                Access1D<?> tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = this.myDenseArrayFactory.scalar().cast((Number)tmpColumn.get(i));
                }
            }
            return new GenericDenseStore(this, tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public GenericDenseStore<N> columns(double[] ... source) {
            int tmpRowDim = source[0].length;
            int tmpColDim = source.length;
            Number[] tmpData = this.myDenseArrayFactory.scalar().newArrayInstance(tmpRowDim * tmpColDim);
            for (int j = 0; j < tmpColDim; ++j) {
                double[] tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = this.myDenseArrayFactory.scalar().cast(tmpColumn[i]);
                }
            }
            return new GenericDenseStore(this, tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public GenericDenseStore<N> columns(List<? extends Number> ... source) {
            int tmpRowDim = source[0].size();
            int tmpColDim = source.length;
            Number[] tmpData = this.myDenseArrayFactory.scalar().newArrayInstance(tmpRowDim * tmpColDim);
            for (int j = 0; j < tmpColDim; ++j) {
                List<? extends Number> tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = this.myDenseArrayFactory.scalar().cast(tmpColumn.get(i));
                }
            }
            return new GenericDenseStore(this, tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public GenericDenseStore<N> columns(Number[] ... source) {
            int tmpRowDim = source[0].length;
            int tmpColDim = source.length;
            Number[] tmpData = this.myDenseArrayFactory.scalar().newArrayInstance(tmpRowDim * tmpColDim);
            for (int j = 0; j < tmpColDim; ++j) {
                Number[] tmpColumn = source[j];
                for (int i = 0; i < tmpRowDim; ++i) {
                    tmpData[i + tmpRowDim * j] = this.myDenseArrayFactory.scalar().cast(tmpColumn[i]);
                }
            }
            return new GenericDenseStore(this, tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public GenericDenseStore<N> conjugate(final Access2D<?> source) {
            final GenericDenseStore retVal = new GenericDenseStore(this, (int)source.countColumns(), (int)source.countRows());
            final int tmpRowDim = retVal.getRowDim();
            int tmpColDim = retVal.getColDim();
            if (tmpColDim > FillMatchingSingle.THRESHOLD) {
                DivideAndConquer tmpConquerer = new DivideAndConquer(){

                    @Override
                    public void conquer(int aFirst, int aLimit) {
                        FillMatchingSingle.conjugate((Number[])retVal.data, (int)tmpRowDim, (int)aFirst, (int)aLimit, (Access2D)source, myDenseArrayFactory.scalar());
                    }
                };
                tmpConquerer.invoke(0, tmpColDim, FillMatchingSingle.THRESHOLD);
            } else {
                FillMatchingSingle.conjugate((Number[])retVal.data, (int)tmpRowDim, (int)0, (int)tmpColDim, source, this.myDenseArrayFactory.scalar());
            }
            return retVal;
        }

        @Override
        public GenericDenseStore<N> copy(final Access2D<?> source) {
            final int tmpRowDim = (int)source.countRows();
            int tmpColDim = (int)source.countColumns();
            final GenericDenseStore retVal = new GenericDenseStore(this, tmpRowDim, tmpColDim);
            if (tmpColDim > FillMatchingSingle.THRESHOLD) {
                DivideAndConquer tmpConquerer = new DivideAndConquer(){

                    @Override
                    public void conquer(int aFirst, int aLimit) {
                        FillMatchingSingle.copy((Number[])retVal.data, (int)tmpRowDim, (int)aFirst, (int)aLimit, (Access2D)source, myDenseArrayFactory.scalar());
                    }
                };
                tmpConquerer.invoke(0, tmpColDim, FillMatchingSingle.THRESHOLD);
            } else {
                FillMatchingSingle.copy((Number[])retVal.data, (int)tmpRowDim, (int)0, (int)tmpColDim, source, this.myDenseArrayFactory.scalar());
            }
            return retVal;
        }

        @Override
        public FunctionSet<N> function() {
            return this.myDenseArrayFactory.function();
        }

        @Override
        public GenericDenseStore<N> makeEye(long rows, long columns) {
            Structure2D retVal = this.makeZero(rows, columns);
            ((GenericDenseStore)retVal).myUtility.fillDiagonal(0L, 0L, this.myDenseArrayFactory.scalar().one().get());
            return retVal;
        }

        @Override
        public GenericDenseStore<N> makeFilled(long rows, long columns, NullaryFunction<?> supplier) {
            int tmpRowDim = (int)rows;
            int tmpColDim = (int)columns;
            int tmpLength = tmpRowDim * tmpColDim;
            Number[] tmpData = this.myDenseArrayFactory.scalar().newArrayInstance(tmpRowDim * tmpColDim);
            for (int i = 0; i < tmpLength; ++i) {
                tmpData[i] = this.myDenseArrayFactory.scalar().cast((Number)supplier.get());
            }
            return new GenericDenseStore(this, tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public Householder.Generic<N> makeHouseholder(int length) {
            return new Householder.Generic(this.myDenseArrayFactory.scalar(), length);
        }

        @Override
        public Rotation.Generic<N> makeRotation(int low, int high, double cos, double sin) {
            return this.makeRotation(low, high, (Number)this.myDenseArrayFactory.scalar().cast(cos), (Number)this.myDenseArrayFactory.scalar().cast(sin));
        }

        @Override
        public Rotation.Generic<N> makeRotation(int low, int high, N cos, N sin) {
            return new Rotation.Generic<N>(low, high, cos, sin);
        }

        @Override
        public GenericDenseStore<N> makeZero(long rows, long columns) {
            return new GenericDenseStore(this, (int)rows, (int)columns);
        }

        @Override
        public GenericDenseStore<N> rows(Access1D<?> ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = (int)source[0].count();
            Number[] tmpData = this.myDenseArrayFactory.scalar().newArrayInstance(tmpRowDim * tmpColDim);
            for (int i = 0; i < tmpRowDim; ++i) {
                Access1D<?> tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = this.myDenseArrayFactory.scalar().cast((Number)tmpRow.get(j));
                }
            }
            return new GenericDenseStore(this, tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public GenericDenseStore<N> rows(double[] ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = source[0].length;
            Number[] tmpData = this.myDenseArrayFactory.scalar().newArrayInstance(tmpRowDim * tmpColDim);
            for (int i = 0; i < tmpRowDim; ++i) {
                double[] tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = this.myDenseArrayFactory.scalar().cast((Number)tmpRow[j]);
                }
            }
            return new GenericDenseStore(this, tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public GenericDenseStore<N> rows(List<? extends Number> ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = source[0].size();
            Number[] tmpData = this.myDenseArrayFactory.scalar().newArrayInstance(tmpRowDim * tmpColDim);
            for (int i = 0; i < tmpRowDim; ++i) {
                List<? extends Number> tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = this.myDenseArrayFactory.scalar().cast(tmpRow.get(j));
                }
            }
            return new GenericDenseStore(this, tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public GenericDenseStore<N> rows(Number[] ... source) {
            int tmpRowDim = source.length;
            int tmpColDim = source[0].length;
            Number[] tmpData = this.myDenseArrayFactory.scalar().newArrayInstance(tmpRowDim * tmpColDim);
            for (int i = 0; i < tmpRowDim; ++i) {
                Number[] tmpRow = source[i];
                for (int j = 0; j < tmpColDim; ++j) {
                    tmpData[i + tmpRowDim * j] = this.myDenseArrayFactory.scalar().cast(tmpRow[j]);
                }
            }
            return new GenericDenseStore(this, tmpRowDim, tmpColDim, tmpData);
        }

        @Override
        public Scalar.Factory<N> scalar() {
            return this.myDenseArrayFactory.scalar();
        }

        @Override
        public GenericDenseStore<N> transpose(final Access2D<?> source) {
            final GenericDenseStore retVal = new GenericDenseStore(this, (int)source.countColumns(), (int)source.countRows());
            final int tmpRowDim = retVal.getRowDim();
            int tmpColDim = retVal.getColDim();
            if (tmpColDim > FillMatchingSingle.THRESHOLD) {
                DivideAndConquer tmpConquerer = new DivideAndConquer(){

                    @Override
                    public void conquer(int aFirst, int aLimit) {
                        FillMatchingSingle.transpose((Number[])retVal.data, (int)tmpRowDim, (int)aFirst, (int)aLimit, (Access2D)source, myDenseArrayFactory.scalar());
                    }
                };
                tmpConquerer.invoke(0, tmpColDim, FillMatchingSingle.THRESHOLD);
            } else {
                FillMatchingSingle.transpose((Number[])retVal.data, (int)tmpRowDim, (int)0, (int)tmpColDim, source, this.myDenseArrayFactory.scalar());
            }
            return retVal;
        }
    }

    public static interface GenericMultiplyRight<N extends Number> {
        public void invoke(N[] var1, N[] var2, int var3, Access1D<N> var4, Scalar.Factory<N> var5);
    }

    public static interface GenericMultiplyNeither<N extends Number> {
        public void invoke(N[] var1, N[] var2, int var3, N[] var4, Scalar.Factory<N> var5);
    }

    public static interface GenericMultiplyLeft<N extends Number> {
        public void invoke(N[] var1, Access1D<N> var2, int var3, N[] var4, Scalar.Factory<N> var5);
    }

    public static interface GenericMultiplyBoth<N extends Number>
    extends ElementsConsumer.FillByMultiplying<N> {
    }
}

