/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.sgl.Point3;
import edu.mines.jtk.sgl.Tuple4;
import edu.mines.jtk.sgl.Vector3;

public class Point4
extends Tuple4 {
    public Point4() {
        super(0.0, 0.0, 0.0, 1.0);
    }

    public Point4(double x, double y, double z) {
        super(x, y, z, 1.0);
    }

    public Point4(double x, double y, double z, double w) {
        super(x, y, z, w);
    }

    public Point4(Point3 p) {
        super(p.x, p.y, p.z, 1.0);
    }

    public Point4(Point4 p) {
        super(p.x, p.y, p.z, p.w);
    }

    public Point4 homogenize() {
        return new Point4(this.x / this.w, this.y / this.w, this.z / this.w, 1.0);
    }

    public Point4 homogenizeEquals() {
        this.x /= this.w;
        this.y /= this.w;
        this.z /= this.w;
        this.w = 1.0;
        return this;
    }

    public Point4 plus(Vector3 v) {
        return new Point4(this.x + v.x, this.y + v.y, this.z + v.z, this.w);
    }

    public Point4 minus(Vector3 v) {
        return new Point4(this.x - v.x, this.y - v.y, this.z - v.z, this.w);
    }

    public Point4 plusEquals(Vector3 v) {
        this.x += v.x;
        this.y += v.y;
        this.z += v.z;
        return this;
    }

    public Point4 minusEquals(Vector3 v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
        return this;
    }

    public Point4 affine(double a, Point4 q) {
        double b = 1.0 - a;
        Point4 p = this;
        return new Point4(b * p.x + a * q.x, b * p.y + a * q.y, b * p.z + a * q.z, b * p.w + a * q.w);
    }
}

