/*
 * Decompiled with CFR 0.152.
 */
import VolumeJ.VJClassifier;
import VolumeJ.VJClassifierIsosurface;
import VolumeJ.VJClassifierLevoy;
import VolumeJ.VJClassifiers;
import VolumeJ.VJInterpolator;
import VolumeJ.VJIsosurfaceRender;
import VolumeJ.VJLight;
import VolumeJ.VJNearestNeighbor;
import VolumeJ.VJPhongShader;
import VolumeJ.VJRender;
import VolumeJ.VJRenderViewCine;
import VolumeJ.VJRenderViewSingle;
import VolumeJ.VJRenderViewStereo;
import VolumeJ.VJRenderer;
import VolumeJ.VJShader;
import VolumeJ.VJTrilinear;
import VolumeJ.VJUserInterface;
import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.WindowManager;
import ij.plugin.PlugIn;
import volume.Volume;

public class VolumeJ_
implements PlugIn {
    public void run(String arg) {
        String macroOptions = Macro.getOptions();
        if (macroOptions != null) {
            int algorithm = Integer.parseInt(Macro.getValue((String)macroOptions, (String)"algorithm", (String)"0"));
            int mode = Integer.parseInt(Macro.getValue((String)macroOptions, (String)"mode", (String)"0"));
            int interpolation = Integer.parseInt(Macro.getValue((String)macroOptions, (String)"interpolation", (String)"1"));
            int lightx = Integer.parseInt(Macro.getValue((String)macroOptions, (String)"lightx", (String)"0"));
            int lighty = Integer.parseInt(Macro.getValue((String)macroOptions, (String)"lighty", (String)"0"));
            int lightz = Integer.parseInt(Macro.getValue((String)macroOptions, (String)"lightz", (String)"0"));
            double aspectx = Double.parseDouble(Macro.getValue((String)macroOptions, (String)"aspectx", (String)"1"));
            double aspecty = Double.parseDouble(Macro.getValue((String)macroOptions, (String)"aspecty", (String)"1"));
            double aspectz = Double.parseDouble(Macro.getValue((String)macroOptions, (String)"aspectz", (String)"1"));
            double scale = Double.parseDouble(Macro.getValue((String)macroOptions, (String)"scale", (String)"0"));
            double xrot = Double.parseDouble(Macro.getValue((String)macroOptions, (String)"xrot", (String)"0"));
            double yrot = Double.parseDouble(Macro.getValue((String)macroOptions, (String)"yrot", (String)"0"));
            double zrot = Double.parseDouble(Macro.getValue((String)macroOptions, (String)"zrot", (String)"0"));
            int cine = Integer.parseInt(Macro.getValue((String)macroOptions, (String)"cine", (String)"20"));
            int cineN = Integer.parseInt(Macro.getValue((String)macroOptions, (String)"cineN", (String)"1"));
            int classification = Integer.parseInt(Macro.getValue((String)macroOptions, (String)"classification", (String)"0"));
            double threshold = Double.parseDouble(Macro.getValue((String)macroOptions, (String)"threshold", (String)"100"));
            double width = Double.parseDouble(Macro.getValue((String)macroOptions, (String)"width", (String)"5"));
            String text = Macro.getValue((String)macroOptions, (String)"text", (String)"0");
            int cineToDisk = Integer.parseInt(Macro.getValue((String)macroOptions, (String)"cineToDisk", (String)"0"));
            int cineAxis = Integer.parseInt(Macro.getValue((String)macroOptions, (String)"cineAxis", (String)"0"));
            this.run(algorithm, mode, interpolation, lightx, lighty, lightz, aspectx, aspecty, aspectz, scale, xrot, yrot, zrot, cine, cineN, classification, threshold, width, text, cineToDisk, cineAxis);
        } else {
            new VJUserInterface();
        }
    }

    public void run(int algorithm, int mode, int interpolation, int lightx, int lighty, int lightz, double aspectx, double aspecty, double aspectz, double scale, double xrot, double yrot, double zrot, int cine, int cineN, int classification, double threshold, double width, String text, int cineToDisk, int cineAxis) {
        try {
            Object interpolator = null;
            interpolator = interpolation == 1 ? new VJTrilinear() : new VJNearestNeighbor();
            VJLight light = new VJLight((float)lightx, (float)lighty, (float)lightz, 0.9f, 0.0f);
            VJPhongShader shader = new VJPhongShader(0.1f, light, false);
            VJClassifier classifier = VJClassifiers.getClassifier((int)classification);
            if (classifier instanceof VJClassifierIsosurface) {
                ((VJClassifierIsosurface)classifier).setThreshold(threshold);
            }
            if (classifier instanceof VJClassifierLevoy) {
                ((VJClassifierLevoy)classifier).setThreshold(threshold);
                ((VJClassifierLevoy)classifier).setWidth(width);
            }
            VJRender renderer = null;
            if (algorithm == 0) {
                renderer = new VJRender((VJInterpolator)interpolator, (VJShader)shader, classifier);
            } else if (algorithm == 1) {
                renderer = new VJIsosurfaceRender((VJInterpolator)interpolator, (VJShader)shader, classifier);
            }
            if (renderer == null) {
                return;
            }
            ImagePlus imp = WindowManager.getImage((int)0);
            ImagePlus impindex = null;
            Volume v = VJUserInterface.resetVolume((VJRenderer)renderer, (ImagePlus)imp, impindex, (double)aspectx, (double)aspecty, (double)aspectz);
            renderer.setVolume(v);
            VJRenderViewSingle rs = null;
            if (mode == 0) {
                rs = new VJRenderViewSingle((VJRenderer)renderer, scale, xrot, yrot, zrot, text);
            } else if (mode == 1) {
                rs = new VJRenderViewStereo((VJRenderer)renderer, scale, xrot, yrot, zrot, text);
            } else if (mode == 2) {
                rs = new VJRenderViewCine((VJRenderer)renderer, scale, xrot, yrot, zrot, text, cineN / cine, cineToDisk == 1);
                switch (cineAxis) {
                    case 0: {
                        ((VJRenderViewCine)rs).setRotationSteps((float)cine, 0.0f, 0.0f);
                        break;
                    }
                    case 1: {
                        ((VJRenderViewCine)rs).setRotationSteps(0.0f, (float)cine, 0.0f);
                        break;
                    }
                    case 2: {
                        ((VJRenderViewCine)rs).setRotationSteps(0.0f, 0.0f, (float)cine);
                    }
                }
            }
            rs.start();
        }
        catch (Exception e) {
            IJ.write((String)e.getMessage());
        }
    }
}

