/*
 * Decompiled with CFR 0.152.
 */
package bdv.ij;

import bigwarp.BigWarp;
import bigwarp.landmarks.LandmarkTableModel;
import bigwarp.transforms.BigWarpTransform;
import bigwarp.transforms.NgffTransformations;
import bigwarp.transforms.WrappedCoordinateTransform;
import fiji.util.gui.GenericDialogPlus;
import ij.ImageJ;
import ij.plugin.PlugIn;
import java.io.File;
import java.io.IOException;
import mpicbg.models.Model;
import net.imglib2.realtransform.AffineGet;

public class BigWarpTransformExportPlugin
implements PlugIn {
    private boolean promptLandmarks = true;
    private BigWarpTransform bwTransform;

    public static void main(String[] args) {
        new ImageJ();
        new BigWarpTransformExportPlugin().run(null);
    }

    public void runFromBigWarpInstance(BigWarp<?> bw) {
        this.promptLandmarks = false;
        this.bwTransform = bw.getBwTransform();
        this.run(null);
    }

    public void run(String arg) {
        GenericDialogPlus gd = new GenericDialogPlus("Export BigWarp Transformation");
        gd.addMessage("Transformation export:");
        if (this.promptLandmarks) {
            gd.addFileField("landmarks_file", "");
        }
        gd.addChoice("Transform type", new String[]{"Affine", "Similarity", "Rotation", "Translation"}, "Affine");
        gd.addFileField("Output json file or n5", "");
        gd.addStringField("N5 dataset", "");
        gd.addStringField("N5 attribute name", "");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        String landmarksPath = null;
        if (this.promptLandmarks) {
            landmarksPath = gd.getNextString();
        }
        String transformTypeOption = gd.getNextChoice();
        String fileOrN5Root = gd.getNextString();
        String n5Dataset = gd.getNextString();
        String n5Attr = gd.getNextString();
        if (this.bwTransform == null) {
            try {
                LandmarkTableModel ltm = LandmarkTableModel.loadFromCsv(new File(landmarksPath), false);
                this.bwTransform = new BigWarpTransform(ltm, transformTypeOption);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
        String url = fileOrN5Root;
        if (!n5Dataset.isEmpty()) {
            url = url + "?" + n5Dataset;
        }
        if (!n5Attr.isEmpty()) {
            url = url + "#" + n5Attr;
        }
        WrappedCoordinateTransform wct = (WrappedCoordinateTransform)this.bwTransform.getTransformation(false);
        AffineGet affine = this.bwTransform.toImglib2((Model)wct.getTransform());
        NgffTransformations.save(url, NgffTransformations.createAffine(affine));
    }
}

