/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.GsonKeyValueN5Reader;
import org.janelia.saalfeldlab.n5.GsonUtils;
import org.janelia.saalfeldlab.n5.KeyValueAccess;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5URI;
import org.janelia.saalfeldlab.n5.cache.N5JsonCache;
import org.janelia.saalfeldlab.n5.cache.N5JsonCacheableContainer;

public interface CachedGsonKeyValueN5Reader
extends GsonKeyValueN5Reader,
N5JsonCacheableContainer {
    default public N5JsonCache newCache() {
        return new N5JsonCache(this);
    }

    public boolean cacheMeta();

    public N5JsonCache getCache();

    @Override
    default public JsonElement getAttributesFromContainer(String normalPathName, String normalCacheKey) {
        return GsonKeyValueN5Reader.super.getAttributes(normalPathName);
    }

    @Override
    default public DatasetAttributes getDatasetAttributes(String pathName) {
        String normalPath = N5URI.normalizeGroupPath(pathName);
        if (!this.datasetExists(pathName)) {
            return null;
        }
        JsonElement attributes = this.cacheMeta() ? this.getCache().getAttributes(normalPath, "attributes.json") : GsonKeyValueN5Reader.super.getAttributes(normalPath);
        return this.createDatasetAttributes(attributes);
    }

    default public DatasetAttributes normalGetDatasetAttributes(String pathName) throws N5Exception.N5IOException {
        String normalPath = N5URI.normalizeGroupPath(pathName);
        JsonElement attributes = GsonKeyValueN5Reader.super.getAttributes(normalPath);
        return this.createDatasetAttributes(attributes);
    }

    @Override
    default public <T> T getAttribute(String pathName, String key, Class<T> clazz) throws N5Exception {
        String normalPathName = N5URI.normalizeGroupPath(pathName);
        String normalizedAttributePath = N5URI.normalizeAttributePath(key);
        JsonElement attributes = this.cacheMeta() ? this.getCache().getAttributes(normalPathName, "attributes.json") : GsonKeyValueN5Reader.super.getAttributes(normalPathName);
        try {
            return GsonUtils.readAttribute(attributes, normalizedAttributePath, clazz, this.getGson());
        }
        catch (JsonSyntaxException | ClassCastException | NumberFormatException e) {
            throw new N5Exception.N5ClassCastException(e);
        }
    }

    @Override
    default public <T> T getAttribute(String pathName, String key, Type type) throws N5Exception {
        String normalPathName = N5URI.normalizeGroupPath(pathName);
        String normalizedAttributePath = N5URI.normalizeAttributePath(key);
        JsonElement attributes = this.cacheMeta() ? this.getCache().getAttributes(normalPathName, "attributes.json") : GsonKeyValueN5Reader.super.getAttributes(normalPathName);
        try {
            return GsonUtils.readAttribute(attributes, normalizedAttributePath, type, this.getGson());
        }
        catch (JsonSyntaxException | ClassCastException | NumberFormatException e) {
            throw new N5Exception.N5ClassCastException(e);
        }
    }

    @Override
    default public boolean exists(String pathName) {
        String normalPathName = N5URI.normalizeGroupPath(pathName);
        if (this.cacheMeta()) {
            return this.getCache().isGroup(normalPathName, "attributes.json");
        }
        return this.existsFromContainer(normalPathName, null);
    }

    @Override
    default public boolean existsFromContainer(String normalPathName, String normalCacheKey) {
        KeyValueAccess kva = this.getKeyValueAccess();
        if (normalCacheKey == null) {
            return kva.isDirectory(kva.compose(this.getURI(), normalPathName));
        }
        return kva.isFile(kva.compose(this.getURI(), normalPathName, normalCacheKey));
    }

    @Override
    default public boolean groupExists(String pathName) {
        String normalPathName = N5URI.normalizeGroupPath(pathName);
        if (this.cacheMeta()) {
            return this.getCache().isGroup(normalPathName, null);
        }
        return this.isGroupFromContainer(normalPathName);
    }

    @Override
    default public boolean isGroupFromContainer(String normalPathName) {
        return GsonKeyValueN5Reader.super.groupExists(normalPathName);
    }

    @Override
    default public boolean isGroupFromAttributes(String normalCacheKey, JsonElement attributes) {
        return true;
    }

    @Override
    default public boolean datasetExists(String pathName) throws N5Exception.N5IOException {
        String normalPathName = N5URI.normalizeGroupPath(pathName);
        if (this.cacheMeta()) {
            return this.getCache().isDataset(normalPathName, "attributes.json");
        }
        return this.isDatasetFromContainer(normalPathName);
    }

    @Override
    default public boolean isDatasetFromContainer(String normalPathName) throws N5Exception.N5IOException {
        return this.normalGetDatasetAttributes(normalPathName) != null;
    }

    @Override
    default public boolean isDatasetFromAttributes(String normalCacheKey, JsonElement attributes) {
        return this.isGroupFromAttributes(normalCacheKey, attributes) && this.createDatasetAttributes(attributes) != null;
    }

    @Override
    default public JsonElement getAttributes(String pathName) throws N5Exception.N5IOException {
        String groupPath = N5URI.normalizeGroupPath(pathName);
        if (this.cacheMeta()) {
            return this.getCache().getAttributes(groupPath, "attributes.json");
        }
        return GsonKeyValueN5Reader.super.getAttributes(groupPath);
    }

    @Override
    default public String[] list(String pathName) throws N5Exception.N5IOException {
        String normalPath = N5URI.normalizeGroupPath(pathName);
        if (this.cacheMeta()) {
            return this.getCache().list(normalPath);
        }
        return GsonKeyValueN5Reader.super.list(normalPath);
    }

    @Override
    default public String[] listFromContainer(String normalPathName) {
        return GsonKeyValueN5Reader.super.list(normalPathName);
    }

    public static boolean hasDatasetAttributes(JsonElement attributes) {
        if (attributes == null || !attributes.isJsonObject()) {
            return false;
        }
        JsonObject metadataCache = attributes.getAsJsonObject();
        return metadataCache.has("dimensions") && metadataCache.has("dataType");
    }
}

