/*
 * Decompiled with CFR 0.152.
 */
package stacks;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import stacks.ThreePaneCrop;

class CropDialog
extends Dialog
implements ActionListener,
WindowListener {
    Button setFromFields;
    Button setFromThreshold;
    TextField threshold;
    Button cropButton;
    Button cancelButton;
    ThreePaneCrop owner;
    TextField x_min_field;
    TextField y_min_field;
    TextField z_min_field;
    TextField x_max_field;
    TextField y_max_field;
    TextField z_max_field;
    ArrayList<ImagePlus> otherImages = new ArrayList();
    ArrayList<Checkbox> otherImagesCheckboxes = new ArrayList();

    @Override
    public void windowClosing(WindowEvent e) {
        this.owner.cancel();
        this.dispose();
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    public CropDialog(String title, ThreePaneCrop owner) {
        super((Frame)IJ.getInstance(), title, false);
        this.x_min_field = new TextField("", 4);
        this.y_min_field = new TextField("", 4);
        this.z_min_field = new TextField("", 4);
        this.x_max_field = new TextField("", 4);
        this.y_max_field = new TextField("", 4);
        this.z_max_field = new TextField("", 4);
        this.addWindowListener(this);
        this.owner = owner;
        this.setLayout(new GridBagLayout());
        GridBagConstraints co = new GridBagConstraints();
        Panel parametersPanel = new Panel();
        parametersPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.gridwidth = 5;
        parametersPanel.add((Component)new Label("Current Crop Boundaries (Maxima)"), c);
        c.gridwidth = 1;
        c.gridy = 1;
        c.gridx = 0;
        parametersPanel.add((Component)new Label("x from "), c);
        c.gridx = 1;
        parametersPanel.add((Component)this.x_min_field, c);
        c.gridx = 2;
        parametersPanel.add((Component)new Label(" (" + owner.overall_min_x + ")  to "), c);
        c.gridx = 3;
        parametersPanel.add((Component)this.x_max_field, c);
        c.gridx = 4;
        parametersPanel.add((Component)new Label(" (" + owner.overall_max_x + ")"), c);
        c.gridy = 2;
        c.gridx = 0;
        parametersPanel.add((Component)new Label("y from "), c);
        c.gridx = 1;
        parametersPanel.add((Component)this.y_min_field, c);
        c.gridx = 2;
        parametersPanel.add((Component)new Label(" (" + owner.overall_min_y + ")  to "), c);
        c.gridx = 3;
        parametersPanel.add((Component)this.y_max_field, c);
        c.gridx = 4;
        parametersPanel.add((Component)new Label(" (" + owner.overall_max_y + ")"), c);
        c.gridy = 3;
        c.gridx = 0;
        parametersPanel.add((Component)new Label("z from "), c);
        c.gridx = 1;
        parametersPanel.add((Component)this.z_min_field, c);
        c.gridx = 2;
        parametersPanel.add((Component)new Label(" (" + (owner.overall_min_z + 1) + ")  to "), c);
        c.gridx = 3;
        parametersPanel.add((Component)this.z_max_field, c);
        c.gridx = 4;
        parametersPanel.add((Component)new Label(" (" + (owner.overall_max_z + 1) + ")"), c);
        Panel fieldsOptionsPanel = new Panel();
        fieldsOptionsPanel.setLayout(new GridBagLayout());
        GridBagConstraints cf = new GridBagConstraints();
        this.setFromFields = new Button("Set from fields above");
        this.setFromFields.addActionListener(this);
        cf.gridx = 0;
        cf.gridy = 0;
        cf.gridwidth = 2;
        co.anchor = 21;
        fieldsOptionsPanel.add((Component)this.setFromFields, cf);
        this.setFromThreshold = new Button("Set crop above value: ");
        this.setFromThreshold.addActionListener(this);
        this.threshold = new TextField("50");
        cf.gridx = 0;
        cf.gridy = 1;
        cf.gridwidth = 1;
        co.anchor = 21;
        fieldsOptionsPanel.add((Component)this.setFromThreshold, cf);
        cf.gridx = 1;
        cf.gridy = 1;
        cf.gridwidth = 1;
        fieldsOptionsPanel.add((Component)this.threshold, cf);
        Panel otherImagesPanel = new Panel();
        otherImagesPanel.setLayout(new GridBagLayout());
        GridBagConstraints cw = new GridBagConstraints();
        int[] wList = WindowManager.getIDList();
        if (wList != null) {
            cw.gridx = 0;
            cw.gridy = 0;
            cw.anchor = 21;
            otherImagesPanel.add(new Label("Also crop these images:"));
            ++cw.gridy;
            for (int i = 0; i < wList.length; ++i) {
                ImagePlus imp = WindowManager.getImage((int)wList[i]);
                if (imp.getWidth() != owner.overall_max_x + 1 || imp.getHeight() != owner.overall_max_y + 1 || imp.getStackSize() != owner.overall_max_z + 1 || imp == owner.xy) continue;
                this.otherImages.add(imp);
                Checkbox checkbox = new Checkbox(imp.getTitle());
                otherImagesPanel.add((Component)checkbox, cw);
                ++cw.gridy;
                this.otherImagesCheckboxes.add(checkbox);
            }
        }
        Panel buttonPanel = new Panel();
        buttonPanel.setLayout(new FlowLayout());
        this.cropButton = new Button("Crop");
        this.cropButton.addActionListener(this);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.cropButton);
        buttonPanel.add(this.cancelButton);
        co.gridx = 0;
        this.add((Component)parametersPanel, co);
        co.gridx = 0;
        co.gridy = 1;
        co.anchor = 21;
        this.add((Component)fieldsOptionsPanel, co);
        co.gridx = 0;
        co.gridy = 2;
        this.add((Component)otherImagesPanel, co);
        co.gridx = 0;
        co.gridy = 3;
        co.anchor = 10;
        this.add((Component)buttonPanel, co);
        co.gridx = 0;
        co.gridy = 4;
        this.add((Component)new Label("(Move mouse with shift to update panes.)"), co);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.cropButton) {
            ArrayList<ImagePlus> toCrop = new ArrayList<ImagePlus>();
            toCrop.add(this.owner.xy);
            for (int i = 0; i < this.otherImagesCheckboxes.size(); ++i) {
                Checkbox c = this.otherImagesCheckboxes.get(i);
                if (!c.getState()) continue;
                toCrop.add(this.otherImages.get(i));
            }
            this.owner.performMultipleCrops(toCrop);
        } else if (source == this.cancelButton) {
            this.owner.cancel();
            this.dispose();
        } else if (source == this.setFromFields) {
            this.setFromFields();
        } else if (source == this.setFromThreshold) {
            this.setFromThreshold();
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    public void updateCropBounds(int min_x, int max_x, int min_y, int max_y, int min_z, int max_z) {
        this.x_min_field.setText(Integer.toString(min_x));
        this.x_max_field.setText(Integer.toString(max_x));
        this.y_min_field.setText(Integer.toString(min_y));
        this.y_max_field.setText(Integer.toString(max_y));
        this.z_min_field.setText(Integer.toString(min_z + 1));
        this.z_max_field.setText(Integer.toString(max_z + 1));
    }

    public void setFromThreshold() {
        double t;
        try {
            String threshold_s = this.threshold.getText();
            t = Double.parseDouble(threshold_s);
        }
        catch (NumberFormatException e) {
            IJ.error((String)"The threshold must be a number.");
            return;
        }
        this.owner.setCropAbove(t);
    }

    public void setFromFields() {
        int new_z_max;
        int new_z_min;
        int new_y_max;
        int new_y_min;
        int new_x_max;
        int new_x_min;
        try {
            String x_min_string = this.x_min_field.getText();
            new_x_min = Integer.parseInt(x_min_string);
            String x_max_string = this.x_max_field.getText();
            new_x_max = Integer.parseInt(x_max_string);
            String y_min_string = this.y_min_field.getText();
            new_y_min = Integer.parseInt(y_min_string);
            String y_max_string = this.y_max_field.getText();
            new_y_max = Integer.parseInt(y_max_string);
            String z_min_string = this.z_min_field.getText();
            new_z_min = Integer.parseInt(z_min_string);
            String z_max_string = this.z_max_field.getText();
            new_z_max = Integer.parseInt(z_max_string);
        }
        catch (NumberFormatException e) {
            IJ.error((String)"The fields must all be integers.");
            return;
        }
        --new_z_min;
        --new_z_max;
        if (new_x_max < new_x_min) {
            IJ.error((String)"The maximum x must be >= the minimum x.");
            return;
        }
        if (new_y_max < new_y_min) {
            IJ.error((String)"The maximum y must be >= the minimum y.");
            return;
        }
        if (new_z_max < new_z_min) {
            IJ.error((String)"The maximum z must be >= the minimum z.");
            return;
        }
        if (new_x_min < this.owner.overall_min_x || new_x_min > this.owner.overall_max_x) {
            IJ.error((String)("The minimum x must be between " + this.owner.overall_min_x + " and " + this.owner.overall_max_x + " inclusive."));
            return;
        }
        if (new_x_max < this.owner.overall_min_x || new_x_max > this.owner.overall_max_x) {
            IJ.error((String)("The maximum x must be between " + this.owner.overall_min_x + " and " + this.owner.overall_max_x + " inclusive."));
            return;
        }
        if (new_y_min < this.owner.overall_min_y || new_y_min > this.owner.overall_max_y) {
            IJ.error((String)("The minimum y must be between " + this.owner.overall_min_y + " and " + this.owner.overall_max_y + " inclusive."));
            return;
        }
        if (new_y_max < this.owner.overall_min_y || new_y_max > this.owner.overall_max_y) {
            IJ.error((String)("The maximum y must be between " + this.owner.overall_min_y + " and " + this.owner.overall_max_y + " inclusive."));
            return;
        }
        if (new_z_min < this.owner.overall_min_z || new_z_min > this.owner.overall_max_z) {
            IJ.error((String)("The minimum z must be between " + this.owner.overall_min_z + " and " + this.owner.overall_max_z + " inclusive."));
            return;
        }
        if (new_z_max < this.owner.overall_min_z || new_z_max > this.owner.overall_max_z) {
            IJ.error((String)("The maximum z must be between " + this.owner.overall_min_z + " and " + this.owner.overall_max_z + " inclusive."));
            return;
        }
        this.owner.setCropCuboid(new_x_min, new_x_max, new_y_min, new_y_max, new_z_min, new_z_max);
        this.owner.repaintAllPanes();
    }
}

