/*
 * Decompiled with CFR 0.152.
 */
package stacks;

import ij.ImagePlus;
import ij.gui.ImageCanvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import stacks.PaneOwner;

public class ThreePanesCanvas
extends ImageCanvas {
    protected PaneOwner owner;
    protected int plane;
    private double current_x;
    private double current_y;
    private double current_z;
    boolean draw_crosshairs;

    protected ThreePanesCanvas(ImagePlus imagePlus, PaneOwner owner, int plane) {
        super(imagePlus);
        this.owner = owner;
        this.plane = plane;
    }

    protected ThreePanesCanvas(ImagePlus imagePlus, int plane) {
        super(imagePlus);
        this.plane = plane;
    }

    public static Object newThreePanesCanvas(ImagePlus imagePlus, PaneOwner owner, int plane) {
        return new ThreePanesCanvas(imagePlus, owner, plane);
    }

    public void setPaneOwner(PaneOwner owner) {
        this.owner = owner;
    }

    protected void drawOverlay(Graphics g) {
        if (this.draw_crosshairs) {
            int ix = (int)Math.round(this.current_x);
            int iy = (int)Math.round(this.current_y);
            int iz = (int)Math.round(this.current_z);
            if (this.plane == 0) {
                int x = this.myScreenXD(this.current_x);
                int y = this.myScreenYD(this.current_y);
                this.drawCrosshairs(g, Color.red, x, y);
            } else if (this.plane == 1) {
                int x = this.myScreenXD(this.current_x);
                int y = this.myScreenYD(this.current_z);
                this.drawCrosshairs(g, Color.red, x, y);
            } else if (this.plane == 2) {
                int x = this.myScreenXD(this.current_z);
                int y = this.myScreenYD(this.current_y);
                this.drawCrosshairs(g, Color.red, x, y);
            }
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.drawOverlay(g);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        super.mouseMoved(e);
        double off_screen_x = this.offScreenX(e.getX());
        double off_screen_y = this.offScreenY(e.getY());
        boolean shift_key_down = (e.getModifiersEx() & 0x40) != 0;
        this.owner.mouseMovedTo((int)off_screen_x, (int)off_screen_y, this.plane, shift_key_down);
    }

    public void realZoom(boolean in, int x, int y) {
        if (in) {
            super.zoomIn(this.screenX(x), this.screenY(y));
        } else {
            super.zoomOut(this.screenX(x), this.screenY(y));
        }
    }

    public void zoomIn(int sx, int sy) {
        this.owner.zoom(true, this.offScreenX(sx), this.offScreenY(sy), this.plane);
    }

    public void zoomOut(int sx, int sy) {
        this.owner.zoom(false, this.offScreenX(sx), this.offScreenY(sy), this.plane);
    }

    protected void drawCrosshairs(Graphics g, Color c, int x_on_screen, int y_on_screen) {
        g.setColor(c);
        int hairLength = 8;
        g.drawLine(x_on_screen, y_on_screen + 1, x_on_screen, y_on_screen + (hairLength - 1));
        g.drawLine(x_on_screen, y_on_screen - 1, x_on_screen, y_on_screen - (hairLength - 1));
        g.drawLine(x_on_screen + 1, y_on_screen, x_on_screen + (hairLength - 1), y_on_screen);
        g.drawLine(x_on_screen - 1, y_on_screen, x_on_screen - (hairLength - 1), y_on_screen);
    }

    public void setCrosshairs(double x, double y, double z, boolean display) {
        this.current_x = x;
        this.current_y = y;
        this.current_z = z;
        this.draw_crosshairs = display;
    }

    public int myOffScreenX(int sx) {
        return this.srcRect.x + (int)(((double)sx - this.magnification / 2.0) / this.magnification);
    }

    public int myOffScreenY(int sy) {
        return this.srcRect.y + (int)(((double)sy - this.magnification / 2.0) / this.magnification);
    }

    public double myOffScreenXD(int sx) {
        return (double)this.srcRect.x + ((double)sx - this.magnification / 2.0) / this.magnification;
    }

    public double myOffScreenYD(int sy) {
        return (double)this.srcRect.y + ((double)sy - this.magnification / 2.0) / this.magnification;
    }

    public int myScreenX(int ox) {
        return (int)Math.round((double)(ox - this.srcRect.x) * this.magnification + this.magnification / 2.0);
    }

    public int myScreenY(int oy) {
        return (int)Math.round((double)(oy - this.srcRect.y) * this.magnification + this.magnification / 2.0);
    }

    public int myScreenXD(double ox) {
        return (int)Math.round((ox - (double)this.srcRect.x) * this.magnification + this.magnification / 2.0);
    }

    public int myScreenYD(double oy) {
        return (int)Math.round((oy - (double)this.srcRect.y) * this.magnification + this.magnification / 2.0);
    }
}

