/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.action;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.Settings;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.action.AbstractTMAction;
import fiji.plugin.trackmate.action.TrackMateAction;
import fiji.plugin.trackmate.action.TrackMateActionFactory;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.io.IOUtils;
import java.awt.Frame;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.scijava.plugin.Plugin;

public class ISBIChallengeExporter
extends AbstractTMAction {
    public static final String NAME = "Export to ISBI challenge file format";
    public static final String KEY = "EXPORT_TO_ISBI_CHALLENGE_FORMAT";
    public static final String INFO_TEXT = "<html>Export the current model content to a XML file following the ISBI 2012 single particle tracking challenge format, as specified on <a href='http://bioimageanalysis.org/track/'></a>. <p> Only tracks are exported. If there is no track, this action does nothing. </html>";
    private static final String CONTENT_KEY = "TrackContestISBI2012";
    private static final String DATE_ATT = "generationDateTime";
    private static final String SNR_ATT = "snr";
    private static final String DENSITY_ATT = "density";
    private static final String SCENARIO_ATT = "scenario";
    private static final String TRACK_KEY = "particle";
    private static final String SPOT_KEY = "detection";
    private static final String X_ATT = "x";
    private static final String Y_ATT = "y";
    private static final String Z_ATT = "z";
    private static final String T_ATT = "t";

    @Override
    public void execute(TrackMate trackmate, SelectionModel selectionModel, DisplaySettings displaySettings, Frame parent) {
        File file;
        this.logger.log("Exporting tracks to ISBI challenge file format.\n");
        Model model = trackmate.getModel();
        File folder = new File(System.getProperty("user.dir")).getParentFile().getParentFile();
        try {
            String filename = trackmate.getSettings().imageFileName;
            filename = filename.substring(0, filename.indexOf("."));
            file = new File(folder.getPath() + File.separator + filename + "_ISBI.xml");
        }
        catch (NullPointerException npe) {
            file = new File(folder.getPath() + File.separator + "ISBIChallenge2012Result.xml");
        }
        file = IOUtils.askForFileForSaving(file, parent);
        if (null == file) {
            this.logger.log("Exporting to ISBI file format aborted.\n");
            return;
        }
        ISBIChallengeExporter.exportToFile(model, trackmate.getSettings(), file, this.logger);
    }

    public static void exportToFile(Model model, Settings settings, File file) {
        ISBIChallengeExporter.exportToFile(model, settings, file, model.getLogger());
    }

    public static void exportToFile(Model model, Settings settings, File file, Logger logger) {
        logger.log("Exporting to ISBI 2012 particle tracking challenge format.\n");
        int ntracks = model.getTrackModel().nTracks(true);
        if (ntracks == 0) {
            logger.log("No visible track found. Aborting.\n");
            return;
        }
        logger.log("  Preparing XML data.\n");
        Element root = ISBIChallengeExporter.marshall(model, settings);
        logger.log("  Writing to file.\n");
        Document document = new Document(root);
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        try {
            outputter.output(document, (OutputStream)new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            logger.error("Trouble writing to " + String.valueOf(file) + ":\n" + e.getMessage());
        }
        catch (IOException e) {
            logger.error("Trouble writing to " + String.valueOf(file) + ":\n" + e.getMessage());
        }
        logger.log("Done.\n");
    }

    private static final Element marshall(Model model, Settings settings) {
        String density_val;
        String snr_val;
        String scenario_val;
        Logger logger = model.getLogger();
        Element root = new Element("root");
        Element content = new Element(CONTENT_KEY);
        String filename = settings.imageFileName;
        String pattern = "^(\\w+) snr (\\d+) density (\\w+)\\.";
        Pattern r = Pattern.compile("^(\\w+) snr (\\d+) density (\\w+)\\.");
        Matcher m = r.matcher(filename);
        if (m.find()) {
            scenario_val = m.group(1);
            snr_val = m.group(2);
            density_val = m.group(3);
        } else {
            scenario_val = filename;
            snr_val = "?";
            density_val = "?";
        }
        content.setAttribute(SNR_ATT, snr_val);
        content.setAttribute(DENSITY_ATT, density_val);
        content.setAttribute(SCENARIO_ATT, scenario_val);
        content.setAttribute(DATE_ATT, new Date().toString());
        logger.setStatus("Marshalling...");
        Integer[] visibleTracks = model.getTrackModel().trackIDs(true).toArray(new Integer[0]);
        for (int i = 0; i < model.getTrackModel().nTracks(true); ++i) {
            Element trackElement = new Element(TRACK_KEY);
            int trackindex = visibleTracks[i];
            Set<Spot> track = model.getTrackModel().trackSpots(trackindex);
            TreeSet<Spot> sortedTrack = new TreeSet<Spot>(Spot.timeComparator);
            sortedTrack.addAll(track);
            for (Spot spot : sortedTrack) {
                int t = spot.getFeature("FRAME").intValue();
                double x = spot.getFeature("POSITION_X");
                double y = spot.getFeature("POSITION_Y");
                double z = spot.getFeature("POSITION_Z");
                Element spotElement = new Element(SPOT_KEY);
                spotElement.setAttribute(T_ATT, "" + t);
                spotElement.setAttribute(X_ATT, "" + x);
                spotElement.setAttribute(Y_ATT, "" + y);
                spotElement.setAttribute(Z_ATT, "" + z);
                trackElement.addContent((Content)spotElement);
            }
            content.addContent((Content)trackElement);
            logger.setProgress((double)i / (0.0 + (double)model.getTrackModel().nTracks(true)));
        }
        logger.setStatus("");
        logger.setProgress(1.0);
        root.addContent((Content)content);
        return root;
    }

    @Plugin(type=TrackMateActionFactory.class, visible=true)
    public static class Factory
    implements TrackMateActionFactory {
        @Override
        public String getInfoText() {
            return ISBIChallengeExporter.INFO_TEXT;
        }

        @Override
        public String getName() {
            return ISBIChallengeExporter.NAME;
        }

        @Override
        public String getKey() {
            return ISBIChallengeExporter.KEY;
        }

        @Override
        public ImageIcon getIcon() {
            return Icons.ISBI_ICON;
        }

        @Override
        public TrackMateAction create() {
            return new ISBIChallengeExporter();
        }
    }
}

