/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.features.track;

import fiji.plugin.trackmate.Dimension;
import fiji.plugin.trackmate.FeatureModel;
import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.features.track.AbstractTrackAnalyzer;
import fiji.plugin.trackmate.features.track.TrackAnalyzer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.scijava.plugin.Plugin;

@Plugin(type=TrackAnalyzer.class)
public class TrackLocationAnalyzer
extends AbstractTrackAnalyzer {
    public static final String KEY = "Track location";
    public static final String X_LOCATION = "TRACK_X_LOCATION";
    public static final String Y_LOCATION = "TRACK_Y_LOCATION";
    public static final String Z_LOCATION = "TRACK_Z_LOCATION";
    public static final List<String> FEATURES = new ArrayList<String>(3);
    public static final Map<String, String> FEATURE_NAMES = new HashMap<String, String>(3);
    public static final Map<String, String> FEATURE_SHORT_NAMES = new HashMap<String, String>(3);
    public static final Map<String, Dimension> FEATURE_DIMENSIONS = new HashMap<String, Dimension>(3);
    public static final Map<String, Boolean> IS_INT = new HashMap<String, Boolean>(3);

    public TrackLocationAnalyzer() {
        super(KEY, KEY, FEATURES, FEATURE_NAMES, FEATURE_SHORT_NAMES, FEATURE_DIMENSIONS, IS_INT);
    }

    @Override
    protected void analyze(Integer trackID, Model model) {
        FeatureModel fm = model.getFeatureModel();
        Set<Spot> track = model.getTrackModel().trackSpots(trackID);
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (Spot spot : track) {
            x += spot.getFeature("POSITION_X").doubleValue();
            y += spot.getFeature("POSITION_Y").doubleValue();
            z += spot.getFeature("POSITION_Z").doubleValue();
        }
        int nspots = track.size();
        fm.putTrackFeature(trackID, X_LOCATION, x /= (double)nspots);
        fm.putTrackFeature(trackID, Y_LOCATION, y /= (double)nspots);
        fm.putTrackFeature(trackID, Z_LOCATION, z /= (double)nspots);
    }

    static {
        FEATURES.add(X_LOCATION);
        FEATURES.add(Y_LOCATION);
        FEATURES.add(Z_LOCATION);
        FEATURE_NAMES.put(X_LOCATION, "Track mean X");
        FEATURE_NAMES.put(Y_LOCATION, "Track mean Y");
        FEATURE_NAMES.put(Z_LOCATION, "Track mean Z");
        FEATURE_SHORT_NAMES.put(X_LOCATION, "Track X");
        FEATURE_SHORT_NAMES.put(Y_LOCATION, "Track Y");
        FEATURE_SHORT_NAMES.put(Z_LOCATION, "Track Z");
        FEATURE_DIMENSIONS.put(X_LOCATION, Dimension.POSITION);
        FEATURE_DIMENSIONS.put(Y_LOCATION, Dimension.POSITION);
        FEATURE_DIMENSIONS.put(Z_LOCATION, Dimension.POSITION);
        IS_INT.put(X_LOCATION, Boolean.FALSE);
        IS_INT.put(Y_LOCATION, Boolean.FALSE);
        IS_INT.put(Z_LOCATION, Boolean.FALSE);
    }
}

