/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.components;

import fiji.plugin.trackmate.Logger;
import fiji.plugin.trackmate.SelectionModel;
import fiji.plugin.trackmate.TrackMate;
import fiji.plugin.trackmate.action.TrackMateAction;
import fiji.plugin.trackmate.action.TrackMateActionFactory;
import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.gui.Icons;
import fiji.plugin.trackmate.gui.components.LogPanel;
import fiji.plugin.trackmate.gui.components.ModuleChooserPanel;
import fiji.plugin.trackmate.gui.displaysettings.DisplaySettings;
import fiji.plugin.trackmate.providers.ActionProvider;
import fiji.plugin.trackmate.util.Threads;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ActionChooserPanel
extends ModuleChooserPanel<TrackMateActionFactory> {
    private static final long serialVersionUID = 1L;

    public ActionChooserPanel(final ActionProvider actionProvider, final TrackMate trackmate, final SelectionModel selectionModel, final DisplaySettings displaySettings) {
        super(actionProvider, "action", "CAPTURE_OVERLAY");
        GridBagLayout gridBagLayout = (GridBagLayout)this.getLayout();
        gridBagLayout.rowHeights = new int[]{16, 27, 209, 200};
        LogPanel logPanel = new LogPanel();
        GridBagConstraints gbcLogPanel = new GridBagConstraints();
        gbcLogPanel.insets = new Insets(5, 5, 5, 5);
        gbcLogPanel.fill = 1;
        gbcLogPanel.gridx = 0;
        gbcLogPanel.gridy = 3;
        this.add((Component)logPanel, gbcLogPanel);
        final JButton executeButton = new JButton("Execute", Icons.EXECUTE_ICON);
        executeButton.setFont(Fonts.FONT);
        GridBagConstraints gbcExecBtn = new GridBagConstraints();
        gbcExecBtn.insets = new Insets(5, 5, 5, 5);
        gbcExecBtn.fill = 0;
        gbcExecBtn.anchor = 13;
        gbcExecBtn.gridx = 0;
        gbcExecBtn.gridy = 4;
        this.add((Component)executeButton, gbcExecBtn);
        final Logger logger = logPanel.getLogger();
        executeButton.addActionListener(new ActionListener(){
            final /* synthetic */ ActionChooserPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Threads.run("TrackMate action thread", () -> {
                    try {
                        executeButton.setEnabled(false);
                        String actionKey = this.this$0.getSelectedModuleKey();
                        TrackMateAction action = ((TrackMateActionFactory)actionProvider.getFactory(actionKey)).create();
                        if (null == action) {
                            logger.error("Unknown action: " + actionKey + ".\n");
                        } else {
                            action.setLogger(logger);
                            action.execute(trackmate, selectionModel, displaySettings, (JFrame)SwingUtilities.getWindowAncestor(this.this$0));
                        }
                    }
                    finally {
                        executeButton.setEnabled(true);
                    }
                });
            }
        });
    }
}

