/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.gui.editor.labkit.component;

import fiji.plugin.trackmate.gui.GuiUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.roi.IterableRegion;
import net.imglib2.type.logic.BitType;
import net.imglib2.util.Intervals;
import org.scijava.ui.behaviour.util.RunnableAction;
import sc.fiji.labkit.ui.labeling.Label;
import sc.fiji.labkit.ui.labeling.Labeling;
import sc.fiji.labkit.ui.models.Holder;
import sc.fiji.labkit.ui.models.LabelingModel;

public class TMLabelPanel
extends JPanel {
    public static final int CELL_HEIGHT = 30;
    private final LabelingModel model;
    private final MyListModel listModel;
    private static final long serialVersionUID = 1L;

    public TMLabelPanel(LabelingModel model) {
        super(new BorderLayout());
        this.model = model;
        this.listModel = new MyListModel((Holder<Labeling>)model.labeling());
        final JList<Label> list = new JList<Label>(this.listModel);
        list.setCellRenderer(new LabelListCellRenderer());
        list.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        list.addListSelectionListener(e -> {
            Label l;
            if (!e.getValueIsAdjusting() && (l = (Label)list.getSelectedValue()) != null) {
                model.selectedLabel().set((Object)l);
                list.repaint();
            }
        });
        list.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ TMLabelPanel this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.isShiftDown()) {
                    int index = list.locationToIndex(e.getPoint());
                    list.setSelectedIndex(index);
                    e.consume();
                    Label label = (Label)list.getModel().getElementAt(index);
                    this.this$0.localizeLabel(label);
                }
            }
        });
        model.selectedLabel().notifier().addListener(() -> {
            Label label = (Label)model.selectedLabel().get();
            int i = ((Labeling)model.labeling().get()).getLabels().indexOf(label);
            if (i < 0) {
                return;
            }
            int w = this.getWidth();
            int h = 30;
            int y = 30 * i;
            Rectangle rectangle = new Rectangle(0, y, w, 30);
            list.scrollRectToVisible(rectangle);
            list.repaint();
        });
        JScrollPane scrollPane = new JScrollPane(list);
        list.setOpaque(false);
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setBorder(null);
        this.add((Component)scrollPane, "Center");
        this.add((Component)this.initializeAddLabelButton(), "South");
        this.setPreferredSize(new Dimension(150, 150));
        this.setMinimumSize(new Dimension(150, 150));
    }

    private void addLabel() {
        Holder holder = this.model.labeling();
        Labeling labeling = (Labeling)holder.get();
        String newName = TMLabelPanel.suggestName(labeling.getLabels().stream().map(Label::name).collect(Collectors.toList()));
        if (newName == null) {
            return;
        }
        Label newLabel = labeling.addLabel(newName);
        this.model.selectedLabel().set((Object)newLabel);
        this.listModel.notifyElementAdded();
        this.model.labeling().notifier().notifyListeners();
    }

    public void localizeLabel(Label label) {
        Interval interval = TMLabelPanel.getBoundingBox((IterableRegion<BitType>)((IterableRegion)((Labeling)this.model.labeling().get()).iterableRegions().get(label)));
        if (interval == null) {
            return;
        }
        interval = Intervals.expand((Interval)interval, (long)Math.max(interval.dimension(0), 20L), (int)0);
        interval = Intervals.expand((Interval)interval, (long)Math.max(interval.dimension(1), 20L), (int)1);
        this.model.transformationModel().transformToShowInterval(interval, this.model.labelTransformation());
    }

    private static Interval getBoundingBox(IterableRegion<BitType> region) {
        int numDimensions = region.numDimensions();
        Cursor cursor = region.inside().cursor();
        if (!cursor.hasNext()) {
            return null;
        }
        long[] min = new long[numDimensions];
        long[] max = new long[numDimensions];
        cursor.fwd();
        cursor.localize(min);
        cursor.localize(max);
        while (cursor.hasNext()) {
            cursor.fwd();
            for (int i = 0; i < numDimensions; ++i) {
                int pos = cursor.getIntPosition(i);
                min[i] = Math.min(min[i], (long)pos);
                max[i] = Math.max(max[i], (long)pos);
            }
        }
        return new FinalInterval(min, max);
    }

    private JButton initializeAddLabelButton() {
        RunnableAction addLabelAction = new RunnableAction("Add label", this::addLabel);
        JButton button = sc.fiji.labkit.ui.panel.GuiUtils.createActionIconButton((String)"Add label", (Action)addLabelAction, (String)"add.png");
        button.getInputMap(2).put(KeyStroke.getKeyStroke("ctrl A"), "create new label");
        button.getActionMap().put("create new label", (Action)addLabelAction);
        button.setToolTipText("<html><small>Keyboard shortcut:</small></html>");
        return button;
    }

    private static String suggestName(List<String> labels) {
        for (int i = 1; i < 10000; ++i) {
            String label = "Label_" + i;
            if (labels.contains(label)) continue;
            return label;
        }
        return null;
    }

    private static final class MyListModel
    extends AbstractListModel<Label> {
        private static final long serialVersionUID = 1L;
        private final Holder<Labeling> labeling;

        public MyListModel(Holder<Labeling> labeling) {
            this.labeling = labeling;
        }

        @Override
        public Label getElementAt(int index) {
            return (Label)((Labeling)this.labeling.get()).getLabels().get(index);
        }

        @Override
        public int getSize() {
            return ((Labeling)this.labeling.get()).getLabels().size();
        }

        public void notifyElementAdded() {
            int n = this.getSize() - 1;
            this.fireIntervalAdded(this, n, n);
        }
    }

    private class LabelListCellRenderer
    extends JLabel
    implements ListCellRenderer<Label> {
        private static final long serialVersionUID = 1L;
        private final Dimension preferredSize;
        private final Color bg;
        private final CompoundBorder border;

        public LabelListCellRenderer() {
            super("", 0);
            Font smallerFont = this.getFont().deriveFont((float)this.getFont().getSize() - 4.0f);
            this.setFont(smallerFont);
            this.preferredSize = super.getPreferredSize();
            this.preferredSize.height = 30;
            this.bg = UIManager.getColor("Panel.background");
            Border black = BorderFactory.createLineBorder(this.bg, 4, true);
            Border white = BorderFactory.createLineBorder(Color.BLACK, 4, true);
            this.border = BorderFactory.createCompoundBorder(black, white);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Label> list, Label label, int index, boolean isSelected, boolean cellHasFocus) {
            this.setText(label.name());
            Color bg = new Color(label.color().get());
            Color fg = bg == null ? null : GuiUtils.textColorForBackground(bg);
            this.setOpaque(true);
            this.setBackground(bg);
            this.setForeground(fg);
            boolean selected = ((Label)TMLabelPanel.this.model.selectedLabel().get()).equals(label);
            if (selected) {
                this.setFont(this.getFont().deriveFont(1));
                this.setBorder(this.border);
            } else {
                this.setFont(this.getFont().deriveFont(0));
                this.setBorder(null);
            }
            return this;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(this.bg);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            super.paintComponent(g);
            g2d.setColor(this.bg);
            g2d.drawRect(0, 0, this.getWidth(), this.getHeight());
            g2d.drawRect(1, 1, this.getWidth() - 1, this.getHeight() - 1);
            g2d.drawRoundRect(1, 1, this.getWidth() - 1, this.getHeight() - 1, 5, 5);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.preferredSize;
        }
    }
}

