/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin.trackmate.visualization.trackscheme.utils;

import fiji.plugin.trackmate.Model;
import fiji.plugin.trackmate.Spot;
import fiji.plugin.trackmate.gui.Fonts;
import fiji.plugin.trackmate.visualization.TrackMateModelView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.font.TextAttribute;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JTextField;

public class SearchBar
extends JTextField {
    private static final long serialVersionUID = 1L;
    private static final Font NORMAL_FONT = Fonts.FONT.deriveFont(10.0f);
    private static final Font NOTFOUND_FONT;
    private final PropertyChangeSupport observer = new PropertyChangeSupport(this);
    private final Model model;
    private final TrackMateModelView view;

    public SearchBar(Model model, TrackMateModelView view) {
        this.model = model;
        this.view = view;
        this.putClientProperty("JTextField.variant", "search");
        this.putClientProperty("JTextField.Search.Prompt", "Search");
        this.setPreferredSize(new Dimension(80, 25));
        this.setFont(NORMAL_FONT);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SearchBar.this.searchBoxFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                SearchBar.this.searchBoxFocusLost(evt);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                SearchBar.this.searchBoxKey(e);
            }
        });
        this.observer.addPropertyChangeListener(new SearchAction());
    }

    private void searchBoxKey(KeyEvent e) {
        this.setFont(NORMAL_FONT);
        if (this.getText().length() > 1 || e.getKeyCode() == 10) {
            this.observer.firePropertyChange("Searching started", null, this.getText());
        }
    }

    private void searchBoxFocusGained(FocusEvent evt) {
        this.setFont(NORMAL_FONT);
        this.setFont(this.getFont().deriveFont(0));
    }

    private void searchBoxFocusLost(FocusEvent evt) {
        this.setFont(NORMAL_FONT);
        this.setFont(this.getFont().deriveFont(2));
    }

    static {
        Map<TextAttribute, ?> attributes = NORMAL_FONT.getAttributes();
        attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        attributes.put(TextAttribute.FOREGROUND, Color.RED.darker());
        NOTFOUND_FONT = new Font(attributes);
    }

    private class SearchAction
    implements PropertyChangeListener,
    Iterator<Spot> {
        private Iterator<Spot> iterator;
        private Iterator<Integer> trackIterator;

        public SearchAction() {
            this.trackIterator = SearchBar.this.model.getTrackModel().trackIDs(true).iterator();
            if (this.trackIterator.hasNext()) {
                Integer currentTrackID = this.trackIterator.next();
                Spot trackStart = this.firstSpotOf(currentTrackID);
                this.iterator = SearchBar.this.model.getTrackModel().getSortedDepthFirstIterator(trackStart, Spot.nameComparator, false);
            } else {
                this.iterator = Collections.EMPTY_LIST.iterator();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String text = (String)evt.getNewValue();
            if (!text.isEmpty()) {
                this.search(text);
            }
        }

        private void search(String text) {
            Spot spot;
            Spot start = null;
            while ((spot = this.next()) != start) {
                if (start == null) {
                    start = spot;
                }
                if (!spot.getName().contains(text)) continue;
                SearchBar.this.view.centerViewOn(spot);
                return;
            }
            SearchBar.this.setFont(NOTFOUND_FONT);
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public Spot next() {
            if (null == this.iterator || !this.iterator.hasNext()) {
                if (null == this.trackIterator || !this.trackIterator.hasNext()) {
                    this.trackIterator = SearchBar.this.model.getTrackModel().trackIDs(true).iterator();
                }
                Integer currentTrackID = this.trackIterator.next();
                Spot trackStart = this.firstSpotOf(currentTrackID);
                this.iterator = SearchBar.this.model.getTrackModel().getSortedDepthFirstIterator(trackStart, Spot.nameComparator, false);
            }
            return this.iterator.next();
        }

        private Spot firstSpotOf(Integer trackID) {
            ArrayList<Spot> trackSpots = new ArrayList<Spot>(SearchBar.this.model.getTrackModel().trackSpots(trackID));
            Collections.sort(trackSpots, Spot.frameComparator);
            return (Spot)trackSpots.get(0);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

