/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.plugin.removedetections;

import ij.ImagePlus;
import ij.gui.OvalRoi;
import ij.gui.Overlay;
import ij.gui.Roi;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.sequence.ImgLoader;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.ViewDescription;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.type.numeric.real.FloatType;
import spim.fiji.spimdata.SpimData2;
import spim.fiji.spimdata.interestpoints.InterestPoint;
import spim.fiji.spimdata.interestpoints.InterestPointList;
import spim.fiji.spimdata.interestpoints.ViewInterestPointLists;
import spim.fiji.spimdata.interestpoints.ViewInterestPoints;
import spim.process.fusion.deconvolution.ExtractPSF;

public class InteractiveProjections {
    public static double size = 2.0;
    final Frame frame;
    protected boolean isRunning = true;
    protected boolean wasCanceled = false;
    protected ImagePlus imp;
    protected List<InterestPoint> ipList;
    protected final List<Thread> runAfterFinished = new ArrayList<Thread>();

    public InteractiveProjections(SpimData2 spimData, ViewDescription vd, String label, String newLabel, int projectionDim) {
        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + ": Loading image ...");
        RandomAccessibleInterval img = ((ImgLoader)((SequenceDescription)spimData.getSequenceDescription()).getImgLoader()).getSetupImgLoader(vd.getViewSetupId()).getFloatImage(vd.getTimePointId(), false, new ImgLoaderHint[0]);
        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + ": Computing max projection along dimension " + projectionDim + " ...");
        Img maxProj = ExtractPSF.computeMaxProjection(img, new ArrayImgFactory(), projectionDim);
        this.imp = this.showProjection(maxProj);
        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + ": Loading & drawing interest points ...");
        this.ipList = this.loadInterestPoints(spimData, (ViewId)vd, label);
        InteractiveProjections.drawProjectedInterestPoints(this.imp, this.ipList, projectionDim);
        IOFunctions.println("(" + new Date(System.currentTimeMillis()) + ": " + this.ipList.size() + " points displayed ... ");
        this.frame = new Frame("Remove detections");
        this.frame.setSize(300, 180);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        Button removeIn = new Button("Remove all detections INside ROI");
        Button removeOut = new Button("Remove all detections OUTside ROI");
        Button done = new Button("Done");
        Button cancel = new Button("Cancel");
        this.frame.setLayout(layout);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        this.frame.add((Component)removeIn, c);
        ++c.gridy;
        this.frame.add((Component)removeOut, c);
        c.insets = new Insets(20, 0, 0, 0);
        ++c.gridy;
        this.frame.add((Component)done, c);
        c.insets = new Insets(0, 0, 0, 0);
        ++c.gridy;
        this.frame.add((Component)cancel, c);
        removeIn.addActionListener(new RemoveInsideROIButtonListener(this.imp, this.ipList, projectionDim, true));
        removeOut.addActionListener(new RemoveInsideROIButtonListener(this.imp, this.ipList, projectionDim, false));
        done.addActionListener(new FinishedButtonListener(this.frame, false));
        cancel.addActionListener(new FinishedButtonListener(this.frame, true));
        this.frame.setVisible(true);
    }

    public void runWhenDone(Thread thread) {
        this.runAfterFinished.add(thread);
    }

    public List<InterestPoint> getInterestPointList() {
        return this.ipList;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean wasCanceled() {
        return this.wasCanceled;
    }

    protected static void drawProjectedInterestPoints(ImagePlus imp, List<InterestPoint> ipList, int projectionDim) {
        int xDim = InteractiveProjections.getXDim(projectionDim);
        int yDim = InteractiveProjections.getYDim(projectionDim);
        Overlay o = imp.getOverlay();
        if (o == null) {
            o = new Overlay();
            imp.setOverlay(o);
        }
        o.clear();
        for (InterestPoint ip : ipList) {
            double x = ip.getL()[xDim];
            double y = ip.getL()[yDim];
            OvalRoi or = new OvalRoi((double)Math.round(x - size), (double)Math.round(y - size), (double)Math.round(size * 2.0), (double)Math.round(size * 2.0));
            or.setStrokeColor(Color.green);
            o.add((Roi)or);
        }
        imp.updateAndDraw();
    }

    protected static int getXDim(int projectionDim) {
        if (projectionDim == 2) {
            return 0;
        }
        if (projectionDim == 1) {
            return 0;
        }
        return 1;
    }

    protected static int getYDim(int projectionDim) {
        if (projectionDim == 2) {
            return 1;
        }
        if (projectionDim == 1) {
            return 2;
        }
        return 2;
    }

    protected List<InterestPoint> loadInterestPoints(SpimData2 spimData, ViewId id, String label) {
        ViewInterestPoints interestPoints = spimData.getViewInterestPoints();
        ViewInterestPointLists lists = interestPoints.getViewInterestPointLists(id);
        InterestPointList list = lists.getInterestPointList(label);
        if (list.getInterestPoints() == null) {
            list.loadInterestPoints();
        }
        ArrayList<InterestPoint> newList = new ArrayList<InterestPoint>();
        for (InterestPoint p : list.getInterestPoints()) {
            newList.add(new InterestPoint(p.getId(), (double[])p.getL().clone()));
        }
        return newList;
    }

    protected ImagePlus showProjection(Img<FloatType> img) {
        ImagePlus imp = ImageJFunctions.wrapFloat(img, (String)"Max Projection");
        imp.show();
        return imp;
    }

    protected void close(Frame parent) {
        if (parent != null) {
            parent.dispose();
        }
        if (this.imp != null) {
            this.imp.close();
        }
        for (Thread t : this.runAfterFinished) {
            t.start();
        }
        this.isRunning = false;
    }

    protected class FinishedButtonListener
    implements ActionListener {
        final Frame parent;
        final boolean frameWasCanceled;

        public FinishedButtonListener(Frame parent, boolean frameWasCanceled) {
            this.parent = parent;
            this.frameWasCanceled = frameWasCanceled;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            InteractiveProjections.this.close(this.parent);
            InteractiveProjections.this.wasCanceled = this.frameWasCanceled;
        }
    }

    protected class RemoveInsideROIButtonListener
    implements ActionListener {
        final ImagePlus imp;
        final List<InterestPoint> ipList;
        final int projectionDim;
        final int xDim;
        final int yDim;
        final boolean inside;

        public RemoveInsideROIButtonListener(ImagePlus imp, List<InterestPoint> ipList, int projectionDim, boolean inside) {
            this.imp = imp;
            this.ipList = ipList;
            this.projectionDim = projectionDim;
            this.inside = inside;
            this.xDim = InteractiveProjections.getXDim(projectionDim);
            this.yDim = InteractiveProjections.getYDim(projectionDim);
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Roi roi = this.imp.getRoi();
            if (roi == null) {
                IOFunctions.println("No ROI selected in max projection image.");
            } else {
                int count = this.ipList.size();
                for (int i = this.ipList.size() - 1; i >= 0; --i) {
                    double[] l = this.ipList.get(i).getL();
                    boolean contains = roi.contains((int)Math.round(l[this.xDim]), (int)Math.round(l[this.yDim]));
                    if ((!this.inside || !contains) && (this.inside || contains)) continue;
                    this.ipList.remove(i);
                }
                InteractiveProjections.drawProjectedInterestPoints(this.imp, this.ipList, this.projectionDim);
                IOFunctions.println("(" + new Date(System.currentTimeMillis()) + ": " + this.ipList.size() + " points remaining, removed " + (count - this.ipList.size()) + " points ... ");
            }
        }
    }
}

