/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.notebook.mime;

import java.io.IOException;
import java.util.List;
import net.imagej.notebook.mime.HTMLObject;
import net.imagej.notebook.mime.MIMEConverter;
import org.apache.commons.text.StringEscapeUtils;
import org.scijava.convert.ConvertService;
import org.scijava.convert.Converter;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Converter.class, priority=-10000.0)
public class ListToHTMLConverter
extends MIMEConverter<List<?>, HTMLObject> {
    @Parameter
    private ConvertService convertService;

    @Override
    protected HTMLObject convert(List<?> list) {
        return () -> this.html(list);
    }

    private String html(List<?> list) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (Object item : list) {
            sb.append(this.html(item));
        }
        return sb.toString();
    }

    private String html(Object o) throws IOException {
        HTMLObject htmlObj = (HTMLObject)this.convertService.convert(o, HTMLObject.class);
        return htmlObj == null ? ListToHTMLConverter.escape(o.toString()) : htmlObj.data();
    }

    private static String escape(String text) {
        return StringEscapeUtils.escapeHtml4((String)text);
    }
}

