/*
 * Decompiled with CFR 0.152.
 */
package numericalMethods.calculus.minimizing;

import java.io.Serializable;
import numericalMethods.function.nmDoubleArrayValued;
import numericalMethods.function.nmDoubleParametrized;

public class nmLineND
implements nmDoubleArrayValued,
nmDoubleParametrized,
Serializable {
    private static final long serialVersionUID = 1L;
    protected double[] point;
    protected double[] direction;
    protected int n;
    protected double t;

    public nmLineND(double[] aPoint, double[] aDirection) {
        this.n = aPoint.length;
        if (this.n != aDirection.length) {
            throw new IllegalArgumentException(" dimension of direction and point do not coincide ");
        }
        this.point = aPoint;
        this.direction = aDirection;
    }

    public double getT() {
        return this.t;
    }

    public void setT(double v) {
        this.t = v;
    }

    public int getN() {
        return this.n;
    }

    public void setN(int v) {
        this.n = v;
    }

    public double[] getDirection() {
        return this.direction;
    }

    public void setDirection(double[] v) {
        if (v.length != this.n) {
            throw new IllegalArgumentException(" dimension of direction is not ".concat(String.valueOf(String.valueOf(this.n))));
        }
        this.direction = v;
    }

    public double[] getPoint() {
        return this.point;
    }

    public void setPoint(double[] v) {
        if (v.length != this.n) {
            throw new IllegalArgumentException(" dimension of point is not ".concat(String.valueOf(String.valueOf(this.n))));
        }
        this.direction = v;
    }

    @Override
    public void setDoubleParameter(double p) {
        this.t = p;
    }

    public double[] getDoubleArrayValue() {
        double[] doubleArrayValue = new double[this.n];
        this.getDoubleArrayValue(doubleArrayValue, 0);
        return doubleArrayValue;
    }

    @Override
    public final int getDoubleArrayValueLength() {
        return this.n;
    }

    public final void getValue(double[] value) {
        this.getDoubleArrayValue(value, 0);
    }

    @Override
    public final void getDoubleArrayValue(double[] value, int offset) {
        int i = 0;
        int j = offset;
        while (i < this.n) {
            value[j] = this.point[i] + this.t * this.direction[i];
            ++i;
            ++j;
        }
    }
}

