/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.render;

import java.util.Arrays;

class MovingAverage {
    private final double[] values;
    private final int width;
    private int index = 0;
    private double average;

    public MovingAverage(int width) {
        this.values = new double[width];
        this.width = width;
    }

    public void init(double initialValue) {
        Arrays.fill(this.values, initialValue);
        this.average = initialValue;
    }

    public void add(double value) {
        this.average += (value - this.values[this.index]) / (double)this.width;
        this.values[this.index] = value;
        this.index = (this.index + 1) % this.width;
    }

    public double getAverage() {
        return this.average;
    }
}

