/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.omevisual.gui;

import java.awt.Component;
import java.io.IOException;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.layout.AnchorPane;
import javax.swing.JFrame;
import loci.formats.ome.OMEXMLMetadata;
import net.imagej.ImageJ;
import net.imagej.display.ImageDisplay;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import sc.fiji.omevisual.gui.view.RootLayoutController;

public class MainAppFrame
extends JFrame {
    @Parameter
    private LogService log;
    private final ImageJ ij;
    private JFXPanel fxPanel;
    private final ImageDisplay image;
    private final OMEXMLMetadata md;

    public MainAppFrame(ImageJ ij, ImageDisplay image, OMEXMLMetadata md) {
        ij.context().inject((Object)this);
        this.ij = ij;
        this.image = image;
        this.md = md;
    }

    public void init() {
        this.fxPanel = new JFXPanel();
        this.add((Component)this.fxPanel);
        this.setVisible(true);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MainAppFrame.this.initFX(MainAppFrame.this.fxPanel);
            }
        });
    }

    public void initFX(JFXPanel fxPanel) {
        try {
            FXMLLoader loader = new FXMLLoader();
            loader.setLocation(MainAppFrame.class.getResource("/sc/fiji/omevisual/gui/view/RootLayout.fxml"));
            AnchorPane rootLayout = (AnchorPane)loader.load();
            RootLayoutController controller = (RootLayoutController)loader.getController();
            controller.setContext(this.ij.context());
            controller.setImage(this.image);
            Scene scene = new Scene((Parent)rootLayout);
            this.fxPanel.setScene(scene);
            this.setSize((int)scene.getWidth(), (int)scene.getHeight());
            controller.fill(this.md);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

