/*
 * Decompiled with CFR 0.152.
 */
package io.scif.ome.translators;

import io.scif.Metadata;
import io.scif.formats.BMPFormat;
import io.scif.ome.OMEMetadata;
import io.scif.ome.translators.ToOMETranslator;
import ome.units.UNITS;
import ome.units.quantity.Length;
import org.scijava.plugin.Plugin;

public class BMPTranslator {

    @Plugin(type=ToOMETranslator.class, priority=100.0)
    public static class BMPOMETranslator
    extends ToOMETranslator<BMPFormat.Metadata> {
        public Class<? extends Metadata> source() {
            return BMPFormat.Metadata.class;
        }

        public Class<? extends Metadata> dest() {
            return OMEMetadata.class;
        }

        protected void translateFormatMetadata(BMPFormat.Metadata source, OMEMetadata dest) {
            double correctedY;
            Integer pixelSizeX = (Integer)source.getTable().get((Object)"X resolution");
            Integer pixelSizeY = (Integer)source.getTable().get((Object)"Y resolution");
            double correctedX = pixelSizeX == null || pixelSizeX == 0 ? 0.0 : 1000000.0 / (double)pixelSizeX.intValue();
            double d = correctedY = pixelSizeY == null || pixelSizeY == 0 ? 0.0 : 1000000.0 / (double)pixelSizeY.intValue();
            if (correctedX > 0.0) {
                dest.getRoot().setPixelsPhysicalSizeX(new Length((Number)correctedX, UNITS.MICROMETER), 0);
            } else {
                this.log().warn((Object)("Expected positive value for PhysicalSizeX; got " + correctedX));
            }
            if (correctedY > 0.0) {
                dest.getRoot().setPixelsPhysicalSizeY(new Length((Number)correctedY, UNITS.MICROMETER), 0);
            } else {
                this.log().warn((Object)("Expected positive value for PhysicalSizeY; got " + correctedY));
            }
        }
    }
}

