/*
 * Decompiled with CFR 0.152.
 */
package io.scif.ome.translators;

import io.scif.FormatException;
import io.scif.Metadata;
import io.scif.common.DateTools;
import io.scif.formats.MicromanagerFormat;
import io.scif.ome.OMEMetadata;
import io.scif.ome.services.OMEMetadataService;
import io.scif.ome.translators.FromOMETranslator;
import io.scif.ome.translators.ToOMETranslator;
import java.io.IOException;
import java.util.List;
import loci.formats.ome.OMEXMLMetadata;
import ome.units.UNITS;
import ome.units.quantity.ElectricPotential;
import ome.units.quantity.Length;
import ome.units.quantity.Temperature;
import ome.units.quantity.Time;
import ome.xml.model.primitives.Timestamp;
import org.scijava.io.handle.DataHandleService;
import org.scijava.io.location.BrowsableLocation;
import org.scijava.io.location.Location;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

public class MicromanagerTranslator {

    @Plugin(type=FromOMETranslator.class, priority=100.0)
    public static class MicromanagerOMETranslator
    extends ToOMETranslator<MicromanagerFormat.Metadata> {
        @Parameter
        private OMEMetadataService omexmlMetadataService;
        @Parameter
        private DataHandleService dataHandleService;

        public Class<? extends Metadata> source() {
            return MicromanagerFormat.Metadata.class;
        }

        public Class<? extends Metadata> dest() {
            return OMEMetadata.class;
        }

        protected void translateFormatMetadata(MicromanagerFormat.Metadata source, OMEMetadata dest) {
            try {
                this.populateMetadata(source, dest.getRoot());
            }
            catch (FormatException | IOException e) {
                this.log().error((Object)"Error populating Metadata store with Micromanager metadata", e);
            }
        }

        private void populateMetadata(MicromanagerFormat.Metadata meta, OMEXMLMetadata store) throws FormatException, IOException {
            String instrumentID = this.omexmlMetadataService.createLSID("Instrument", 0);
            store.setInstrumentID(instrumentID, 0);
            List positions = meta.getPositions();
            for (int i = 0; i < positions.size(); ++i) {
                String date;
                MicromanagerFormat.Position p = (MicromanagerFormat.Position)positions.get(i);
                if (p.time != null && (date = DateTools.formatDate((String)p.time, (String)"EEE MMM dd HH:mm:ss zzz yyyy")) != null) {
                    store.setImageAcquisitionDate(new Timestamp(date), i);
                }
                if (positions.size() > 1) {
                    BrowsableLocation parent = p.metadataFile.parent();
                    store.setImageName(parent.getName(), i);
                }
                store.setImageDescription(p.comment, i);
                store.setImageInstrumentRef(instrumentID, i);
                for (int c = 0; c < p.channels.length; ++c) {
                    store.setChannelName(p.channels[c], i, c);
                }
                if (p.pixelSize != null && p.pixelSize > 0.0) {
                    store.setPixelsPhysicalSizeX(new Length((Number)p.pixelSize, UNITS.MICROMETER), i);
                    store.setPixelsPhysicalSizeY(new Length((Number)p.pixelSize, UNITS.MICROMETER), i);
                } else {
                    this.log().warn((Object)("Expected positive value for PhysicalSizeX; got " + p.pixelSize));
                }
                if (p.sliceThickness != null && p.sliceThickness > 0.0) {
                    store.setPixelsPhysicalSizeZ(new Length((Number)p.sliceThickness, UNITS.MICROMETER), i);
                } else {
                    this.log().warn((Object)("Expected positive value for PhysicalSizeZ; got " + p.sliceThickness));
                }
                int nextStamp = 0;
                int q = 0;
                while ((long)q < meta.get(i).getPlaneCount()) {
                    store.setPlaneExposureTime(new Time((Number)p.exposureTime, UNITS.SECOND), i, q);
                    Location tiff = ((MicromanagerFormat.Position)positions.get(i)).getLocation(meta, i, (long)q);
                    if (tiff != null && this.dataHandleService.exists(tiff) && nextStamp < p.timestamps.length) {
                        store.setPlaneDeltaT(new Time((Number)p.timestamps[nextStamp++], UNITS.SECOND), i, q);
                    }
                    ++q;
                }
                String serialNumber = p.detectorID;
                p.detectorID = this.omexmlMetadataService.createLSID("Detector", 0, i);
                for (int c = 0; c < p.channels.length; ++c) {
                    store.setDetectorSettingsBinning(this.omexmlMetadataService.getBinning(p.binning), i, c);
                    store.setDetectorSettingsGain(new Double(p.gain), i, c);
                    if (c < p.voltage.size()) {
                        store.setDetectorSettingsVoltage(new ElectricPotential((Number)p.voltage.get(c), UNITS.VOLT), i, c);
                    }
                    store.setDetectorSettingsID(p.detectorID, i, c);
                }
                store.setDetectorID(p.detectorID, 0, i);
                if (p.detectorModel != null) {
                    store.setDetectorModel(p.detectorModel, 0, i);
                }
                if (serialNumber != null) {
                    store.setDetectorSerialNumber(serialNumber, 0, i);
                }
                if (p.detectorManufacturer != null) {
                    store.setDetectorManufacturer(p.detectorManufacturer, 0, i);
                }
                if (p.cameraMode == null) {
                    p.cameraMode = "Other";
                }
                store.setDetectorType(this.omexmlMetadataService.getDetectorType(p.cameraMode), 0, i);
                store.setImagingEnvironmentTemperature(new Temperature((Number)p.temperature, UNITS.CELSIUS), i);
            }
        }
    }
}

