/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter.sigma;

import net.imagej.ops.Contingent;
import net.imagej.ops.Ops;
import net.imagej.ops.filter.AbstractCenterAwareNeighborhoodBasedFilter;
import net.imagej.ops.filter.sigma.SigmaFilterOp;
import net.imagej.ops.map.neighborhood.AbstractCenterAwareComputerOp;
import net.imagej.ops.map.neighborhood.CenterAwareComputerOp;
import net.imagej.ops.special.computer.Computers;
import net.imagej.ops.special.computer.UnaryComputerOp;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Filter.Sigma.class, priority=-100.0)
public class DefaultSigmaFilter<T extends RealType<T>, V extends RealType<V>>
extends AbstractCenterAwareNeighborhoodBasedFilter<T, V>
implements SigmaFilterOp<T, V>,
Contingent {
    @Parameter
    private Double range;
    @Parameter
    private Double minPixelFraction;

    @Override
    protected CenterAwareComputerOp<T, V> unaryComputer(T inType, V outType) {
        AbstractCenterAwareComputerOp op = new AbstractCenterAwareComputerOp<T, V>(){
            private UnaryComputerOp<Iterable<T>, DoubleType> variance;

            @Override
            public void compute(Iterable<T> neighborhood, T center, V output) {
                if (this.variance == null) {
                    this.variance = Computers.unary(this.ops(), Ops.Stats.Variance.class, DoubleType.class, neighborhood, new Object[0]);
                }
                DoubleType varianceResult = new DoubleType();
                this.variance.compute(neighborhood, varianceResult);
                double varianceValue = varianceResult.getRealDouble() * DefaultSigmaFilter.this.range;
                double centerValue = center.getRealDouble();
                double sumAll = 0.0;
                double sumWithin = 0.0;
                long countAll = 0L;
                long countWithin = 0L;
                for (RealType neighbor : neighborhood) {
                    double pixelValue = neighbor.getRealDouble();
                    double diff = centerValue - pixelValue;
                    sumAll += pixelValue;
                    ++countAll;
                    if (diff > varianceValue || diff < -varianceValue) continue;
                    sumWithin += pixelValue;
                    ++countWithin;
                }
                if (countWithin < (long)((int)(DefaultSigmaFilter.this.minPixelFraction * (double)countAll))) {
                    output.setReal(sumAll / (double)countAll);
                } else {
                    output.setReal(sumWithin / (double)countWithin);
                }
            }
        };
        op.setEnvironment(this.ops());
        return op;
    }

    @Override
    public boolean conforms() {
        return this.range > 0.0;
    }
}

