/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.loaders.lw3d;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.Vector;
import org.jogamp.java3d.Behavior;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.DirectionalLight;
import org.jogamp.java3d.Light;
import org.jogamp.java3d.PointLight;
import org.jogamp.java3d.SpotLight;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.loaders.ParsingErrorException;
import org.jogamp.java3d.loaders.lw3d.EnvelopeHandler;
import org.jogamp.java3d.loaders.lw3d.LwLightObject;
import org.jogamp.java3d.loaders.lw3d.LwsEnvelopeLightIntensity;
import org.jogamp.java3d.loaders.lw3d.LwsFrame;
import org.jogamp.java3d.loaders.lw3d.LwsMotion;
import org.jogamp.java3d.loaders.lw3d.LwsPrimitive;
import org.jogamp.java3d.loaders.lw3d.TextfileParser;
import org.jogamp.vecmath.Color3f;
import org.jogamp.vecmath.Matrix4d;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Vector3f;

class LwsLight
extends TextfileParser
implements LwsPrimitive {
    String fileName;
    String objName;
    LwsMotion motion;
    int parent;
    TransformGroup objectTransform;
    Vector objectBehavior;
    Color3f color;
    int type;
    Point3f attenuation = new Point3f(1.0f, 0.0f, 0.0f);
    float spotConeAngle = (float)Math.PI;
    LwLightObject lwLight;
    LwsEnvelopeLightIntensity intensityEnvelope = null;
    Light light = null;
    static final int DIRECTIONAL = 0;
    static final int POINT = 1;
    static final int SPOT = 2;

    LwsLight(StreamTokenizer st, int totalFrames, float totalTime, int debugVals) throws ParsingErrorException {
        this.debugPrinter.setValidOutput(debugVals);
        this.debugOutput(1, "LwsLight()");
        this.color = new Color3f(1.0f, 1.0f, 1.0f);
        this.lwLight = new LwLightObject(null, 0.0f, null);
        this.parent = -1;
        this.debugOutputLn(8, "about to get LightName");
        this.getAndCheckString(st, "LightName");
        this.debugOutputLn(8, "about to get LightName value");
        this.objName = this.getName(st);
        this.debugOutputLn(8, "got LightName");
        this.skip(st, "ShowLight", 2);
        this.debugOutputLn(8, "got ShowLight");
        this.getAndCheckString(st, "LightMotion");
        this.debugOutputLn(8, "got LightMotion");
        this.motion = new LwsMotion(st, totalFrames, totalTime);
        this.debugOutputLn(8, "got motions");
        while (!this.isCurrentToken(st, "ShowCamera") && !this.isCurrentToken(st, "AddLight")) {
            this.debugOutputLn(8, "currentToken = " + st.sval);
            if (this.isCurrentToken(st, "ParentObject")) {
                this.parent = (int)this.getNumber(st);
            } else if (this.isCurrentToken(st, "LightColor")) {
                this.color.x = (float)this.getNumber(st) / 255.0f;
                this.color.y = (float)this.getNumber(st) / 255.0f;
                this.color.z = (float)this.getNumber(st) / 255.0f;
                this.lwLight.setColor(this.color);
            } else if (this.isCurrentToken(st, "LgtIntensity")) {
                String className = this.getClass().getName();
                int classIndex = className.lastIndexOf(46);
                String packageName = classIndex < 0 ? "" : className.substring(0, classIndex) + ".";
                EnvelopeHandler env = new EnvelopeHandler(st, totalFrames, totalTime, packageName + "LwsEnvelopeLightIntensity");
                if (env.hasValue) {
                    float intensity = env.theValue;
                    this.color.x *= intensity;
                    this.color.y *= intensity;
                    this.color.z *= intensity;
                    this.lwLight.setIntensity(intensity);
                } else {
                    this.intensityEnvelope = (LwsEnvelopeLightIntensity)env.theEnvelope;
                }
            } else if (this.isCurrentToken(st, "LightType")) {
                this.type = (int)this.getNumber(st);
            } else if (this.isCurrentToken(st, "Falloff")) {
                float falloff = (float)this.getNumber(st);
                this.attenuation.y = 1.0f / (1.0f - falloff) - 1.0f;
            } else if (this.isCurrentToken(st, "ConeAngle")) {
                this.spotConeAngle = (float)this.getNumber(st) * ((float)Math.PI / 180);
            }
            try {
                st.nextToken();
            }
            catch (IOException e) {
                throw new ParsingErrorException(e.getMessage());
            }
        }
        st.pushBack();
    }

    int getParent() {
        return this.parent;
    }

    void createJava3dObject(int loadBehaviors) {
        Matrix4d mat = new Matrix4d();
        mat.setIdentity();
        LwsFrame firstFrame = this.motion.getFirstFrame();
        firstFrame.setMatrix(mat);
        this.debugOutputLn(2, "Light transform = " + mat);
        Transform3D t1 = new Transform3D();
        t1.set(mat);
        this.objectTransform = new TransformGroup(t1);
        this.objectTransform.setCapability(18);
        Vector3f defaultDir = new Vector3f(0.0f, 0.0f, -1.0f);
        Point3f defaultPos = new Point3f(0.0f, 0.0f, 0.0f);
        switch (this.type) {
            case 0: {
                this.light = new DirectionalLight(this.color, defaultDir);
                break;
            }
            case 1: {
                this.light = new PointLight(this.color, defaultPos, this.attenuation);
                break;
            }
            case 2: {
                this.light = new SpotLight(this.color, defaultPos, this.attenuation, defaultDir, 2.0f * this.spotConeAngle, 0.0f);
                break;
            }
        }
        this.light.setCapability(15);
        if (this.light != null) {
            this.lwLight.setLight(this.light);
            BoundingSphere bounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100000.0);
            this.light.setInfluencingBounds(bounds);
            this.objectTransform.addChild(this.light);
            this.objectBehavior = new Vector();
            if (loadBehaviors != 0) {
                Behavior b = null;
                this.motion.createJava3dBehaviors(this.objectTransform);
                b = this.motion.getBehaviors();
                if (b != null) {
                    this.objectBehavior.addElement(b);
                }
                if (this.intensityEnvelope != null) {
                    b = null;
                    this.intensityEnvelope.createJava3dBehaviors(this.lwLight);
                    b = this.intensityEnvelope.getBehaviors();
                    if (b != null) {
                        this.objectBehavior.addElement(b);
                    }
                }
            }
        }
    }

    @Override
    public TransformGroup getObjectNode() {
        return this.objectTransform;
    }

    Light getLight() {
        return this.light;
    }

    @Override
    public Vector getObjectBehaviors() {
        this.debugOutputLn(1, "getObjectBehaviors()");
        return this.objectBehavior;
    }

    void printVals() {
        this.debugOutputLn(2, "  LIGHT vals: ");
        this.debugOutputLn(2, "   objName = " + this.objName);
        this.motion.printVals();
    }
}

