/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.reflection;

import org.renjin.eval.EvalException;
import org.renjin.invoke.ClassBinding;
import org.renjin.invoke.reflection.ClassBindingImpl;
import org.renjin.invoke.reflection.MemberBinding;
import org.renjin.invoke.reflection.StaticBinding;
import org.renjin.sexp.Symbol;

public class ClassDefinitionBinding
implements ClassBinding {
    private static final Symbol NEW = Symbol.get("new");
    private Class classInstance;
    private final ClassBindingImpl classBinding;
    private final ClassBindingImpl javaLangClassBinding;

    public ClassDefinitionBinding(Class classInstance, ClassBindingImpl classBinding) {
        this.classInstance = classInstance;
        this.classBinding = classBinding;
        this.javaLangClassBinding = ClassBindingImpl.get(Class.class);
    }

    @Override
    public MemberBinding getMemberBinding(Symbol name) {
        if (name == NEW) {
            return this.classBinding.getConstructorBinding();
        }
        StaticBinding staticMember = this.classBinding.getStaticMember(name);
        if (staticMember != null) {
            return staticMember;
        }
        MemberBinding instanceMember = this.javaLangClassBinding.getMemberBinding(name);
        if (instanceMember != null) {
            return instanceMember;
        }
        throw new EvalException("Class %s has no static member named '%s', nor does java.lang.Class have an instance member named '%s'", this.classBinding.getBoundClass().getName(), name, name);
    }
}

