/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.reflection.converters;

import org.renjin.eval.EvalException;
import org.renjin.invoke.reflection.converters.Converter;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.SEXP;

public class BooleanArrayConverter
implements Converter<Boolean[]> {
    public static final BooleanArrayConverter INSTANCE = new BooleanArrayConverter();

    public static boolean accept(Class clazz) {
        return clazz.isArray() && (clazz.getComponentType() == Boolean.class || clazz.getComponentType() == Boolean.TYPE);
    }

    public LogicalVector convertToR(Boolean[] value) {
        if (value == null) {
            return new LogicalArrayVector(LogicalVector.NA);
        }
        return new LogicalArrayVector(value);
    }

    @Override
    public Object convertToJava(SEXP value) {
        if (!(value instanceof AtomicVector)) {
            throw new EvalException("It's not an AtomicVector", value.getTypeName());
        }
        if (value.length() < 1) {
            return new Boolean[0];
        }
        LogicalVector lv = (LogicalVector)value;
        int length2 = lv.length();
        Boolean[] values = new Boolean[length2];
        for (int i = 0; i < length2; ++i) {
            values[i] = lv.getElementAsObject(i);
        }
        return values;
    }

    @Override
    public boolean acceptsSEXP(SEXP exp2) {
        return exp2 instanceof LogicalVector && exp2.length() >= 1;
    }

    @Override
    public int getSpecificity() {
        return 10;
    }
}

