/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.handle;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.Location;
import org.scijava.task.Task;

public final class DataHandles {
    private static Method utfMethod;

    private DataHandles() {
    }

    public static int writeUTF(String str, DataOutput out) throws IOException {
        try {
            return (Integer)DataHandles.utfMethod().invoke(null, str, out);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exc) {
            throw new IllegalStateException("Cannot invoke DataOutputStream.writeUTF(String, DataOutput)", exc);
        }
    }

    private static Method utfMethod() {
        if (utfMethod == null) {
            DataHandles.initUTFMethod();
        }
        return utfMethod;
    }

    private static synchronized void initUTFMethod() {
        if (utfMethod != null) {
            return;
        }
        try {
            Method m = DataOutputStream.class.getDeclaredMethod("writeUTF", String.class, DataOutput.class);
            m.setAccessible(true);
            utfMethod = m;
        }
        catch (NoSuchMethodException | SecurityException exc) {
            throw new IllegalStateException("No usable DataOutputStream.writeUTF(String, DataOutput)", exc);
        }
    }

    protected static IOException readOnlyException() {
        return new IOException("This handle is read-only!");
    }

    protected static IOException writeOnlyException() {
        return new IOException("This handle is write-only!");
    }

    public static long copy(DataHandle<Location> in, DataHandle<Location> out) throws IOException {
        return DataHandles.copy(in, out, 0L, null);
    }

    public static long copy(DataHandle<Location> in, DataHandle<Location> out, Task task) throws IOException {
        return DataHandles.copy(in, out, 0L, task);
    }

    public static long copy(DataHandle<Location> in, DataHandle<Location> out, int length) throws IOException {
        return DataHandles.copy(in, out, length, null);
    }

    public static long copy(DataHandle<Location> in, DataHandle<Location> out, long length, Task task) throws IOException {
        return DataHandles.copy(in, out, length, task, 65536);
    }

    public static long copy(DataHandle<Location> in, DataHandle<Location> out, long length, Task task, int bufferSize) throws IOException {
        long i = 0L;
        try {
            i = in.length();
        }
        catch (IOException exc) {
            i = 0L;
        }
        long inputlength = i;
        if (task != null) {
            if (length > 0L) {
                task.setProgressMaximum(length);
            } else if (inputlength > 0L) {
                task.setProgressMaximum(inputlength);
            }
        }
        byte[] buffer = new byte[bufferSize];
        long totalRead = 0L;
        while (task == null || !task.isCanceled()) {
            int r;
            if (length > 0L && totalRead + (long)bufferSize > length) {
                int remaining = (int)(length - totalRead);
                r = in.read(buffer, 0, remaining);
            } else {
                r = in.read(buffer);
            }
            if (r <= 0 || task != null && task.isCanceled()) break;
            out.write(buffer, 0, r);
            totalRead += (long)r;
            if (task == null) continue;
            task.setProgressValue(task.getProgressValue() + (long)r);
        }
        return totalRead;
    }
}

