/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.InputDeviceScheduler;
import org.scijava.java3d.J3dClock;
import org.scijava.java3d.VirtualUniverse;
import org.scijava.java3d.WakeupOnElapsedTime;
import org.scijava.java3d.WakeupOnElapsedTimeHeap;

class TimerThread
extends Thread {
    private static final int WAIT = 0;
    private static final int NOTIFY = 1;
    private static final int STOP = 2;
    private WakeupOnElapsedTimeHeap heap = new WakeupOnElapsedTimeHeap();
    private WakeupOnElapsedTime inputDeviceSchedCond = new WakeupOnElapsedTime(InputDeviceScheduler.samplingTime);
    private WakeupOnElapsedTime soundSchedCond = new WakeupOnElapsedTime(120000L);
    private volatile boolean running = true;
    private boolean waiting = false;
    private boolean ready = false;

    TimerThread(ThreadGroup t) {
        super(t, "J3D-TimerThread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(WakeupOnElapsedTime wakeup) {
        WakeupOnElapsedTimeHeap wakeupOnElapsedTimeHeap = this.heap;
        synchronized (wakeupOnElapsedTimeHeap) {
            this.heap.insert(wakeup);
        }
        this.runMonitor(1, 0L);
    }

    void addInputDeviceSchedCond() {
        this.inputDeviceSchedCond.triggeredTime = (long)InputDeviceScheduler.samplingTime + J3dClock.currentTimeMillis();
        this.add(this.inputDeviceSchedCond);
    }

    void addSoundSchedCond(long wakeupTime) {
        this.soundSchedCond.triggeredTime = wakeupTime;
        this.add(this.soundSchedCond);
    }

    void finish() {
        this.runMonitor(2, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(WakeupOnElapsedTime w) {
        WakeupOnElapsedTimeHeap wakeupOnElapsedTimeHeap = this.heap;
        synchronized (wakeupOnElapsedTimeHeap) {
            this.heap.extract(w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long waitTime = -1L;
        block3: while (this.running) {
            this.runMonitor(0, waitTime);
            long time = J3dClock.currentTimeMillis();
            while (true) {
                WakeupOnElapsedTime cond = null;
                waitTime = -1L;
                WakeupOnElapsedTimeHeap wakeupOnElapsedTimeHeap = this.heap;
                synchronized (wakeupOnElapsedTimeHeap) {
                    if (!this.heap.isEmpty() && (waitTime = this.heap.getMin().triggeredTime - time) <= 0L) {
                        cond = this.heap.extractMin();
                    }
                }
                if (cond == null) continue block3;
                if (cond == this.inputDeviceSchedCond) {
                    VirtualUniverse.mc.sendRunMessage(4);
                    continue;
                }
                if (cond == this.soundSchedCond) {
                    VirtualUniverse.mc.sendRunMessage(2);
                    continue;
                }
                cond.setTriggered();
            }
        }
    }

    synchronized void runMonitor(int action, long waitTime) {
        switch (action) {
            case 0: {
                if (this.running && !this.ready) {
                    this.waiting = true;
                    try {
                        if (waitTime < 0L) {
                            this.wait();
                        } else {
                            this.wait(waitTime);
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    this.waiting = false;
                }
                this.ready = false;
                break;
            }
            case 1: {
                this.ready = true;
                if (!this.waiting) break;
                this.notify();
                break;
            }
            case 2: {
                this.running = false;
                this.notify();
            }
        }
    }
}

