/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.gauss;

import mpicbg.imglib.algorithm.Benchmark;
import mpicbg.imglib.algorithm.MultiThreaded;
import mpicbg.imglib.algorithm.OutputAlgorithm;
import mpicbg.imglib.algorithm.gauss.GaussianConvolution3;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.function.RealTypeConverter;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.interpolation.Interpolator;
import mpicbg.imglib.interpolation.nearestneighbor.NearestNeighborInterpolatorFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorFactory;
import mpicbg.imglib.type.numeric.RealType;
import mpicbg.imglib.type.numeric.real.DoubleType;
import mpicbg.imglib.util.Util;

public class DownSample<T extends RealType<T>>
implements MultiThreaded,
OutputAlgorithm<T>,
Benchmark {
    Image<T> input;
    Image<T> downSampled;
    float sourceSigma;
    float targetSigma;
    int[] newSize;
    int[] imgSize;
    float[] scaling;
    String errorMessage = "";
    int numThreads;
    long processingTime;

    public DownSample(Image<T> image, int[] newSize, float sourceSigma, float targetSigma) {
        this.input = image;
        this.newSize = (int[])newSize.clone();
        this.setSourceSigma(sourceSigma);
        this.setTargetSigma(targetSigma);
        if (this.input != null) {
            this.imgSize = image.getDimensions();
            this.scaling = new float[image.getNumDimensions()];
            for (int d = 0; d < image.getNumDimensions(); ++d) {
                this.scaling[d] = (float)this.imgSize[d] / (float)newSize[d];
            }
        } else {
            this.imgSize = null;
            this.scaling = null;
        }
        this.setNumThreads();
        this.processingTime = -1L;
    }

    public DownSample(Image<T> image, float downSamplingFactor) {
        this.setInputImage(image);
        if (this.input != null) {
            this.setDownSamplingFactor(downSamplingFactor);
        }
        this.setSourceSigma(0.5f);
        this.setTargetSigma(0.5f);
        this.setNumThreads();
        this.processingTime = -1L;
    }

    public void setSourceSigma(float sourceSigma) {
        this.sourceSigma = sourceSigma;
    }

    public void setTargetSigma(float targetSigma) {
        this.targetSigma = targetSigma;
    }

    public void setDownSamplingFactor(float factor) {
        this.newSize = new int[this.input.getNumDimensions()];
        this.scaling = new float[this.input.getNumDimensions()];
        for (int d = 0; d < this.input.getNumDimensions(); ++d) {
            this.newSize[d] = Util.round((float)this.input.getDimension(d) * factor);
            this.scaling[d] = 1.0f / factor;
        }
    }

    public void setNewSize(int[] newSize) {
        this.newSize = (int[])newSize.clone();
    }

    public void setInputImage(Image<T> image) {
        this.input = image;
        this.imgSize = (int[])(this.input != null ? image.getDimensions() : null);
    }

    public float getSourceSigma() {
        return this.sourceSigma;
    }

    public float getTargetSigma() {
        return this.targetSigma;
    }

    public int[] getNewSize() {
        return (int[])this.newSize.clone();
    }

    public Image<T> getInputImage() {
        return this.input;
    }

    @Override
    public boolean process() {
        long startTime = System.currentTimeMillis();
        int numDimensions = this.input.getNumDimensions();
        double[] sigma = new double[numDimensions];
        for (int d = 0; d < numDimensions; ++d) {
            double s = this.targetSigma * this.scaling[d];
            sigma[d] = Math.sqrt(s * s - (double)(this.sourceSigma * this.sourceSigma));
        }
        ImageFactory<DoubleType> factory = new ImageFactory<DoubleType>(new DoubleType(), this.input.getContainerFactory());
        GaussianConvolution3<T, DoubleType, T> gauss = new GaussianConvolution3<T, DoubleType, T>(this.input, factory, this.input.getImageFactory(), new OutOfBoundsStrategyMirrorFactory(), new RealTypeConverter(), new RealTypeConverter(), sigma);
        gauss.setNumThreads(this.getNumThreads());
        if (!gauss.checkInput() || !gauss.process()) {
            this.errorMessage = "Gaussian Convolution failed: " + gauss.getErrorMessage();
            return false;
        }
        Image gaussConvolved = gauss.getResult();
        this.downSampled = this.input.createNewImage(this.newSize);
        Interpolator<T> interpolator = gaussConvolved.createInterpolator(new NearestNeighborInterpolatorFactory(new OutOfBoundsStrategyMirrorFactory()));
        LocalizableCursor<T> cursor = this.downSampled.createLocalizableCursor();
        int[] pos = new int[numDimensions];
        float[] scaledPos = new float[numDimensions];
        float[] scalingDim = (float[])this.scaling.clone();
        while (cursor.hasNext()) {
            cursor.fwd();
            cursor.getPosition(pos);
            for (int d = 0; d < numDimensions; ++d) {
                scaledPos[d] = (float)pos[d] * scalingDim[d];
            }
            interpolator.moveTo(scaledPos);
            ((RealType)cursor.getType()).set(interpolator.getType());
        }
        cursor.close();
        interpolator.close();
        gaussConvolved.close();
        this.processingTime = System.currentTimeMillis() - startTime;
        return true;
    }

    @Override
    public boolean checkInput() {
        if (this.errorMessage.length() > 0) {
            return false;
        }
        if (this.input == null) {
            this.errorMessage = "Input image is null";
            return false;
        }
        if (this.newSize == null) {
            this.errorMessage = "New size of image is null";
            return false;
        }
        for (int d = 0; d < this.input.getNumDimensions(); ++d) {
            if (this.newSize[d] <= this.imgSize[d]) continue;
            this.errorMessage = "New image supposed to be bigger than input image in dimension " + d + ", this algorithm is only for downsampling (" + this.newSize[d] + " > " + this.imgSize[d] + " )";
            return false;
        }
        return true;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public Image<T> getResult() {
        return this.downSampled;
    }

    @Override
    public long getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public int getNumThreads() {
        return this.numThreads;
    }

    @Override
    public void setNumThreads() {
        this.numThreads = Runtime.getRuntime().availableProcessors();
    }

    @Override
    public void setNumThreads(int numThreads) {
        this.numThreads = numThreads;
    }
}

