/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.algorithm.labeling;

import java.util.List;
import java.util.PriorityQueue;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.labeling.Labeling;
import mpicbg.imglib.labeling.LabelingType;
import mpicbg.imglib.type.numeric.ComplexType;

public class Watershed {
    public static <T extends ComplexType<T>, L extends Comparable<L>> void seededWatershed(Image<T> image, Labeling<L> seeds, int[][] structuringElement, Labeling<L> output) {
        assert (seeds.getNumDimensions() == image.getNumDimensions());
        assert (seeds.getNumDimensions() == output.getNumDimensions());
        for (int i = 0; i < structuringElement.length; ++i) {
            assert (structuringElement[i].length == seeds.getNumDimensions());
        }
        PriorityQueue pq = new PriorityQueue();
        LocalizableCursor c = seeds.createLocalizableCursor();
        LocalizableByDimCursor outputCursor = output.createLocalizableByDimCursor();
        LocalizableByDimCursor<T> ic = image.createLocalizableByDimCursor();
        int[] dimensions = output.getDimensions();
        int[] imageDimensions = image.getDimensions();
        int[] position = seeds.createPositionArray();
        int[] destPosition = seeds.createPositionArray();
        long age = 0L;
        for (LabelingType t : c) {
            List<Object> l = t.getLabeling();
            if (l.isEmpty()) continue;
            c.getPosition(position);
            boolean outofbounds = false;
            for (int i = 0; i < position.length; ++i) {
                if (position[i] < dimensions[i] && position[i] < imageDimensions[i]) continue;
                outofbounds = true;
                break;
            }
            if (outofbounds) continue;
            outputCursor.setPosition(position);
            l = ((LabelingType)outputCursor.getType()).intern(l);
            ((LabelingType)outputCursor.getType()).setLabeling(l);
            ic.setPosition(position);
            double intensity = ((ComplexType)ic.getType()).getRealDouble();
            pq.add(new PixelIntensity(position, dimensions, intensity, age++, l));
        }
        while (!pq.isEmpty()) {
            PixelIntensity currentPI = (PixelIntensity)pq.remove();
            List l = currentPI.getLabeling();
            currentPI.getPosition(position, dimensions);
            for (int[] offset : structuringElement) {
                boolean outofbounds = false;
                for (int i = 0; i < position.length; ++i) {
                    destPosition[i] = position[i] + offset[i];
                    if (destPosition[i] < dimensions[i] && destPosition[i] < imageDimensions[i] && destPosition[i] >= 0) continue;
                    outofbounds = true;
                }
                if (outofbounds) continue;
                outputCursor.setPosition(destPosition);
                if (!((LabelingType)outputCursor.getType()).getLabeling().isEmpty()) continue;
                ((LabelingType)outputCursor.getType()).setLabeling(l);
                ic.setPosition(position);
                double intensity = ((ComplexType)ic.getType()).getRealDouble();
                pq.add(new PixelIntensity(destPosition, dimensions, intensity, age++, l));
            }
        }
        c.close();
        outputCursor.close();
        ic.close();
    }

    protected static class PixelIntensity<T extends Comparable<T>>
    implements Comparable<PixelIntensity<T>> {
        protected final long index;
        protected final long age;
        protected final double intensity;
        protected final List<T> labeling;

        public PixelIntensity(int[] position, int[] dimensions, double intensity, long age, List<T> labeling) {
            long index = position[0];
            long multiplier = dimensions[0];
            for (int i = 1; i < dimensions.length; ++i) {
                index += (long)position[i] * multiplier;
                multiplier *= (long)dimensions[i];
            }
            this.index = index;
            this.intensity = intensity;
            this.labeling = labeling;
            this.age = age;
        }

        @Override
        public int compareTo(PixelIntensity<T> other) {
            int result = Double.compare(this.intensity, other.intensity);
            if (result == 0) {
                result = Double.compare(this.age, other.age);
            }
            return result;
        }

        void getPosition(int[] position, int[] dimensions) {
            long idx = this.index;
            for (int i = 0; i < dimensions.length; ++i) {
                position[i] = (int)(idx % (long)dimensions[i]);
                idx /= (long)dimensions[i];
            }
        }

        List<T> getLabeling() {
            return this.labeling;
        }
    }
}

