/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.basictypecontainer.array;

import mpicbg.imglib.container.basictypecontainer.BitAccess;
import mpicbg.imglib.container.basictypecontainer.array.ArrayDataAccess;

public class BitArray
implements BitAccess,
ArrayDataAccess<BitArray> {
    static final int bitsPerEntity = 32;
    final int numEntities;
    protected int[] data;

    public BitArray(int numEntities) {
        this.numEntities = numEntities;
        int numElements = this.numEntities % 32 == 0 ? this.numEntities / 32 : this.numEntities / 32 + 1;
        this.data = new int[numElements];
    }

    @Override
    public void close() {
        this.data = null;
    }

    @Override
    public boolean getValue(int index) {
        int arrayIndex = index / 32;
        int entry = this.data[arrayIndex];
        int arrayOffset = index % 32;
        int value = entry & 1 << arrayOffset;
        return value != 0;
    }

    @Override
    public void setValue(int index, boolean value) {
        int arrayIndex = index / 32;
        int arrayOffset = index % 32;
        this.data[arrayIndex] = value ? this.data[arrayIndex] | 1 << arrayOffset : this.data[arrayIndex] & ~(1 << arrayOffset);
    }

    public int[] getCurrentStorageArray() {
        return this.data;
    }

    @Override
    public BitArray createArray(int numEntities) {
        return new BitArray(numEntities);
    }
}

