/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.cursor.cell;

import mpicbg.imglib.container.cell.CellContainer;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.cell.CellLocalizableByDimCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategy;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.type.Type;

public class CellLocalizableByDimOutOfBoundsCursor<T extends Type<T>>
extends CellLocalizableByDimCursor<T>
implements LocalizableByDimCursor<T> {
    final OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory;
    final OutOfBoundsStrategy<T> outOfBoundsStrategy;
    boolean isOutOfBounds = false;

    public CellLocalizableByDimOutOfBoundsCursor(CellContainer<T, ?> container, Image<T> image, T type, OutOfBoundsStrategyFactory<T> outOfBoundsStrategyFactory) {
        super(container, image, type);
        this.outOfBoundsStrategyFactory = outOfBoundsStrategyFactory;
        this.outOfBoundsStrategy = outOfBoundsStrategyFactory.createStrategy(this);
        this.reset();
    }

    @Override
    public boolean hasNext() {
        if (!this.isOutOfBounds && this.cell < this.numCells - 1) {
            return true;
        }
        return this.type.getIndex() < this.cellMaxI - 1;
    }

    @Override
    public T getType() {
        if (this.isOutOfBounds) {
            return this.outOfBoundsStrategy.getType();
        }
        return (T)this.type;
    }

    @Override
    public void reset() {
        if (this.outOfBoundsStrategy == null) {
            return;
        }
        this.type.updateIndex(-1);
        this.cell = 0;
        this.getCellData(this.cell);
        this.isClosed = false;
        this.isOutOfBounds = false;
        this.position[0] = -1;
        this.cellPosition[0] = 0;
        for (int d = 1; d < this.numDimensions; ++d) {
            this.position[d] = 0;
            this.cellPosition[d] = 0;
        }
        this.cursor.setPosition(this.cellPosition);
        this.type.updateContainer(this);
    }

    @Override
    public void fwd() {
        if (!this.isOutOfBounds) {
            if (this.type.getIndex() < this.cellMaxI - 1) {
                this.type.incIndex();
                for (int d = 0; d < this.numDimensions; ++d) {
                    if (this.position[d] >= this.cellDimensions[d] + this.cellOffset[d] - 1) continue;
                    int n = d;
                    this.position[n] = this.position[n] + 1;
                    for (int e = 0; e < d; ++e) {
                        this.position[e] = this.cellOffset[e];
                    }
                    return;
                }
            } else if (this.cell < this.numCells - 1) {
                ++this.cell;
                this.type.updateIndex(0);
                this.getCellData(this.cell);
                for (int d = 0; d < this.numDimensions; ++d) {
                    this.position[d] = this.cellOffset[d];
                }
                this.container.getCellPosition(this.position, this.cellPosition);
                this.cursor.setPosition(this.cellPosition);
            } else {
                this.isOutOfBounds = true;
                this.lastCell = -1;
                this.cell = this.numCells;
                this.position[0] = this.position[0] + 1;
                this.outOfBoundsStrategy.initOutOfBOunds();
            }
        }
    }

    @Override
    public void move(int steps, int dim) {
        if (this.isOutOfBounds) {
            int n = dim;
            this.position[n] = this.position[n] + steps;
            if (this.position[dim] >= 0 && this.position[dim] < this.dimensions[dim]) {
                this.isOutOfBounds = false;
                for (int d = 0; d < this.numDimensions && !this.isOutOfBounds; ++d) {
                    if (this.position[d] >= 0 && this.position[d] < this.dimensions[d]) continue;
                    this.isOutOfBounds = true;
                }
                if (!this.isOutOfBounds) {
                    this.type.updateContainer(this);
                    this.container.getCellPosition(this.position, this.cellPosition);
                    this.cell = this.container.getCellIndex(this.cursor, this.cellPosition);
                    this.getCellData(this.cell);
                    this.type.updateIndex(this.cellInstance.getPosGlobal(this.position));
                } else {
                    this.outOfBoundsStrategy.notifyOutOfBOunds(steps, dim);
                }
            } else {
                this.outOfBoundsStrategy.notifyOutOfBOunds(steps, dim);
            }
        } else {
            int n = dim;
            this.position[n] = this.position[n] + steps;
            if (this.position[dim] < this.cellEnd[dim] && this.position[dim] >= this.cellOffset[dim]) {
                this.type.incIndex(this.step[dim] * steps);
            } else {
                this.setPosition(this.position[dim], dim);
            }
        }
    }

    @Override
    public void fwd(int dim) {
        if (this.isOutOfBounds) {
            int n = dim;
            this.position[n] = this.position[n] + 1;
            if (this.position[dim] == 0) {
                this.setPosition(this.position);
            } else {
                this.outOfBoundsStrategy.notifyOutOfBOundsFwd(dim);
            }
        } else if (this.position[dim] + 1 < this.cellEnd[dim]) {
            this.type.incIndex(this.step[dim]);
            int n = dim;
            this.position[n] = this.position[n] + 1;
        } else if (this.cellPosition[dim] < this.numCellsDim[dim] - 2) {
            this.cursor.fwd(dim);
            int n = dim;
            this.cellPosition[n] = this.cellPosition[n] + 1;
            this.cell += this.cellStep[dim];
            this.type.decIndex((this.position[dim] - this.cellOffset[dim]) * this.step[dim]);
            this.getCellData(this.cell);
            int n2 = dim;
            this.position[n2] = this.position[n2] + 1;
        } else if (this.cellPosition[dim] == this.numCellsDim[dim] - 2) {
            this.cursor.fwd(dim);
            int n = dim;
            this.cellPosition[n] = this.cellPosition[n] + 1;
            this.cell += this.cellStep[dim];
            this.getCellData(this.cell);
            int n3 = dim;
            this.position[n3] = this.position[n3] + 1;
            this.type.updateIndex(this.cellInstance.getPosGlobal(this.position));
        } else {
            this.isOutOfBounds = true;
            this.lastCell = -1;
            this.cell = this.numCells;
            int n = dim;
            this.position[n] = this.position[n] + 1;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void bck(int dim) {
        if (this.isOutOfBounds) {
            int n = dim;
            this.position[n] = this.position[n] - 1;
            if (this.position[dim] == this.dimensions[dim] - 1) {
                this.setPosition(this.position);
            } else {
                this.outOfBoundsStrategy.notifyOutOfBOundsBck(dim);
            }
        } else if (this.position[dim] - 1 >= this.cellOffset[dim]) {
            this.type.decIndex(this.step[dim]);
            int n = dim;
            this.position[n] = this.position[n] - 1;
        } else if (this.cellPosition[dim] == this.numCellsDim[dim] - 1 && this.numCells != 1) {
            this.cursor.bck(dim);
            int n = dim;
            this.cellPosition[n] = this.cellPosition[n] - 1;
            this.cell -= this.cellStep[dim];
            this.getCellData(this.cell);
            int n2 = dim;
            this.position[n2] = this.position[n2] - 1;
            this.type.updateIndex(this.cellInstance.getPosGlobal(this.position));
        } else if (this.cellPosition[dim] > 0) {
            this.cursor.bck(dim);
            int n = dim;
            this.cellPosition[n] = this.cellPosition[n] - 1;
            this.cell -= this.cellStep[dim];
            this.type.decIndex((this.position[dim] - this.cellOffset[dim]) * this.step[dim]);
            this.getCellData(this.cell);
            this.type.incIndex((this.cellDimensions[dim] - 1) * this.step[dim]);
            int n3 = dim;
            this.position[n3] = this.position[n3] - 1;
        } else {
            this.isOutOfBounds = true;
            this.lastCell = -1;
            this.cell = this.numCells;
            int n = dim;
            this.position[n] = this.position[n] - 1;
            this.outOfBoundsStrategy.initOutOfBOunds();
        }
    }

    @Override
    public void setPosition(int[] position) {
        boolean wasOutOfBounds = this.isOutOfBounds;
        this.isOutOfBounds = false;
        for (int d = 0; d < this.numDimensions; ++d) {
            this.position[d] = position[d];
            if (position[d] >= 0 && position[d] < this.dimensions[d]) continue;
            this.isOutOfBounds = true;
        }
        if (this.isOutOfBounds) {
            if (wasOutOfBounds) {
                this.outOfBoundsStrategy.notifyOutOfBOunds();
            } else {
                this.outOfBoundsStrategy.initOutOfBOunds();
            }
        } else {
            if (wasOutOfBounds) {
                this.type.updateContainer(this);
            }
            this.container.getCellPosition(position, this.cellPosition);
            this.cell = this.container.getCellIndex(this.cursor, this.cellPosition);
            this.getCellData(this.cell);
            this.type.updateIndex(this.cellInstance.getPosGlobal(position));
        }
    }

    @Override
    public void setPosition(int position, int dim) {
        this.position[dim] = position;
        if (this.isOutOfBounds || this.type.getIndex() == -1) {
            this.setPosition(this.position);
        } else {
            if (position < 0 || position >= this.dimensions[dim]) {
                this.isOutOfBounds = true;
                this.outOfBoundsStrategy.initOutOfBOunds();
                return;
            }
            this.cellPosition[dim] = this.container.getCellPosition(position, dim);
            this.cell = this.container.getCellIndex(this.cursor, this.cellPosition[dim], dim);
            this.getCellData(this.cell);
            this.type.updateIndex(this.cellInstance.getPosGlobal(this.position));
        }
    }
}

