/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.gcc.runtime;

import java.util.Arrays;
import org.renjin.gcc.runtime.LongPtr;
import org.renjin.gcc.runtime.Ptr;

public class DoublePtr
implements Ptr {
    public double[] array;
    public int offset;

    public DoublePtr(double[] array, int offset) {
        this.array = array;
        this.offset = offset;
    }

    public DoublePtr(double ... values) {
        this.array = values;
        this.offset = 0;
    }

    public String toString() {
        return this.offset + "+" + Arrays.toString(this.array);
    }

    public double unwrap() {
        return this.array[this.offset];
    }

    public double get(int i) {
        return this.array[this.offset + i];
    }

    public void set(int index, double value) {
        this.array[this.offset + index] = value;
    }

    public void update(double[] array, int offset) {
        this.array = array;
        this.offset = offset;
    }

    public static int memcmp(double[] x, int xi, double[] y, int yi, int n) {
        while (n > 0) {
            long yb;
            long xb = Double.doubleToRawLongBits(xi);
            if (xb != (yb = Double.doubleToRawLongBits(yi)) || n < 8) {
                LongPtr.memcmp(xb, yb, n);
            }
            ++xi;
            ++yi;
            n -= 8;
        }
        return 0;
    }

    public static void memset(double[] str, int strOffset, int c, int n) {
        assert (n % 64 == 0);
        long longValue = ((long)c & 0xFFL) << 56 | ((long)c & 0xFFL) << 48 | ((long)c & 0xFFL) << 40 | ((long)c & 0xFFL) << 32 | ((long)c & 0xFFL) << 24 | ((long)c & 0xFFL) << 16 | ((long)c & 0xFFL) << 8 | (long)c & 0xFFL;
        double doubleValue = Double.longBitsToDouble(longValue);
        Arrays.fill(str, strOffset, strOffset + c / 64, doubleValue);
    }
}

