/*
 * Decompiled with CFR 0.152.
 */
package util;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import util.FindConnectedRegions;

public class Find_Connected_Regions
implements PlugIn {
    public static final String PLUGIN_VERSION = "1.3";

    public void run(String ignored) {
        GenericDialog gd = new GenericDialog("Find Connected Regions Options (version: 1.3)");
        gd.addCheckbox("Allow_diagonal connections?", true);
        gd.addCheckbox("Display_image_for_each region?", false);
        gd.addCheckbox("Display_one_image for all regions?", true);
        gd.addCheckbox("Display_results table?", true);
        gd.addCheckbox("Regions_must have the same value?", false);
        gd.addCheckbox("Start_from_point selection?", false);
        gd.addCheckbox("Autosubtract discovered regions from original image?", false);
        gd.addNumericField("Regions_for_values_over: ", 100.0, 0);
        gd.addNumericField("Minimum_number_of_points in a region", 1.0, 0);
        gd.addNumericField("Stop_after this number of regions are found: ", -1.0, 0);
        gd.addMessage("(If number of regions is -1, find all of them.)");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        boolean diagonal = gd.getNextBoolean();
        boolean imagePerRegion = gd.getNextBoolean();
        boolean imageAllRegions = gd.getNextBoolean();
        boolean showResults = gd.getNextBoolean();
        boolean mustHaveSameValue = gd.getNextBoolean();
        boolean startFromPointROI = gd.getNextBoolean();
        boolean autoSubtract = gd.getNextBoolean();
        double valuesOverDouble = gd.getNextNumber();
        double minimumPointsInRegionDouble = gd.getNextNumber();
        int stopAfterNumberOfRegions = (int)gd.getNextNumber();
        ImagePlus imagePlus = IJ.getImage();
        if (imagePlus == null) {
            IJ.error((String)"No image to operate on.");
            return;
        }
        FindConnectedRegions fcr = new FindConnectedRegions();
        try {
            fcr.run(imagePlus, diagonal, imagePerRegion, imageAllRegions, showResults, mustHaveSameValue, startFromPointROI, autoSubtract, valuesOverDouble, minimumPointsInRegionDouble, stopAfterNumberOfRegions, false);
        }
        catch (IllegalArgumentException iae) {
            IJ.error((String)("" + iae));
            return;
        }
    }
}

