/*
 * Decompiled with CFR 0.152.
 */
package fiji.util;

import ij.CommandListener;
import ij.Executer;
import ij.IJ;
import ij.ImageJ;
import ij.Menus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class Recent_Commands
implements ActionListener,
CommandListener,
KeyListener,
ListSelectionListener,
PlugIn {
    protected static int recentListSize = 8;
    protected static int frequentListSize = 8;
    protected static int maxLRUSize = 100;
    protected static boolean suppressRepeatedCommands = true;
    protected static final String PREFS_KEY = "recent.command";
    JDialog dialog;
    JList mostRecent;
    JList mostFrequent;
    JButton okay;
    JButton cancel;
    JButton options;

    public void run(String arg) {
        this.readPrefs();
        if ("install".equals(arg)) {
            this.install();
        } else {
            new Thread(){

                @Override
                public void run() {
                    Recent_Commands.this.runInteractively();
                }
            }.start();
        }
    }

    public void install() {
        Executer.addCommandListener((CommandListener)this);
        if (IJ.getInstance() != null) {
            Menus.installPlugin((String)this.getClass().getName(), (char)'h', (String)"*recent commands", (String)"9", (ImageJ)IJ.getInstance());
        }
    }

    public void runInteractively() {
        Vector recent = this.getMostRecent(recentListSize);
        if (recent.size() == 0) {
            JOptionPane.showMessageDialog((Component)IJ.getInstance(), "No recent commands available!");
            return;
        }
        this.mostRecent = this.makeJList(recent);
        this.mostFrequent = this.makeJList(this.getMostFrequent(frequentListSize));
        this.mostRecent.setSelectedIndex(0);
        this.mostFrequent.clearSelection();
        this.dialog = new JDialog((Frame)IJ.getInstance(), "Recent Commands", true);
        this.dialog.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        this.dialog.add((Component)new JLabel("Recent Commands:"), c);
        ++c.gridy;
        c.gridx = 0;
        this.dialog.add((Component)this.mostRecent, c);
        ++c.gridy;
        c.gridx = 0;
        this.dialog.add((Component)new JLabel("Frequently used Commands:"), c);
        ++c.gridy;
        c.gridx = 0;
        this.dialog.add((Component)this.mostFrequent, c);
        this.okay = new JButton("OK");
        this.okay.addActionListener(this);
        this.okay.addKeyListener(this);
        this.dialog.getRootPane().setDefaultButton(this.okay);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        this.cancel.addKeyListener(this);
        this.options = new JButton("Options");
        this.options.addActionListener(this);
        this.options.addKeyListener(this);
        JPanel panel = new JPanel();
        panel.add(this.okay);
        panel.add(this.cancel);
        panel.add(this.options);
        ++c.gridy;
        c.gridx = 0;
        this.dialog.add((Component)panel, c);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    JList makeJList(Vector items) {
        JList list = new JList(items);
        list.setSelectionMode(0);
        list.addListSelectionListener(this);
        list.addKeyListener(this);
        list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    Recent_Commands.this.runSelectedCommand();
                    Recent_Commands.this.dialog.dispose();
                }
            }
        });
        return list;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.mostRecent) {
            if (this.mostRecent.getSelectedIndex() >= 0) {
                this.mostFrequent.clearSelection();
            }
        } else if (this.mostFrequent.getSelectedIndex() >= 0) {
            this.mostRecent.clearSelection();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okay) {
            this.runSelectedCommand();
        } else if (source == this.options) {
            this.showOptionsDialog();
            return;
        }
        this.dialog.dispose();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (key == 27) {
            this.dialog.dispose();
        } else {
            if (e.getSource() instanceof JButton) {
                if (key == 10) {
                    this.actionPerformed(new ActionEvent(e.getSource(), 0, ""));
                } else if (key == 38) {
                    this.mostFrequent.setSelectedIndex(this.mostFrequent.getModel().getSize() - 1);
                    this.mostFrequent.requestFocus();
                } else if (key == 40) {
                    this.mostRecent.setSelectedIndex(0);
                    this.mostRecent.requestFocus();
                } else if (key == 39) {
                    ((JButton)e.getSource()).transferFocus();
                } else if (key == 37) {
                    ((JButton)e.getSource()).transferFocusBackward();
                }
                return;
            }
            if (key == 10) {
                this.runSelectedCommand();
                this.dialog.dispose();
            } else if (e.getSource() == this.mostRecent) {
                if (key == 40 && this.mostRecent.getSelectedIndex() == this.mostRecent.getModel().getSize() - 1) {
                    this.mostFrequent.setSelectedIndex(0);
                    this.mostFrequent.requestFocus();
                } else if (key == 38 && this.mostRecent.getSelectedIndex() == 0) {
                    this.mostFrequent.setSelectedIndex(this.mostFrequent.getModel().getSize() - 1);
                    this.mostFrequent.requestFocus();
                }
            } else if (e.getSource() == this.mostFrequent) {
                if (key == 38 && this.mostFrequent.getSelectedIndex() == 0) {
                    this.mostRecent.setSelectedIndex(this.mostRecent.getModel().getSize() - 1);
                    this.mostRecent.requestFocus();
                } else if (key == 40 && this.mostFrequent.getSelectedIndex() == this.mostFrequent.getModel().getSize() - 1) {
                    this.mostRecent.setSelectedIndex(0);
                    this.mostRecent.requestFocus();
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public String commandExecuting(String command) {
        if (command.equals("*recent commands") || command.equals("Repeat a Recent Command")) {
            return command;
        }
        int listIndex = this.getListIndex();
        Prefs.set((String)(PREFS_KEY + listIndex), (String)command);
        listIndex = (listIndex + 1) % maxLRUSize;
        Prefs.set((String)"recent.command.lastIndex", (String)("" + listIndex));
        return command;
    }

    protected void runSelectedCommand() {
        String command = (String)this.mostRecent.getSelectedValue();
        if (command == null) {
            command = (String)this.mostFrequent.getSelectedValue();
        }
        if (command != null) {
            new Executer(command, null);
        }
    }

    protected int getListIndex() {
        String value = Prefs.get((String)"recent.command.lastIndex", (String)"0");
        return "".equals(value) ? 0 : Integer.parseInt(value);
    }

    protected Vector getMostRecent(int maxCount) {
        Vector<String> result = new Vector<String>();
        HashSet<String> all = suppressRepeatedCommands ? new HashSet<String>() : null;
        int listIndex = this.getListIndex();
        for (int i = 0; i < maxLRUSize; ++i) {
            listIndex = (listIndex - 1 + maxLRUSize) % maxLRUSize;
            String command = Prefs.get((String)(PREFS_KEY + listIndex), null);
            if (command == null) break;
            if (suppressRepeatedCommands) {
                if (all.contains(command)) continue;
                all.add(command);
            }
            result.add(command);
            if (result.size() >= maxCount) break;
        }
        return result;
    }

    protected Vector getMostFrequent(int maxCount) {
        String command;
        Vector<String> result = new Vector<String>();
        final HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < maxLRUSize && (command = Prefs.get((String)(PREFS_KEY + i), null)) != null; ++i) {
            Integer value = (Integer)map.get(command);
            if (value == null) {
                map.put(command, new Integer(1));
                result.add(command);
                continue;
            }
            map.put(command, new Integer(value + 1));
        }
        Collections.sort(result, new Comparator<String>(){

            @Override
            public int compare(String c1, String c2) {
                return (Integer)map.get(c2) - (Integer)map.get(c1);
            }

            @Override
            public boolean equals(Object other) {
                return false;
            }
        });
        return new Vector(result.subList(0, Math.min(result.size(), maxCount)));
    }

    void readPrefs() {
        recentListSize = (int)Prefs.get((String)"recent.command.recent-list-size", (double)recentListSize);
        frequentListSize = (int)Prefs.get((String)"recent.command.frequent-list-size", (double)frequentListSize);
        maxLRUSize = (int)Prefs.get((String)"recent.command.max-lru-size", (double)maxLRUSize);
        suppressRepeatedCommands = Prefs.get((String)"recent.command.suppress-repetitions", (boolean)suppressRepeatedCommands);
    }

    void showOptionsDialog() {
        boolean bool;
        GenericDialog gd = new GenericDialog("Recent Command Options");
        gd.addNumericField("size_of_recent_list", (double)recentListSize, 0);
        gd.addNumericField("size_of_most-frequent_list", (double)frequentListSize, 0);
        gd.addNumericField("history_size", (double)maxLRUSize, 0);
        gd.addCheckbox("suppress_repeated_commands", suppressRepeatedCommands);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        int value = (int)gd.getNextNumber();
        if (value != recentListSize) {
            recentListSize = value;
            Prefs.set((String)"recent.command.recent-list-size", (int)recentListSize);
        }
        if ((value = (int)gd.getNextNumber()) != frequentListSize) {
            frequentListSize = value;
            Prefs.set((String)"recent.command.frequent-list-size", (int)frequentListSize);
        }
        if ((value = (int)gd.getNextNumber()) != maxLRUSize) {
            maxLRUSize = value;
            Prefs.set((String)"recent.command.max-lru-size", (int)maxLRUSize);
        }
        if ((bool = gd.getNextBoolean()) != suppressRepeatedCommands) {
            suppressRepeatedCommands = bool;
            Prefs.set((String)"recent.command.suppress-repetitions", (boolean)suppressRepeatedCommands);
        }
        this.mostRecent.setListData(this.getMostRecent(recentListSize));
        this.mostFrequent.setListData(this.getMostFrequent(frequentListSize));
        this.dialog.pack();
    }
}

