/*
 * Decompiled with CFR 0.152.
 */
package bdv.ij;

import bdv.export.ExportMipmapInfo;
import bdv.export.ExportScalePyramid;
import bdv.export.ProgressWriter;
import bdv.export.ProposeMipmaps;
import bdv.export.SubTaskProgressWriter;
import bdv.export.n5.WriteSequenceToN5;
import bdv.ij.util.PluginHelper;
import bdv.ij.util.ProgressWriterIJ;
import bdv.img.cache.VolatileGlobalCellCache;
import bdv.img.imagestack.ImageStackImageLoader;
import bdv.img.n5.N5ImageLoader;
import bdv.img.virtualstack.VirtualStackImageLoader;
import bdv.spimdata.SequenceDescriptionMinimal;
import bdv.spimdata.SpimDataMinimal;
import bdv.spimdata.XmlIoSpimDataMinimal;
import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.WindowManager;
import java.awt.Checkbox;
import java.awt.TextField;
import java.awt.event.ItemEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.basictypeaccess.volatiles.array.VolatileByteArray;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.volatiles.VolatileUnsignedByteType;
import net.imglib2.util.Intervals;
import org.janelia.saalfeldlab.n5.Bzip2Compression;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.GzipCompression;
import org.janelia.saalfeldlab.n5.Lz4Compression;
import org.janelia.saalfeldlab.n5.RawCompression;
import org.janelia.saalfeldlab.n5.XzCompression;
import org.scijava.command.Command;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menuPath="Plugins>BigDataViewer>Export Current Image as XML/N5")
public class ExportImagePlusAsN5PlugIn
implements Command {
    static boolean lastSetMipmapManual = false;
    static String lastSubsampling = "";
    static String lastChunkSizes = "";
    static int lastCompressionChoice = 0;
    static boolean lastCompressionDefaultSettings = true;
    static String lastExportPath = "./export.xml";
    static int lastBzip2BlockSize = 9;
    static int lastGzipLevel = 6;
    static boolean lastGzipUseZlib = false;
    static int lastLz4BlockSize = 65536;
    static int lastXzLevel = 6;

    public static void main(String[] args) {
        new ImageJ();
        ImagePlus imp = IJ.openImage((String)"/Users/pietzsch/workspace/data/confocal-series.tif");
        imp.show();
        new ExportImagePlusAsN5PlugIn().run();
    }

    public void run() {
        Runnable clearCache;
        Object imgLoader;
        boolean isVirtual;
        ImagePlus imp;
        if (Prefs.setIJMenuBar) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        if ((imp = WindowManager.getCurrentImage()) == null) {
            IJ.showMessage((String)"Please open an image first.");
            return;
        }
        switch (imp.getType()) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                IJ.showMessage((String)"Only 8, 16, 32-bit images are supported currently!");
                return;
            }
        }
        if (imp.getNDimensions() < 2) {
            IJ.showMessage((String)"Image must be at least 2-dimensional!");
            return;
        }
        double pw = imp.getCalibration().pixelWidth;
        double ph = imp.getCalibration().pixelHeight;
        double pd = imp.getCalibration().pixelDepth;
        String punit = imp.getCalibration().getUnit();
        if (punit == null || punit.isEmpty()) {
            punit = "px";
        }
        FinalVoxelDimensions voxelSize = new FinalVoxelDimensions(punit, new double[]{pw, ph, pd});
        int w = imp.getWidth();
        int h = imp.getHeight();
        int d = imp.getNSlices();
        FinalDimensions size = new FinalDimensions(new int[]{w, h, d});
        int maxNumElements = 262144;
        ExportMipmapInfo autoMipmapSettings = ProposeMipmaps.proposeMipmaps((BasicViewSetup)new BasicViewSetup(0, "", (Dimensions)size, (VoxelDimensions)voxelSize), (int)262144);
        Parameters params = this.getParameters(autoMipmapSettings);
        if (params == null) {
            return;
        }
        ProgressWriterIJ progressWriter = new ProgressWriterIJ();
        progressWriter.out().println("starting export...");
        boolean bl = isVirtual = imp.getStack() != null && imp.getStack().isVirtual();
        if (isVirtual) {
            VirtualStackImageLoader<UnsignedByteType, VolatileUnsignedByteType, VolatileByteArray> il;
            switch (imp.getType()) {
                case 0: {
                    il = VirtualStackImageLoader.createUnsignedByteInstance(imp);
                    break;
                }
                case 1: {
                    il = VirtualStackImageLoader.createUnsignedShortInstance(imp);
                    break;
                }
                default: {
                    il = VirtualStackImageLoader.createFloatInstance(imp);
                }
            }
            imgLoader = il;
            clearCache = () -> ((VolatileGlobalCellCache)il.getCacheControl()).clearCache();
        } else {
            switch (imp.getType()) {
                case 0: {
                    imgLoader = ImageStackImageLoader.createUnsignedByteInstance(imp);
                    break;
                }
                case 1: {
                    imgLoader = ImageStackImageLoader.createUnsignedShortInstance(imp);
                    break;
                }
                default: {
                    imgLoader = ImageStackImageLoader.createFloatInstance(imp);
                }
            }
            clearCache = () -> {};
        }
        int numTimepoints = imp.getNFrames();
        int numSetups = imp.getNChannels();
        AffineTransform3D sourceTransform = new AffineTransform3D();
        sourceTransform.set(pw, 0.0, 0.0, 0.0, 0.0, ph, 0.0, 0.0, 0.0, 0.0, pd, 0.0);
        HashMap<Integer, BasicViewSetup> setups = new HashMap<Integer, BasicViewSetup>(numSetups);
        for (int s = 0; s < numSetups; ++s) {
            BasicViewSetup setup = new BasicViewSetup(s, String.format("channel %d", s + 1), (Dimensions)size, (VoxelDimensions)voxelSize);
            setup.setAttribute((Entity)new Channel(s + 1));
            setups.put(s, setup);
        }
        ArrayList<TimePoint> timepoints = new ArrayList<TimePoint>(numTimepoints);
        for (int t = 0; t < numTimepoints; ++t) {
            timepoints.add(new TimePoint(t));
        }
        SequenceDescriptionMinimal seq = new SequenceDescriptionMinimal(new TimePoints(timepoints), setups, imgLoader, null);
        HashMap<Integer, ExportMipmapInfo> perSetupExportMipmapInfo = new HashMap<Integer, ExportMipmapInfo>();
        ExportMipmapInfo mipmapInfo = new ExportMipmapInfo(params.resolutions, params.subdivisions);
        for (BasicViewSetup setup : seq.getViewSetupsOrdered()) {
            perSetupExportMipmapInfo.put(setup.getId(), mipmapInfo);
        }
        final long planeSizeInBytes = imp.getWidth() * imp.getHeight() * imp.getBytesPerPixel();
        final long ijMaxMemory = IJ.maxMemory();
        int numCellCreatorThreads = Math.max(1, PluginHelper.numThreads() - 1);
        ExportScalePyramid.LoopbackHeuristic loopbackHeuristic = new ExportScalePyramid.LoopbackHeuristic(){

            public boolean decide(RandomAccessibleInterval<?> originalImg, int[] factorsToOriginalImg, int previousLevel, int[] factorsToPreviousLevel, int[] chunkSize) {
                long requiredCacheSize;
                if (previousLevel < 0) {
                    return false;
                }
                if (Intervals.numElements((int[])factorsToOriginalImg) / Intervals.numElements((int[])factorsToPreviousLevel) >= 8L) {
                    return true;
                }
                return isVirtual && (requiredCacheSize = planeSizeInBytes * (long)factorsToOriginalImg[2] * (long)chunkSize[2]) > ijMaxMemory / 4L;
            }
        };
        ExportScalePyramid.AfterEachPlane afterEachPlane = new ExportScalePyramid.AfterEachPlane(){

            public void afterEachPlane(boolean usedLoopBack) {
                if (!usedLoopBack && isVirtual) {
                    long free = Runtime.getRuntime().freeMemory();
                    long total = Runtime.getRuntime().totalMemory();
                    long max = Runtime.getRuntime().maxMemory();
                    long actuallyFree = max - total + free;
                    if (actuallyFree < max / 2L) {
                        clearCache.run();
                    }
                }
            }
        };
        try {
            WriteSequenceToN5.writeN5File((AbstractSequenceDescription)seq, perSetupExportMipmapInfo, (Compression)params.compression, (File)params.n5File, (ExportScalePyramid.LoopbackHeuristic)loopbackHeuristic, (ExportScalePyramid.AfterEachPlane)afterEachPlane, (int)numCellCreatorThreads, (ProgressWriter)new SubTaskProgressWriter((ProgressWriter)progressWriter, 0.0, 0.95));
            N5ImageLoader n5Loader = new N5ImageLoader(params.n5File, null);
            SequenceDescriptionMinimal seqh5 = new SequenceDescriptionMinimal(seq, (BasicImgLoader)n5Loader);
            ArrayList<ViewRegistration> registrations = new ArrayList<ViewRegistration>();
            for (int t = 0; t < numTimepoints; ++t) {
                for (int s = 0; s < numSetups; ++s) {
                    registrations.add(new ViewRegistration(t, s, sourceTransform));
                }
            }
            File basePath = params.seqFile.getParentFile();
            SpimDataMinimal spimData = new SpimDataMinimal(basePath, seqh5, new ViewRegistrations(registrations));
            new XmlIoSpimDataMinimal().save((AbstractSpimData)spimData, params.seqFile.getAbsolutePath());
            progressWriter.setProgress(1.0);
        }
        catch (IOException | SpimDataException e) {
            throw new RuntimeException(e);
        }
        progressWriter.out().println("done");
    }

    protected Parameters getParameters(ExportMipmapInfo autoMipmapSettings) {
        RawCompression compression;
        File seqFile;
        String seqFilename;
        int[][] subdivisions;
        int[][] resolutions;
        while (true) {
            File parent;
            GenericDialogPlus gd = new GenericDialogPlus("Export for BigDataViewer as XML/N5");
            gd.addCheckbox("manual_mipmap_setup", lastSetMipmapManual);
            Checkbox cManualMipmap = (Checkbox)gd.getCheckboxes().lastElement();
            gd.addStringField("Subsampling_factors", lastSubsampling, 25);
            TextField tfSubsampling = (TextField)gd.getStringFields().lastElement();
            gd.addStringField("N5_chunk_sizes", lastChunkSizes, 25);
            TextField tfChunkSizes = (TextField)gd.getStringFields().lastElement();
            gd.addMessage("");
            String[] compressionChoices = new String[]{"raw (no compression)", "bzip", "gzip", "lz4", "xz"};
            gd.addChoice("compression", compressionChoices, compressionChoices[lastCompressionChoice]);
            gd.addCheckbox("default settings", lastCompressionDefaultSettings);
            gd.addMessage("");
            PluginHelper.addSaveAsFileField(gd, "Export_path", lastExportPath, 25);
            String autoSubsampling = ProposeMipmaps.getArrayString((int[][])autoMipmapSettings.getExportResolutions());
            String autoChunkSizes = ProposeMipmaps.getArrayString((int[][])autoMipmapSettings.getSubdivisions());
            gd.addDialogListener((dialog, e) -> {
                gd.getNextBoolean();
                gd.getNextString();
                gd.getNextString();
                gd.getNextChoiceIndex();
                gd.getNextBoolean();
                gd.getNextString();
                if (e instanceof ItemEvent && e.getID() == 701 && e.getSource() == cManualMipmap) {
                    boolean useManual = cManualMipmap.getState();
                    tfSubsampling.setEnabled(useManual);
                    tfChunkSizes.setEnabled(useManual);
                    if (!useManual) {
                        tfSubsampling.setText(autoSubsampling);
                        tfChunkSizes.setText(autoChunkSizes);
                    }
                }
                return true;
            });
            tfSubsampling.setEnabled(lastSetMipmapManual);
            tfChunkSizes.setEnabled(lastSetMipmapManual);
            if (!lastSetMipmapManual) {
                tfSubsampling.setText(autoSubsampling);
                tfChunkSizes.setText(autoChunkSizes);
            }
            gd.showDialog();
            if (gd.wasCanceled()) {
                return null;
            }
            lastSetMipmapManual = gd.getNextBoolean();
            lastSubsampling = gd.getNextString();
            lastChunkSizes = gd.getNextString();
            lastCompressionChoice = gd.getNextChoiceIndex();
            lastCompressionDefaultSettings = gd.getNextBoolean();
            lastExportPath = gd.getNextString();
            resolutions = PluginHelper.parseResolutionsString(lastSubsampling);
            subdivisions = PluginHelper.parseResolutionsString(lastChunkSizes);
            if (resolutions.length == 0) {
                IJ.showMessage((String)("Cannot parse subsampling factors " + lastSubsampling));
                continue;
            }
            if (subdivisions.length == 0) {
                IJ.showMessage((String)("Cannot parse n5 chunk sizes " + lastChunkSizes));
                continue;
            }
            if (resolutions.length != subdivisions.length) {
                IJ.showMessage((String)"subsampling factors and n5 chunk sizes must have the same number of elements");
                continue;
            }
            seqFilename = lastExportPath;
            if (!seqFilename.endsWith(".xml")) {
                seqFilename = seqFilename + ".xml";
            }
            if ((parent = (seqFile = new File(seqFilename)).getParentFile()) != null && parent.exists() && parent.isDirectory()) break;
            IJ.showMessage((String)("Invalid export filename " + seqFilename));
        }
        String n5Filename = seqFilename.substring(0, seqFilename.length() - 4) + ".n5";
        File n5File = new File(n5Filename);
        switch (lastCompressionChoice) {
            default: {
                compression = new RawCompression();
                break;
            }
            case 1: {
                compression = lastCompressionDefaultSettings ? new Bzip2Compression() : this.getBzip2Settings();
                break;
            }
            case 2: {
                compression = lastCompressionDefaultSettings ? new GzipCompression() : this.getGzipSettings();
                break;
            }
            case 3: {
                compression = lastCompressionDefaultSettings ? new Lz4Compression() : this.getLz4Settings();
                break;
            }
            case 4: {
                XzCompression xzCompression = compression = lastCompressionDefaultSettings ? new XzCompression() : this.getXzSettings();
            }
        }
        if (compression == null) {
            return null;
        }
        return new Parameters(lastSetMipmapManual, resolutions, subdivisions, seqFile, n5File, (Compression)compression);
    }

    protected Bzip2Compression getBzip2Settings() {
        while (true) {
            GenericDialogPlus gd = new GenericDialogPlus("Bzip2 compression settings");
            gd.addNumericField(String.format("block size (%d-%d)", 1, 9), (double)lastBzip2BlockSize, 0);
            gd.addMessage("as 100k units");
            gd.showDialog();
            if (gd.wasCanceled()) {
                return null;
            }
            lastBzip2BlockSize = (int)gd.getNextNumber();
            if (lastBzip2BlockSize >= 1 && lastBzip2BlockSize <= 9) break;
            IJ.showMessage((String)String.format("Block size must be in range [%d, %d]", 1, 9));
        }
        return new Bzip2Compression(lastBzip2BlockSize);
    }

    protected GzipCompression getGzipSettings() {
        while (true) {
            GenericDialogPlus gd = new GenericDialogPlus("Gzip compression settings");
            gd.addNumericField("level (0-9)", (double)lastGzipLevel, 0);
            gd.addCheckbox("use Zlib", lastGzipUseZlib);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return null;
            }
            lastGzipLevel = (int)gd.getNextNumber();
            lastGzipUseZlib = gd.getNextBoolean();
            if (lastGzipLevel >= 0 && lastGzipLevel <= 9) break;
            IJ.showMessage((String)"Level must be in range [0, 9]");
        }
        return new GzipCompression(lastGzipLevel, lastGzipUseZlib);
    }

    protected Lz4Compression getLz4Settings() {
        int COMPRESSION_LEVEL_BASE = 10;
        int MIN_BLOCK_SIZE = 64;
        int MAX_BLOCK_SIZE = 0x2000000;
        while (true) {
            GenericDialogPlus gd = new GenericDialogPlus("LZ4 compression settings");
            gd.addNumericField(String.format("block size (%d-%d)", 64, 0x2000000), (double)lastLz4BlockSize, 0, 8, null);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return null;
            }
            lastLz4BlockSize = (int)gd.getNextNumber();
            if (lastLz4BlockSize >= 64 && lastLz4BlockSize <= 0x2000000) break;
            IJ.showMessage((String)String.format("Block size must be in range [%d, %d]", 64, 0x2000000));
        }
        return new Lz4Compression(lastLz4BlockSize);
    }

    protected XzCompression getXzSettings() {
        while (true) {
            GenericDialogPlus gd = new GenericDialogPlus("XZ compression settings");
            gd.addNumericField("level (0-9)", (double)lastXzLevel, 0);
            gd.addMessage("LZMA2 preset level");
            gd.showDialog();
            if (gd.wasCanceled()) {
                return null;
            }
            lastXzLevel = (int)gd.getNextNumber();
            if (lastXzLevel >= 0 && lastXzLevel <= 9) break;
            IJ.showMessage((String)"Level must be in range [0, 9]");
        }
        return new XzCompression(lastXzLevel);
    }

    protected static class Parameters {
        final boolean setMipmapManual;
        final int[][] resolutions;
        final int[][] subdivisions;
        final File seqFile;
        final File n5File;
        final Compression compression;

        public Parameters(boolean setMipmapManual, int[][] resolutions, int[][] subdivisions, File seqFile, File n5File, Compression compression) {
            this.setMipmapManual = setMipmapManual;
            this.resolutions = resolutions;
            this.subdivisions = subdivisions;
            this.seqFile = seqFile;
            this.n5File = n5File;
            this.compression = compression;
        }
    }
}

